<?php
/**
 * FontStyles Model
 *
 * PHP version 8.4.2
 *
 * @category  FontStyles
 * @package   Assets
 * @author    lawren@imprintnext.com
 * @copyright 
 * @license   
 * @link      
 */

namespace App\Modules\Fonts\Models;

use App\Components\Controllers\Component as ParentController;

/**
 * Fonts
 *
 * @category FontStyles
 * @package  Assets
 * @author   lawren@imprintnext.com
 * @license  
 * @link     
 */

class FontStyle extends \Illuminate\Database\Eloquent\Model
{
    protected $table = 'font_styles';
    protected $primaryKey = 'xe_id';
    protected $fillable = ['style', 'file_name', 'font_family', 'font_id'];
    public $timestamps = false;
    
    public function font() {
        return $this->belongsTo(Font::class, 'font_id', 'xe_id');
    }

    public function getFileNameAttribute()
    {
        return path('read', 'font') . $this->attributes['file_name'];
    }
}