<?php
/**
 * Manage Color Swatches
 *
 * PHP version 5.6
 *
 * @category  Settings
 * @package   Eloquent
 * @author    Satyabrata <satyabratap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace App\Modules\Integration\Controllers;

use App\Components\Controllers\Component as ParentController;
use App\Modules\Settings\Models\Currency;
use App\Modules\Settings\Models\Language;
use App\Modules\Settings\Models\QuotationDynamicForm;
use App\Modules\Settings\Models\Setting;
use App\Modules\Settings\Models\Unit;
use App\Modules\Integration\Models\PluginSettings;
use Illuminate\Database\Capsule\Manager as DB;
use App\Modules\Orders\Controllers\OrdersController;
use App\Modules\Orders\Models\CatalogOrderRel;
use OrderStoreSpace\Controllers\StoreOrdersController;

use App\Modules\Users\Models\User;
use App\Modules\Users\Models\UserRole;
use App\Modules\Users\Controllers\UsersController;
use \Firebase\JWT\JWT;


/**
 * Setting Controller
 *
 * @category Class
 * @package  Setting
 * @author   Satyabrata <satyabratap@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class ZapController extends ParentController {	
	/**
	 * GET: Create Order in quickbook account
	 *
	 * @param $request  Slim's Request object
	 * @param $response Slim's Response object
	 *
	 * @author steve@imprintnext.com
	 * @date   28 Apr 2022
	 * @return int
	 */

	/**
	 * Get list of product or a Single product from the WooCommerce API
	 *
	 * @param $request  Slim's Request object
	 * @param $response Slim's Response object
	 * @param $args     Slim's Argument parameters
	 *
	 * @author steve@imprint.com
	 * @date   4 May 2022
	 * @return server status 200/401
	 */
	public function zapAuthenticate($request, $response, $args){
		$allPostPutVars = $request->getParsedBody();
		if (!empty($allPostPutVars)
			&& !empty($allPostPutVars['user_id']) && !empty($allPostPutVars['password'])
		){
			$userData = [
				'email' => $allPostPutVars['user_id'],
				'password' => $allPostPutVars['password'],
			];			
			$userObj = new User();
			$getUserDetails = $userObj->where('email', $userData['email']);
			$status = 1 ;
			 if ($getUserDetails->count() > 0) {
			 	$getUser = $getUserDetails->with('user_roles')
					->first()
					->toArray();
				// Verify Password in Database
				if (password_verify($userData['password'], $getUser['password'])) {
					$status = 1;
				}
				else{
					$status = 0;					
				}								
			 }else{
			 	$status = 0;
			 }
			 if($status == 0){
			 	header("HTTP/1.1 401 Unauthorized");
			 	exit;
			 }else {
			 	return json_encode(array("status"=> $status,"data"=>$allPostPutVars));
			 }	
		}
	}

	/**
	 * Get list of product or a Single product from the WooCommerce API
	 *
	 * @param $request  Slim's Request object
	 * @param $response Slim's Response object
	 * @param $args     Slim's Argument parameters
	 *
	 * @author steve@imprint.com
	 * @date   4 May 2022
	 * @return json
	 */
	public function zapGetOrders($request, $response, $args){		
		$email = $request->getQueryParam('email');
		$password = $request->getQueryParam('password');
		$userData = [
				'email' => $email,
				'password' => $password
			];
		$userObj = new User();
		$status  = 0;
		$getUserDetails = $userObj->where('email', $userData['email']);
		if ($getUserDetails->count() > 0) {
		 	$getUser = $getUserDetails->with('user_roles')
					->first()
					->toArray();
				// Verify Password in Database
				if (password_verify($userData['password'], $getUser['password'])) {
					$status = 1;
				}
				else{
					$status = 0;
				}
		 }
		 if($status == 1){
		 	$orderObj = new OrdersController();
			$storeResponse = $orderObj->getOrders($request, $response, $args);
			$orderDetails =  $storeResponse['order_details'];
			$zapOrders=[];
			$i = 0;
			$getJWTSecret = get_app_settings('jwt_secret');
			$jwtObj = new JWT();
			$jwt = $jwtObj->encode($token, $getJWTSecret);
			foreach ($orderDetails as $value) {
				$args['id'] = $value['id'];
				$args['list_exclude'] = ['base_code','overlogo','productDecoData','getProductDescription','poStatus','customDesignIDs'];
				$orderDetails = $orderObj->getOrderDetails($request, $response, $args, 1);
				if(!empty($orderDetails['data'])){
					$orderDetails = $orderDetails['data'] ;
					unset($orderDetails['designs']);
					$newDate = date("Y-m-d\TH:i:sO", strtotime($orderDetails['created_date']));
					$orderDetails['created_date'] = $newDate ;
					$orderDetails['order_id'] = $orderDetails['id'];
					$orderString = getRandomStringImp(6)."+".$value['id']."@".$value['order_number']."+".getRandomStringImp(6);
					$orderStringEncrypt = encryption($orderString);
					//$orderDetails['order_download_link'] = API_URL.'api/v1/order-download?is_download_store=true&order_id='.$value['id']."&order_increment_id=".$value['order_number'];
					$orderDetails['order_download_link'] = API_URL.'api/v1/order-download?is_download_store=true&_token='.$jwt."&token=".$orderStringEncrypt;
					$zapOrders[$i] = $orderDetails;
					foreach ($orderDetails['orders'] as $orderKey => $orderValue) {
						$decorationData = $orderValue['decoration_settings_data'];
						$newString = [];
						foreach ($decorationData as $decorateValue) {
							if (!empty($decorateValue['decoration_data'])) {
								$decorationName = $decorateValue['decoration_data'][0]['decoration_name'];
								$printProfileName = $decorateValue['decoration_data'][0]['print_profile_name'];
								$newString[] =  $decorationName . "#" . $printProfileName;
							}
						}
						$newString1 = implode(",", $newString);
						unset($zapOrders[$i]['orders'][$orderKey]['decoration_settings_data']);
						unset($zapOrders[$i]['orders'][$orderKey]['po_status']);
						$zapOrders[$i]['orders'][$orderKey]['designed_image'] = $orderValue['images'][0]['src'];
						$zapOrders[$i]['orders'][$orderKey]['print_profile'] = $newString1;
						if(!isset($zapOrders[$i]['public_url'])){
							$zapOrders[$i]['public_url'] = isset($orderValue['public_url'])? $orderValue['public_url'] : "";
						}
						if(!isset($zapOrders[$i]['artwork_status'])){
							$zapOrders[$i]['artwork_status'] = isset($orderValue['artwork_status'])? $orderValue['artwork_status'] : "";
						}
					} 
					$i++; 
			    }
			       
			}
			return json_encode($zapOrders,true);
		}else{
			header("HTTP/1.1 401 Unauthorized");
			exit;
		}
		
	}
}