<?php
/**
 * This Model used for Order Artwork Conversation
 * corresponding models
 *
 * PHP version 5.6
 *
 * @category  Orders
 * @package   Orders
 * @author    Diana <diana@imprintnext.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace App\Modules\Orders\Models;
/**
 * Orders Controller
 *
 * @category Orders
 * @package  Orders
 * @author   Diana <diana@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class ArtworkApprovalConversations extends \Illuminate\Database\Eloquent\Model {
	protected $table = 'artwork_approval_conversations';
	protected $primaryKey = 'xe_id';
	protected $fillable = [
		'order_artwork_id', 'user_type', 'user_id', 'message', 'seen_flag', 'created_date'
	];
	public $timestamps = false;


	/**
     * Get Internal Note Files
     *
     * @author debasrib@riaxe.com
     * @date   26 May 2020
     * @return file relation object
     */
    public function files()
    {
        return $this->hasMany(
            'App\Modules\Orders\Models\ArtworkApprovalConvFiles', 'conv_id'
        );
    }
}
