<?php
/**
 * Color Swatch Model
 *
 * PHP version 5.6
 *
 * @category  Color_Swatches
 * @package   Settings
 * @author    Satyabrata <satyabratap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */

namespace App\Modules\Settings\Models;

/**
 * Color Swatch
 *
 * @category Color_Swatch
 * @package  Settings
 * @author   Satyabrata <satyabratap@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */

class ColorSwatch extends \Illuminate\Database\Eloquent\Model
{
    public $timestamps = false;
    protected $primaryKey = 'xe_id';
    protected $fillable = ['attribute_id', 'hex_code', 'file_name', 'color_type' ,'cloud_storage'];
    protected $guarded = ['xe_id'];
}
