<?php
/**
 * Global Constants for the Application
 *
 * PHP version 5.6
 *
 * @category  Constants
 * @package   Configuration
 * @author    Tanmaya Patra <tanmayap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
/*
|--------------------------------------------------------------------------
| Switch between : production or development
|--------------------------------------------------------------------------
|
 */
defined('ENVIRONMENT') or define('ENVIRONMENT', 'production');

/*
|--------------------------------------------------------------------------
| Base Site URL. No need to change
|--------------------------------------------------------------------------
 */
$domainUrl = (isset($_SERVER['HTTPS'])
    && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
$domainUrl .= "://" . $_SERVER['HTTP_HOST'];

// Read XML File
$baseDIR = getcwd();
$xmlPath = $baseDIR . '/../../config.xml';
$getXMLContent = simplexml_load_file($xmlPath);
$storeConst = get_object_vars($getXMLContent->url_detail);
defined('BASE_DIR') or define('BASE_DIR', !empty($storeConst['xetool_dir']) ? $storeConst['xetool_dir'] : 'xetool');
defined('API_URL') or define('API_URL', !empty($storeConst['api_url']) ? $storeConst['api_url'] : '');
defined('WORKING_DIR') or define('WORKING_DIR', 'api/v1/');
defined('RELATIVE_PATH') or define('RELATIVE_PATH', $baseDIR);
defined('BASE_URL') or define('BASE_URL', API_URL . WORKING_DIR);
$base_url = rtrim(RELATIVE_PATH, WORKING_DIR);

defined('STORE_NAME') or define('STORE_NAME', !empty($storeConst['store_directory']) ? $storeConst['store_directory'] : '');
defined('STORE_VERSION') or define('STORE_VERSION', !empty($storeConst['store_version']) ? $storeConst['store_version'] : '');
defined('IS_HOSTED') or define('IS_HOSTED', !empty($storeConst['is_hosted']) ? $storeConst['is_hosted'] : 0);
defined('API_VER') or define('API_VER', !empty($storeConst['api_version']) ? $storeConst['api_version'] : '');
defined('API_CK') or define('API_CK', !empty($storeConst['api_key']) ? $storeConst['api_key'] : '');
defined('API_CS') or define('API_CS', !empty($storeConst['api_secret']) ? $storeConst['api_secret'] : '');
defined('IS_API_SECURE') or define('IS_API_SECURE', false);
/*For Magento 2.x*/
defined('ACCESSTOKEN') or define('ACCESSTOKEN', !empty($storeConst['api_access_token']) ? $storeConst['api_access_token'] : '');
defined('INTEGRATION_NAME') or define('INTEGRATION_NAME', !empty($storeConst['api_integration_name']) ? $storeConst['api_integration_name'] : '');
defined('API_USER') or define('API_USER', !empty($storeConst['api_user']) ? $storeConst['api_user'] : '');
defined('MAGENTO_VERSION') or define('MAGENTO_VERSION', !empty($storeConst['magento_version']) ? $storeConst['magento_version'] : '');
if(isset($storeConst['api_path'])){
    defined('API_PATH') || define('API_PATH', !empty($storeConst['api_path']) ? $storeConst['api_path'] : '');
}else{
    if(strpos(API_URL,'pub')){
        $magentoApiPath = explode("pub",API_URL);
        $magentoApiPath = $magentoApiPath[0];
    }elseif(strpos(API_URL,BASE_DIR)){
        $magentoApiPath = explode(BASE_DIR,API_URL);
        $magentoApiPath = $magentoApiPath[0];
    } else {
        $magentoApiPath = '';
    }
    $magentoApiPath = $magentoApiPath."rest/V1";
    defined('API_PATH') || define('API_PATH', $magentoApiPath);
}

/*For Shopify*/
defined('SHOPIFY_SHOP') or define('SHOPIFY_SHOP', !empty($storeConst['shop']) ? $storeConst['shop'] : '');
defined('APIUSER') or define('APIUSER', !empty($storeConst['apiuser']) ? $storeConst['apiuser'] : '');
defined('APIPASS') or define('APIPASS', !empty($storeConst['apipass']) ? $storeConst['apipass'] : '');
defined('SECRETKEY') or define('SECRETKEY', !empty($storeConst['secretkey']) ? $storeConst['secretkey'] : '');
defined('APIVERSION') or define('APIVERSION', !empty($storeConst['apiVersion']) ? $storeConst['apiVersion'] : '');
/*For Prestashop */
defined('PS_WS_AUTH_KEY') or define('PS_WS_AUTH_KEY', !empty($storeConst['ps_ws_auth_key']) ? $storeConst['ps_ws_auth_key'] : '');
defined('PS_SHOP_PATH') or define('PS_SHOP_PATH', !empty($storeConst['ps_shop_path']) ? $storeConst['ps_shop_path'] : '');
defined('DEBUG') or define('DEBUG', false);
/*For Bigcommerce*/
defined('BIG_API_PATH') or define('BIG_API_PATH', !empty($storeConst['apipath']) ? $storeConst['apipath'] : '');
defined('CLIENTID') or define('CLIENTID', !empty($storeConst['clientid']) ? $storeConst['clientid'] : '');
defined('CLIENTSECRET') or define('CLIENTSECRET', !empty($storeConst['clientsecret']) ? $storeConst['clientsecret'] : '');
defined('BIG_ACCESSTOKEN') or define('BIG_ACCESSTOKEN', !empty($storeConst['accesstoken']) ? $storeConst['accesstoken'] : '');

// Database Constants
$dom = new DomDocument();
$dom->load($xmlPath);
defined('API_DB_HOST') or define('API_DB_HOST', !empty($dom->getElementsByTagName('host')->item(0)->nodeValue) ? $dom->getElementsByTagName('host')->item(0)->nodeValue : '');
defined('API_DB_NAME') or define('API_DB_NAME', !empty($dom->getElementsByTagName('dbname')->item(0)->nodeValue) ? $dom->getElementsByTagName('dbname')->item(0)->nodeValue : '');
defined('API_DB_USER') or define('API_DB_USER', !empty($dom->getElementsByTagName('dbuser')->item(0)->nodeValue) ? $dom->getElementsByTagName('dbuser')->item(0)->nodeValue : '');
defined('API_DB_PASS') or define('API_DB_PASS', !empty($dom->getElementsByTagName('dbpass')->item(0)->nodeValue) ? $dom->getElementsByTagName('dbpass')->item(0)->nodeValue : '');

/*
|--------------------------------------------------------------------------
| Assets Read and Write Path Configuration
|--------------------------------------------------------------------------
|
| You can set the Assets path before using the applciation
|
| IMPORTANT: Assets folder contains all the module's corresponding fodlers and
| sub-folders. Make sure that all the module's folders are setup
| correctly
 */
defined('ASSETS_PATH_W') or define('ASSETS_PATH_W', $base_url . '/' . 'assets/');
defined('ASSETS_PATH_R') or define('ASSETS_PATH_R', API_URL . 'assets/');

// Modules Folders
defined('QUOTATION_REVIEW') or define('QUOTATION_REVIEW', $domainUrl . '/quotation-review');
defined('EXTRACTED_FOLDER') or define('EXTRACTED_FOLDER', 'extracted/');
defined('VECTOR_FOLDER') or define('VECTOR_FOLDER', 'vectors/'); // clipart folder
defined('OVERLOGO_FOLDER') or define('OVERLOGO_FOLDER', 'overlogo/'); // Overlogo folder
defined('CONVERT_FOLDER') or define('CONVERT_FOLDER', 'overlogo/convert/'); // Overlogo folder
defined('PRODUCT_FOLDER') or define('PRODUCT_FOLDER', 'products/');
defined('SWATCH_FOLDER') or define('SWATCH_FOLDER', 'swatches/');
defined('PRINT_PROFILE_FOLDER') or define('PRINT_PROFILE_FOLDER', 'print_profile/');
defined('PRINT_AREA_FOLDER') or define('PRINT_AREA_FOLDER', 'print_areas/');
defined('PRINT_AREA_TYPE_FOLDER')
or define('PRINT_AREA_TYPE_FOLDER', 'print_area_types/');
defined('FONT_FOLDER') or define('FONT_FOLDER', 'fonts/');
defined('STICKER_FOLDER') or define('STICKER_FOLDER', 'stickers/');

defined('SHAPE_FOLDER') or define('SHAPE_FOLDER', 'shapes/');
defined('DISTRESS_FOLDER') or define('DISTRESS_FOLDER', 'distresses/');
defined('COLOR_FOLDER') or define('COLOR_FOLDER', 'colors/');
defined('CONFIGURCOLORS_FOLDER') or define('CONFIGURCOLORS_FOLDER', 'configurcolors/');
defined('BACKGROUND_FOLDER') or define('BACKGROUND_FOLDER', 'backgrounds/');
defined('MASK_FOLDER') or define('MASK_FOLDER', 'masks/');
defined('GRAPHICFONT_FOLDER') or define('GRAPHICFONT_FOLDER', 'graphics/');
defined('WORDCLOUD_FOLDER') or define('WORDCLOUD_FOLDER', 'wordclouds/');
defined('ORDER_FOLDER') or define('ORDER_FOLDER', 'orders/');
defined('LANGUAGE_FOLDER') or define('LANGUAGE_FOLDER', 'languages/');
defined('COLORPALETTE_FOLDER') or define('COLORPALETTE_FOLDER', 'color_palettes/');
defined('PRODUCT_FOLDER') or define('PRODUCT_FOLDER', 'products/');
defined('OVERLAY_FOLDER') or define('OVERLAY_FOLDER', 'products/overlay/');
defined('SETTING_FOLDER') or define('SETTING_FOLDER', 'settings/');
defined('3D_OBJECT_FOLDER') or define('3D_OBJECT_FOLDER', '3d_objects/');
defined('SECTION_FOLDER') or define('SECTION_FOLDER', 'configurators/');
defined('ORDERS_ARTWORK_FOLDER') or define('ORDERS_ARTWORK_FOLDER', 'orders_artwork/');
defined('CATEGORY_FOLDER') or define('CATEGORY_FOLDER', ASSETS_PATH_W . 'categories/'); //for category folder
defined('CATEGORY_FOLDER_R') or define('CATEGORY_FOLDER_R', ASSETS_PATH_R . 'categories/'); //for read category folder
// For template module
defined('TEMP_FOLDER') or define('TEMP_FOLDER', 'temp/');
defined('TEMPLATE_FOLDER') or define('TEMPLATE_FOLDER', 'template/');
defined('CAPTURE_FOLDER') or define('CAPTURE_FOLDER', 'template/captures/');
defined('PREDECORATOR_FOLDER')
or define('PREDECORATOR_FOLDER', 'template/predecorators/');
// For template module
defined('TEMP_FOLDER') or define('TEMP_FOLDER', 'temp/');
defined('TEMPLATE_FOLDER') or define('TEMPLATE_FOLDER', 'template/');
defined('CAPTURE_FOLDER') or define('CAPTURE_FOLDER', 'template/captures/');
defined('ORDER_LOG_FOLDER') or define('ORDER_LOG_FOLDER', 'orders_log/');
// For User Image module
defined('USER_FOLDER') or define('USER_FOLDER', 'user/');
defined('UPLOAD_FOLDER') or define('UPLOAD_FOLDER', 'user/uploads/');
defined('BROWSER_IMAGE_FOLDER') or define('BROWSER_IMAGE_FOLDER', 'browser_images/');
// Design State Capture
defined('DESIGN_STATE_FOLDER') or define('DESIGN_STATE_FOLDER', 'design_states/');
defined('DESIGN_PREVIEW_FOLDER') or define('DESIGN_PREVIEW_FOLDER', 'design_previews/');
defined('COMMON_FOLDER') or define('COMMON_FOLDER', 'common/');
defined('AUGMENTED_FOLDER') or define('AUGMENTED_FOLDER', 'augmented/');
// For Quotation
defined('QUOTATION_FOLDER') or define('QUOTATION_FOLDER', 'quotations/');
defined('VENDOR_FOLDER') or define('VENDOR_FOLDER', 'vendor/');
defined('PURCHASE_ORDER_FOLDER') or define('PURCHASE_ORDER_FOLDER', 'purchase_order/');
defined('QUOTATION_REQUEST_FOLDER') or define('QUOTATION_REQUEST_FOLDER', 'quotation_requests/');
// For Production
defined('PRODUCTION_FOLDER') or define('PRODUCTION_FOLDER', 'production/');
//For customer internal note
defined('CUSTOMER_FOLDER') or define('CUSTOMER_FOLDER', 'customers/');
defined('CUSTOMER_GROUP_FOLDER') or define('CUSTOMER_GROUP_FOLDER', 'customer_group/');
defined('SHOPIFY_CACHE_FOLDER') or define('SHOPIFY_CACHE_FOLDER', ASSETS_PATH_W . 'products/cache/');
defined('REMOVE_BACKGROUND_FOLDER') or define('REMOVE_BACKGROUND_FOLDER', 'remove_background/');
defined('BIGCOMMERCE_CACHE_FOLDER') or define('BIGCOMMERCE_CACHE_FOLDER', ASSETS_PATH_W . 'products/cache/');
// For configurator Pattern
defined('CONFIGURATOR_PATTERN_FOLDER') || define('CONFIGURATOR_PATTERN_FOLDER', 'configurator_patterns/');
//For Embroidery Preview
defined('EMBROIDERY_FOLDER') or define('EMBROIDERY_FOLDER', 'embroidery/');

// For ImprintNext add-ons
defined('ADD_ONS_SERVER_URL') or define('ADD_ONS_SERVER_URL', 'https://imprintnext.com/');

// for enable shopify variants
defined('SHOPIFY_VARIANTS_PLUGIN') || define('SHOPIFY_VARIANTS_PLUGIN', false);
/*
|--------------------------------------------------------------------------
| Directory Separation for different OS
|--------------------------------------------------------------------------
 */
if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
    // For Windows System configs
    defined('SEPARATOR') or define('SEPARATOR', '\\');
} else {
    // For Linux System configs
    defined('SEPARATOR') or define('SEPARATOR', '/');
}

/*
|--------------------------------------------------------------------------
| HTTP ERROR CODE Mapping Constants
|--------------------------------------------------------------------------
|
| IMPORTANT: You should use correct HTTP codes to the constants or else it will
|            show irrelevant output codes at frontend
 */
defined('AUTH_ERROR') or define('AUTH_ERROR', 401);
defined('OPERATION_OKAY') or define('OPERATION_OKAY', 200);
defined('NO_DATA_FOUND') or define('NO_DATA_FOUND', 200);
defined('MISSING_PARAMETER') or define('MISSING_PARAMETER', 400);
defined('EXCEPTION_OCCURED') or define('EXCEPTION_OCCURED', 500);
defined('DATA_NOT_PROCESSED') or define('DATA_NOT_PROCESSED', 500);
defined('INVALID_FORMAT_REQUESTED') or define('INVALID_FORMAT_REQUESTED', 406);
defined('CATALOG_API_URL') or define('CATALOG_API_URL', 'https://service.imprintnext.com/');
defined('IMPRINT_CATALOG_API_URL') or define('IMPRINT_CATALOG_API_URL', 'https://service.imprintnext.com/store/designer/api/v1/');
defined('COLOR_SWATCH_JSON_URL') or define('COLOR_SWATCH_JSON_URL', 'https://service.imprintnext.com/catalog/services/assets/colorSwatch.json');
defined('CENTRAL_ASSETS_BASEURL') or define('CENTRAL_ASSETS_BASEURL', 'https://service.imprintnext.com/store/designer/');
defined('CENTRAL_ASSETS_CLIPARTSIMAGE_BASEURL') or define('CENTRAL_ASSETS_CLIPARTSIMAGE_BASEURL', 'https://service.imprintnext.com/store/designer/assets/vectors/');
defined('CENTRAL_ASSETS_TEMPLATESIMAGE_BASEURL') or define('CENTRAL_ASSETS_TEMPLATESIMAGE_BASEURL', 'https://service.imprintnext.com/store/designer/assets/design_previews/');
defined('PRINTFUL_CLIENT_ID') or define('PRINTFUL_CLIENT_ID', 'app-5439932');
defined('PRINTFUL_CLIENT_SECRET') or define('PRINTFUL_CLIENT_SECRET', 'FtwuWVRs8aDEP0tqZn9KDr4fZ6yhsJwbk4WcIz11ocHBwrhZ6Mxmsn29cf80otfg');

defined('QUICKBOOK_TOKEN_EX_URL') or define('QUICKBOOK_TOKEN_EX_URL', 'https://oauth.platform.intuit.com/oauth2/v1/tokens/bearer');

defined('QUICKBOOK_TOKEN_END_POINT_URL') or define('QUICKBOOK_TOKEN_END_POINT_URL', 'https://quickbooks.api.intuit.com/');

defined('QUICKBOOK_CLIENT_ID') or define('QUICKBOOK_CLIENT_ID', 'ABFce1z1IARLXM0zPKaQtnipT9KxbR7YoBhhwLifRxAAjqp77u');

defined('QUICKBOOK_CLIENT_SECRET') or define('QUICKBOOK_CLIENT_SECRET', '2zLJhfEjlqEkO4xo3iN3lRuWRYKx6dBTirVohjWx');

defined('FILE_SIZE') or define('FILE_SIZE', 500000); //checking for file size
defined('TOKEN_SALT_VALUE') or define('TOKEN_SALT_VALUE', 'i06N%we5ghj(7ayu>)-{(5)}>#opVd%2rtLF');

defined('MARKETPLACE_ARTWORK_FOLDER') or define('MARKETPLACE_ARTWORK_FOLDER', 'marketplace_artworks/');

defined('AMAZON_SANDBOX') or define('AMAZON_SANDBOX', 1); // 0:Live api , 1:sandbox api
// sanmar catalog product update service baseurl
defined('SANMAR_WEBSERVICE_URL') or define('SANMAR_WEBSERVICE_URL', 'https://ws.sanmar.com:8080/SanMarWebService/');
defined('ALP_WEBSERVICE_URL') || define('ALP_WEBSERVICE_URL', 'https://services.alphabroder.com/');
defined('SNS_WEBSERVICE_URL') || define('SNS_WEBSERVICE_URL', 'https://api.ssactivewear.com/');
defined('DESIGNER_SCRIPT') or define('DESIGNER_SCRIPT', 'designer_script');
defined('ORDER_STATUS_CACHE_FOLDER') or define('ORDER_STATUS_CACHE_FOLDER', ASSETS_PATH_W . 'orders_status_cache/');
defined('NAME_NUMBER_FOLDER') || define('NAME_NUMBER_FOLDER', 'name_number');
defined('MAX_IMG_WIDTH') || define('MAX_IMG_WIDTH', 8000); //checking for maximum width of an asset file
defined('MAX_IMG_HEIGHT') || define('MAX_IMG_HEIGHT', 8000); //checking for maximum height of an asset file
defined('MAX_ASSET_UPLOAD_LIMIT') || define('MAX_ASSET_UPLOAD_LIMIT', 20); //checking for maximum asset file upload limit

//memcache setting details from the xml fille
$memCacheConsts = ['is_enabled' => 0, 'memhost' => 0, 'memport' => 0];
$memcachePath = ASSETS_PATH_W . SETTING_FOLDER . 'memcached.xml';
if (file_exists($memcachePath)) {
    $getMemcacheContent = simplexml_load_file($memcachePath);
    $memCacheConsts = get_object_vars($getMemcacheContent);
}
defined('IS_MEMCACHE') or define('IS_MEMCACHE', $memCacheConsts['is_enabled']);
defined('MEM_HOST') or define('MEM_HOST', $memCacheConsts['memhost']);
defined('MEM_PORT') or define('MEM_PORT',  $memCacheConsts['memport']);
defined('MEM_MODE') or define('MEM_MODE', $memCacheConsts['is_enabled']);

//Set default time zone
defined('DEFAULT_TIME_ZONE') or define('DEFAULT_TIME_ZONE', 'Asia/Kolkata');