-- MariaDB dump 10.19  Distrib 10.5.23-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysqldb    Database: xe_install_db_inkxe_10
-- ------------------------------------------------------
-- Server version	5.7.44

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin_users`
--

DROP TABLE IF EXISTS `admin_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_users` (
  `xe_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `first_question_id` int(10) DEFAULT '0',
  `first_answer` mediumtext COLLATE utf8_unicode_ci,
  `avatar` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(4) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `second_question_id` int(10) DEFAULT NULL,
  `second_answer` mediumtext COLLATE utf8_unicode_ci,
  `language_selected` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_users`
--

LOCK TABLES `admin_users` WRITE;
/*!40000 ALTER TABLE `admin_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_currency`
--

DROP TABLE IF EXISTS `app_currency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_currency` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `unicode_character` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_currency`
--

LOCK TABLES `app_currency` WRITE;
/*!40000 ALTER TABLE `app_currency` DISABLE KEYS */;
INSERT INTO `app_currency` VALUES (1,'US Dollar ','$','USD',1,'&#36'),(2,'Indian Rup','â¹','INR',0,'&#8377'),(3,'Czech Koru','KÄ','CZK.',0,'&#75'),(4,'Mexican Pe','$','MXN.',0,'&#36'),(5,'Japanese Y','Â¥','JPY.',0,'&#165'),(6,'Canadian D','$','CAD',0,'&#36'),(7,'New Taiwan','NT','TWD',0,'&#78'),(8,'Danish Kro','sk','DKK',0,'&#107'),(9,'Philippine','â±','PHP',0,'&#8369'),(10,'Thai Baht','à¸¿','THB',0,'&#3647'),(11,'Russian Ru','RU','RUB',0,'&#1088'),(12,'Israeli Ne','âª','ILS',0,'&#8362'),(13,'British Po','Â£','GBP',0,'&#163'),(14,'Norwegian','kr','NOK',0,'&#107'),(15,'Euro','â¬','EUR',0,'&#8364'),(16,'Australian','$','AUD',0,'&#36'),(17,'Polish Zlo','zÅ','PLN',0,'&#122'),(18,'Swiss Franc','CH','CHF',0,'CHF'),(19,'New Zealan','$','AUD',0,'&#36'),(20,'Singapore','$','SGD',0,'&#36'),(21,'Swedish Kr','kr','SEK',0,'&#107'),(22,'Hong Kong','$','HKD',0,'&#36'),(23,'Hungarian','Ft','HUF',0,'&#70'),(24,'Chinese yu','Â¥','CNY',0,'&#165'),(25,'South African Rand','R','ZAR',0,'R'),(26,'Romanian Leu','lei','RON',0,'lei'),(27,'Arabic','ر.س','SAR',0,'SAR');
/*!40000 ALTER TABLE `app_currency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_units`
--

DROP TABLE IF EXISTS `app_units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_units` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `label` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_units`
--

LOCK TABLES `app_units` WRITE;
/*!40000 ALTER TABLE `app_units` DISABLE KEYS */;
INSERT INTO `app_units` VALUES (1,'Inch',1,'in',1),(2,'Feet',0,'ft',1),(3,'Centimeter',0,'cm',1),(4,'Millimeter',0,'mm',1),(5,'Pixel',0,'px',1),(6,'Meter',0,'m',1);
/*!40000 ALTER TABLE `app_units` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `artwork_approval`
--

DROP TABLE IF EXISTS `artwork_approval`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `artwork_approval` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `order_item_id` text COLLATE utf8_unicode_ci NOT NULL,
  `old_ref_id` int(11) NOT NULL,
  `new_ref_id` int(11) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL COMMENT '0-Artwork updated, 1-Sent for approval, 2- Approved, 3- Rejected',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `artwork_approval`
--

LOCK TABLES `artwork_approval` WRITE;
/*!40000 ALTER TABLE `artwork_approval` DISABLE KEYS */;
/*!40000 ALTER TABLE `artwork_approval` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `artwork_approval_conv_files`
--

DROP TABLE IF EXISTS `artwork_approval_conv_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `artwork_approval_conv_files` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `conv_id` int(11) NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `artwork_approval_conv_files`
--

LOCK TABLES `artwork_approval_conv_files` WRITE;
/*!40000 ALTER TABLE `artwork_approval_conv_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `artwork_approval_conv_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `artwork_approval_conversations`
--

DROP TABLE IF EXISTS `artwork_approval_conversations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `artwork_approval_conversations` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_artwork_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `user_type` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT 'admin, customer, agent',
  `user_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `message` text COLLATE utf8_unicode_ci,
  `seen_flag` tinyint(1) DEFAULT NULL,
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `artwork_approval_conversations`
--

LOCK TABLES `artwork_approval_conversations` WRITE;
/*!40000 ALTER TABLE `artwork_approval_conversations` DISABLE KEYS */;
/*!40000 ALTER TABLE `artwork_approval_conversations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `asset_types`
--

DROP TABLE IF EXISTS `asset_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asset_types` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `asset_types`
--

LOCK TABLES `asset_types` WRITE;
/*!40000 ALTER TABLE `asset_types` DISABLE KEYS */;
INSERT INTO `asset_types` VALUES (1,'Backgrounds','backgrounds'),(2,'Cliparts','cliparts'),(3,'Printable colors','color-palettes'),(4,'Color Swatches','color-swatch'),(5,'Distresses','distresses'),(6,'Fonts','fonts'),(7,'Graphic Fonts','graphic-fonts'),(8,'Masks','masks'),(9,'Shapes','shapes'),(10,'Word Clouds','word-clouds'),(11,'Templates','templates'),(12,'Products','products'),(13,'Configurator Patterns','configurator-patterns'),(14,'Configurator colors','color-config');
/*!40000 ALTER TABLE `asset_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attribute_price_rules`
--

DROP TABLE IF EXISTS `attribute_price_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `attribute_price_rules` (
  `product_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `attribute_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `attribute_term_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `print_profile_id` int(11) DEFAULT NULL,
  `price` decimal(20,8) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attribute_price_rules`
--

LOCK TABLES `attribute_price_rules` WRITE;
/*!40000 ALTER TABLE `attribute_price_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `attribute_price_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `augmented_realities`
--

DROP TABLE IF EXISTS `augmented_realities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `augmented_realities` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `html_file` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pattern_file` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `augmented_realities`
--

LOCK TABLES `augmented_realities` WRITE;
/*!40000 ALTER TABLE `augmented_realities` DISABLE KEYS */;
/*!40000 ALTER TABLE `augmented_realities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `background_category_rel`
--

DROP TABLE IF EXISTS `background_category_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `background_category_rel` (
  `background_id` bigint(20) DEFAULT NULL,
  `category_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `background_category_rel`
--

LOCK TABLES `background_category_rel` WRITE;
/*!40000 ALTER TABLE `background_category_rel` DISABLE KEYS */;
INSERT INTO `background_category_rel` VALUES (1,19),(2,19),(3,19),(4,19),(5,19),(6,19),(7,19),(8,19),(9,19),(10,19),(11,19),(12,19),(13,19),(14,19),(15,19),(16,19),(17,19),(18,19),(19,19),(20,19),(21,19),(22,19),(23,19),(24,19),(25,19),(26,19),(27,19),(28,19);
/*!40000 ALTER TABLE `background_category_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `background_tag_rel`
--

DROP TABLE IF EXISTS `background_tag_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `background_tag_rel` (
  `background_id` bigint(20) DEFAULT NULL,
  `tag_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `background_tag_rel`
--

LOCK TABLES `background_tag_rel` WRITE;
/*!40000 ALTER TABLE `background_tag_rel` DISABLE KEYS */;
INSERT INTO `background_tag_rel` VALUES (23,1),(24,2);
/*!40000 ALTER TABLE `background_tag_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backgrounds`
--

DROP TABLE IF EXISTS `backgrounds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backgrounds` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'file_name: files, hexcode: color',
  `price` decimal(20,8) DEFAULT NULL,
  `type` tinyint(1) DEFAULT NULL COMMENT '1: Pattern, 0: Color',
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backgrounds`
--

LOCK TABLES `backgrounds` WRITE;
/*!40000 ALTER TABLE `backgrounds` DISABLE KEYS */;
INSERT INTO `backgrounds` VALUES (1,'Background','202003300117121579.png',0.00000000,1,1,'2020-03-30 13:17:12',0),(2,'Background','202003300117121579.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(3,'Background','202003300117121579_1.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(4,'Background','202003300117121579_2.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(5,'Background','202003300117121579_1.png',0.00000000,1,1,'2020-03-30 13:17:12',0),(6,'Background','202003300117121579_3.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(7,'Background','202003300117121579_4.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(8,'Background','202003300117121579_5.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(9,'Background','202003300117121579_6.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(10,'Background','202003300117121579_7.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(11,'Background','202003300117121579_8.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(12,'Background','202003300117121579_9.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(13,'Background','202003300117121579_2.png',0.00000000,1,1,'2020-03-30 13:17:12',0),(14,'Background','202003300117121579_10.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(15,'Background','202003300117121579_11.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(16,'Background','202003300117121579_12.jpg',0.00000000,1,1,'2020-03-30 13:17:12',0),(17,'Background','202003300117121579_3.png',0.00000000,1,1,'2020-03-30 13:17:12',0),(18,'Background','202003300117121579_4.png',0.00000000,1,1,'2020-03-30 13:17:12',0),(19,'Blue','#3b647c',0.00000000,0,1,'2020-03-30 13:22:34',0),(20,'Brown','#904141',0.00000000,0,1,'2020-03-30 13:25:34',0),(21,'Pink','#d55959',0.00000000,0,1,'2020-03-30 13:25:53',0),(22,'Purple','#b46ae1',0.00000000,0,1,'2020-03-30 13:26:54',0),(23,'Sea Green','#9bf1c8',0.00000000,0,1,'2020-03-30 14:09:44',0),(24,'Orange','#ebaa59',0.00000000,0,1,'2020-03-30 14:11:03',0),(25,'Lemon','#bbcf87',0.00000000,0,1,'2020-03-30 14:11:50',0),(26,'Grey','#949494',0.00000000,0,1,'2020-03-30 14:13:54',0),(27,'Blue','#407de9',0.00000000,0,1,'2020-03-30 14:17:36',0),(28,'Green','#348248',0.00000000,0,1,'2020-03-30 14:19:16',0);
/*!40000 ALTER TABLE `backgrounds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `barcodes`
--

DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(40) COLLATE utf8_unicode_ci NOT NULL COMMENT 'It is used for performing a particular action',
  `module_id` tinyint(2) NOT NULL COMMENT '2-Order,4-Production',
  `barcode_number` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `barcode_image` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `store_id` int(4) NOT NULL,
  `is_active` tinyint(2) NOT NULL DEFAULT '1' COMMENT '1-Active,0-In Active',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `barcodes`
--

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'Order details','order_details',2,'202203300501306573','202203300501306573.png',1,0,'2025-08-25 05:14:40'),(2,'Download order artwork files','download_order_artwork_file',2,'202203300501303395','202203300501303395.png',1,1,'2025-08-25 05:14:40'),(3,'Open order invoice','open_order_invoice',2,'202203300501304483','202203300501304483.png',1,0,'2025-08-25 05:14:40'),(4,'Print order invoice','print_order_invoice',2,'20220330050130825','20220330050130825.png',1,0,'2025-08-25 05:14:40'),(5,'Download order invoice','download_order_invoice',2,'202203300501302123','202203300501302123.png',1,1,'2025-08-25 05:14:40'),(6,'Open work order slip','open_work_order_slip',2,'202203300501305424','202203300501305424.png',1,1,'2025-08-25 05:14:40'),(7,'Print work order slip','print_work_order_slip',2,'202203300501305513','202203300501305513.png',1,1,'2025-08-25 05:14:40'),(8,'Download work order slip','download_work_order_slip',2,'202203300501305653','202203300501305653.png',1,1,'2025-08-25 05:14:40'),(9,'Download packing slip','download_packing_slip',2,'202203300501301308','202203300501301308.png',1,1,'2025-08-25 05:14:40'),(10,'Create production job from order','create_production_job_from_order',2,'202203300501303696','202203300501303696.png',1,1,'2025-08-25 05:14:40'),(11,'View production job','view_production_job',2,'202203300501304802','202203300501304802.png',1,1,'2025-08-25 05:14:40'),(12,'View job details','view_job_details',4,'202203300501301584','202203300501301584.png',1,0,'2025-08-25 05:14:40'),(13,'Print job details','print_job_details',4,'20220330050130615','20220330050130615.png',1,1,'2025-08-25 05:14:40'),(14,'Download job details','download_job_details',4,'202203300501302745','202203300501302745.png',1,1,'2025-08-25 05:14:40'),(15,'Mark job status start printing as Done','start_printing',4,'20220330050130191','20220330050130191.png',1,1,'2025-08-25 05:14:40'),(16,'Mark job status start shipping as Done','shipping',4,'202203300501308508','202203300501308508.png',1,1,'2025-08-25 05:14:40');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `browser_images`
--

DROP TABLE IF EXISTS `browser_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `browser_images` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `browser_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `browser_images`
--

LOCK TABLES `browser_images` WRITE;
/*!40000 ALTER TABLE `browser_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `browser_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `capture_images`
--

DROP TABLE IF EXISTS `capture_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `capture_images` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` int(11) NOT NULL,
  `side_index` int(11) NOT NULL,
  `file_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `capture_images`
--

LOCK TABLES `capture_images` WRITE;
/*!40000 ALTER TABLE `capture_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `capture_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_order_rel`
--

DROP TABLE IF EXISTS `catalog_order_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_order_rel` (
  `catalog_code` int(3) NOT NULL,
  `order_id` varchar(50) DEFAULT NULL,
  `catalog_order_id` varchar(50) DEFAULT NULL,
  `created_date` datetime NOT NULL,
  `report` varchar(200) DEFAULT NULL,
  `shipping` text,
  `status` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_order_rel`
--

LOCK TABLES `catalog_order_rel` WRITE;
/*!40000 ALTER TABLE `catalog_order_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_order_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_rel`
--

DROP TABLE IF EXISTS `catalog_product_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_rel` (
  `product_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `catalog_product_id` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `catalog_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL COMMENT 'Last updated time',
  `margin_type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'percentage/flat',
  `margin_value` decimal(10,2) DEFAULT '0.00',
  `product_stored_type` enum('store','imprint') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'store'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_rel`
--

LOCK TABLES `catalog_product_rel` WRITE;
/*!40000 ALTER TABLE `catalog_product_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `asset_type_id` int(4) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort_order` bigint(20) DEFAULT '0',
  `is_disable` tinyint(1) NOT NULL DEFAULT '0',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `is_defined` tinyint(1) DEFAULT '1' COMMENT '0-delete, 1- not delete',
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  `asset_available_flag` tinyint(1) NOT NULL DEFAULT '1',
  `import_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`),
  KEY `categories_index_001` (`name`,`asset_type_id`,`parent_id`,`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,3,0,'CMYK',1,0,0,1,'2020-03-06 12:26:34','2025-08-25 05:14:25',1,NULL,0,1,0),(2,3,0,'RGB',2,0,0,1,'2020-03-06 12:26:34','2025-08-25 05:14:25',1,NULL,0,1,0),(3,3,0,'Pantone',3,0,0,1,'2020-03-06 12:26:34','2025-08-25 05:14:25',1,NULL,0,1,0),(4,3,0,'Pattern',4,0,0,1,'2020-03-06 12:26:34','2025-08-25 05:14:25',1,NULL,0,1,0),(5,3,0,'Embroidery Thread',5,0,0,1,'2020-03-06 12:26:34','2025-08-25 05:14:25',1,NULL,0,1,0),(6,2,0,'Season',6,0,0,1,'2020-03-06 19:04:55','2025-08-25 05:14:25',1,NULL,0,1,0),(7,2,0,'Country',7,0,0,1,'2020-03-06 19:12:19','2025-08-25 05:14:25',1,NULL,0,1,0),(8,2,0,'Animals',8,0,0,1,'2020-03-06 19:12:26','2025-08-25 05:14:25',1,NULL,0,1,0),(9,2,0,'Baby',9,0,0,1,'2020-03-06 19:12:36','2025-08-25 05:14:25',1,NULL,0,1,0),(10,2,0,'Badge',10,0,0,1,'2020-03-06 19:12:40','2025-08-25 05:14:25',1,NULL,0,1,0),(11,2,0,'Comic',11,0,0,1,'2020-03-06 19:12:49','2025-08-25 05:14:25',1,NULL,0,1,0),(12,2,0,'Event',12,0,0,1,'2020-03-06 19:12:54','2025-08-25 05:14:25',1,NULL,0,1,0),(13,2,0,'Food',13,0,0,1,'2020-03-06 19:12:58','2025-08-25 05:14:25',1,NULL,0,1,0),(14,2,0,'Music',14,0,0,1,'2020-03-06 19:13:07','2025-08-25 05:14:25',1,NULL,0,1,0),(15,2,0,'Military',15,0,0,1,'2020-03-06 19:13:13','2025-08-25 05:14:25',1,NULL,0,1,0),(16,2,7,'America',16,0,0,1,'2020-03-06 19:13:22','2025-08-25 05:14:25',1,NULL,0,1,0),(17,2,7,'Thailand',17,0,0,1,'2020-03-06 19:13:28','2025-08-25 05:14:25',1,NULL,0,1,0),(18,2,7,'Vietnam',18,0,0,1,'2020-03-06 19:13:36','2025-08-25 05:14:25',1,NULL,0,1,0),(19,1,0,'Premium Texture',19,0,0,1,'2020-03-06 19:21:32','2025-08-25 05:14:25',1,NULL,0,1,0),(20,9,0,'Solid objects',20,0,0,1,'2020-03-06 19:24:29','2025-08-25 05:14:25',1,NULL,0,1,0),(21,5,0,'Black n white',21,0,0,1,'2020-03-06 19:28:49','2025-08-25 05:14:25',1,NULL,0,1,0),(22,6,0,'Action',22,0,0,1,'2020-03-06 19:29:50','2025-08-25 05:14:25',1,NULL,0,1,0),(23,6,0,'Military',23,0,0,1,'2020-03-06 19:30:05','2025-08-25 05:14:25',1,NULL,0,1,0),(24,6,0,'Fun',24,0,0,1,'2020-03-06 19:30:09','2025-08-25 05:14:25',1,NULL,0,1,0),(25,6,0,'Love',25,0,0,1,'2020-03-06 19:30:13','2025-08-25 05:14:25',1,NULL,0,1,0),(26,10,0,'Birds',26,0,0,1,'2020-03-06 19:43:10','2025-08-25 05:14:25',1,NULL,0,1,0),(27,10,0,'Love',27,0,0,1,'2020-03-06 19:44:10','2025-08-25 05:14:25',1,NULL,0,1,0),(28,3,1,'Light',28,0,0,1,'2020-03-06 19:47:16','2025-08-25 05:14:25',1,NULL,0,1,0),(29,3,1,'Dark',29,0,0,1,'2020-03-06 19:47:20','2025-08-25 05:14:25',1,NULL,0,1,0),(30,3,1,'B/W',30,0,0,1,'2020-03-06 19:47:24','2025-08-25 05:14:25',1,NULL,0,1,0),(31,3,2,'Green',31,0,0,1,'2020-03-06 19:47:34','2025-08-25 05:14:25',1,NULL,0,1,0),(32,3,2,'Yellow',32,0,0,1,'2020-03-06 19:47:39','2025-08-25 05:14:25',1,NULL,0,1,0),(33,3,2,'Red',33,0,0,1,'2020-03-06 19:47:46','2025-08-25 05:14:25',1,NULL,0,1,0),(34,3,3,'Violet brown',34,0,0,1,'2020-03-06 19:47:59','2025-08-25 05:14:25',1,NULL,0,1,0),(35,3,3,'Green Grass',35,0,0,1,'2020-03-06 19:48:05','2025-08-25 05:14:25',1,NULL,0,1,0),(36,3,3,'Sand Brown',36,0,0,1,'2020-03-06 19:48:11','2025-08-25 05:14:25',1,NULL,0,1,0),(37,3,4,'Glitter',37,0,0,1,'2020-03-06 19:48:26','2025-08-25 05:14:25',1,NULL,0,1,0),(38,3,4,'Foil',38,0,0,1,'2020-03-06 19:48:31','2025-08-25 05:14:25',1,NULL,0,1,0),(40,3,5,'Thread',40,0,0,1,'2020-03-06 19:48:50','2025-08-25 05:14:25',1,NULL,0,1,0),(41,3,5,'Orange',41,0,0,1,'2020-03-06 19:48:58','2025-08-25 05:14:25',1,NULL,0,1,0),(42,3,5,'Pink',42,0,0,1,'2020-03-06 19:49:03','2025-08-25 05:14:25',1,NULL,0,1,0),(43,11,0,'Template Category 001',43,0,0,1,'2020-03-07 12:03:05','2025-08-25 05:14:25',1,NULL,0,1,0),(44,2,0,'Premium cliparts',44,0,0,1,'2020-03-07 13:28:24','2025-08-25 05:14:25',1,NULL,0,1,0),(45,6,0,'Premium font',45,0,0,1,'2020-03-07 14:16:43','2025-08-25 05:14:25',1,NULL,0,1,0),(46,11,43,'Temp Sub Cat',46,0,0,1,'2020-03-07 16:59:40','2025-08-25 05:14:25',1,NULL,0,1,0),(48,6,45,'Sans Serif',47,0,0,1,'2020-03-12 10:33:15','2025-08-25 05:14:25',1,NULL,0,1,0),(49,6,45,'Serif',48,0,0,1,'2020-03-12 10:50:25','2025-08-25 05:14:25',1,NULL,0,1,0),(50,6,45,'Comic',49,0,0,1,'2020-03-12 11:18:34','2025-08-25 05:14:25',1,NULL,0,1,0),(51,6,45,'Calligraphy',50,0,0,1,'2020-03-12 11:50:37','2025-08-25 05:14:25',1,NULL,0,1,0),(53,2,52,'Baseball',52,0,0,1,'2020-03-30 12:33:16','2025-08-25 05:14:25',1,NULL,0,1,0),(54,2,52,'Billiards',53,0,0,1,'2020-03-30 12:33:40','2025-08-25 05:14:25',1,NULL,0,1,0),(55,2,52,'Golf',54,0,0,1,'2020-03-30 12:33:54','2025-08-25 05:14:25',1,NULL,0,1,0),(56,2,0,'Games',55,0,1,1,'2020-03-30 14:21:10','2025-08-25 05:14:25',1,NULL,0,1,0),(57,2,56,'Basket',56,0,1,1,'2020-03-30 14:24:51','2025-08-25 05:14:25',1,NULL,0,1,0),(58,2,56,'Footballl',57,0,0,1,'2020-03-30 14:25:52','2025-08-25 05:14:25',1,NULL,0,1,0),(59,2,56,'Racing',58,0,0,1,'2020-03-30 14:26:24','2025-08-25 05:14:25',1,NULL,0,1,0),(60,2,0,'Family',59,0,0,1,'2020-03-30 14:50:35','2025-08-25 05:14:25',1,NULL,0,1,0),(61,2,0,'Others',60,0,0,1,'2020-03-30 14:57:02','2025-08-25 05:14:25',1,NULL,0,1,0),(63,3,3,'Light Color',61,0,0,1,'2020-03-31 06:13:04','2025-08-25 05:14:25',1,NULL,0,1,0),(64,3,3,'Dark Color',62,0,0,1,'2020-03-31 06:22:20','2025-08-25 05:14:25',1,NULL,0,1,0),(66,6,0,'Western',63,0,1,1,'2020-03-31 09:23:54','2025-08-25 05:14:25',1,NULL,0,1,0),(67,6,0,'Typewrite',64,0,0,1,'2020-03-31 09:32:20','2025-08-25 05:14:25',1,NULL,0,1,0),(68,10,0,'Solid Shapes',65,0,1,1,'2020-03-31 10:16:36','2025-08-25 05:14:25',1,NULL,0,1,0),(69,13,0,'Premium Pattern',0,0,0,1,'2024-04-29 10:20:35','2025-08-25 05:14:45',1,NULL,0,1,0);
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clipart_category_rel`
--

DROP TABLE IF EXISTS `clipart_category_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `clipart_category_rel` (
  `clipart_id` bigint(20) DEFAULT NULL,
  `category_id` bigint(20) DEFAULT NULL,
  KEY `clipart_category_rel_index_001` (`clipart_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clipart_category_rel`
--

LOCK TABLES `clipart_category_rel` WRITE;
/*!40000 ALTER TABLE `clipart_category_rel` DISABLE KEYS */;
INSERT INTO `clipart_category_rel` VALUES (1,53),(2,53),(3,53),(4,53),(5,53),(6,53),(7,53),(8,53),(9,53),(10,53),(11,53),(12,53),(13,53),(14,54),(15,54),(16,54),(17,54),(18,54),(19,54),(20,54),(21,54),(22,54),(23,54),(24,54),(25,54),(26,54),(27,54),(28,54),(29,54),(30,12),(30,56),(30,57),(30,58),(30,59),(31,56),(31,57),(31,58),(31,59),(32,56),(32,57),(32,58),(32,59),(33,56),(33,57),(33,58),(33,59),(34,56),(34,57),(34,58),(34,59),(35,56),(35,57),(35,58),(35,59),(36,56),(36,57),(36,58),(36,59),(37,56),(37,57),(37,58),(37,59),(38,56),(38,57),(38,58),(38,59),(39,56),(39,57),(39,58),(39,59),(40,56),(40,57),(40,58),(40,59),(41,56),(41,57),(41,58),(41,59),(42,56),(42,57),(42,58),(42,59),(43,56),(43,57),(43,58),(43,59),(44,56),(44,57),(44,58),(44,59),(45,56),(45,57),(45,58),(45,59),(46,56),(46,57),(46,58),(46,59),(47,56),(47,57),(47,58),(47,59),(48,56),(48,57),(48,58),(48,59),(49,56),(49,57),(49,58),(49,59),(50,10),(50,56),(50,57),(50,58),(50,59),(51,10),(51,56),(51,57),(51,58),(51,59),(52,15),(52,58),(53,58),(54,58),(55,58),(56,58),(57,58),(58,58),(59,58),(60,58),(61,58),(62,59),(63,12),(63,59),(64,59),(65,59),(66,59),(67,59),(68,59),(69,15),(69,59),(70,59),(71,59),(72,59),(73,59),(74,59),(75,59),(76,60),(77,60),(78,60),(79,9),(79,60),(80,60),(81,60),(82,60),(83,11),(83,60),(84,60),(85,13),(85,60),(86,60),(87,9),(87,60),(88,60),(89,11),(89,60),(90,8),(90,60),(91,60),(92,60),(93,60),(94,60),(95,60),(96,60),(97,8),(97,60),(98,60),(99,60),(100,60),(101,60),(102,60),(103,60),(104,60),(105,60),(106,60),(107,60),(108,60),(109,14),(109,60),(110,60),(111,60),(112,60),(113,60),(114,60),(115,60),(116,61),(117,7),(117,16),(117,17),(117,18),(117,61),(118,61),(119,61),(120,6),(120,61),(121,14),(121,61),(122,61),(123,61),(124,61),(125,61),(126,6),(126,61),(127,6),(127,61),(128,6),(128,61),(129,61),(130,61),(131,61),(132,61),(133,61),(134,7),(134,16),(134,17),(134,18),(134,61);
/*!40000 ALTER TABLE `clipart_category_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clipart_tag_rel`
--

DROP TABLE IF EXISTS `clipart_tag_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `clipart_tag_rel` (
  `clipart_id` bigint(20) DEFAULT NULL,
  `tag_id` bigint(20) DEFAULT NULL,
  KEY `clipart_tag_rel_index_001` (`clipart_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clipart_tag_rel`
--

LOCK TABLES `clipart_tag_rel` WRITE;
/*!40000 ALTER TABLE `clipart_tag_rel` DISABLE KEYS */;
INSERT INTO `clipart_tag_rel` VALUES (40,3),(41,3),(42,3),(43,3),(44,3),(45,3),(46,3),(47,3),(48,3),(49,3),(50,3),(51,3),(52,4),(53,4),(54,4),(55,4),(56,4),(57,4),(58,4),(59,4),(60,4),(61,4),(72,5),(73,5),(74,5),(75,5),(132,10),(132,11),(133,11);
/*!40000 ALTER TABLE `clipart_tag_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cliparts`
--

DROP TABLE IF EXISTS `cliparts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cliparts` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price` decimal(20,8) DEFAULT NULL,
  `width` float(5,2) DEFAULT NULL,
  `height` float(5,2) DEFAULT NULL,
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_scaling` tinyint(1) DEFAULT '0',
  `total_used` int(11) DEFAULT '0',
  `store_id` int(4) NOT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `is_imported` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`),
  KEY `cliparts_index_key_01` (`name`,`price`,`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=135 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cliparts`
--

LOCK TABLES `cliparts` WRITE;
/*!40000 ALTER TABLE `cliparts` DISABLE KEYS */;
INSERT INTO `cliparts` VALUES (30,'Basketball',0.00000000,0.00,0.00,'202003300236423133.svg',0,0,1,'2020-03-30 14:36:42','0',0),(31,'Basketball',0.00000000,0.00,0.00,'202003300236423133_1.svg',0,0,1,'2020-03-30 14:36:42','0',0),(32,'Basketball',0.00000000,0.00,0.00,'202003300236423133_2.svg',0,0,1,'2020-03-30 14:36:42','0',0),(33,'Basketball',0.00000000,0.00,0.00,'202003300236423133_3.svg',0,0,1,'2020-03-30 14:36:42','0',0),(34,'Basketball',0.00000000,0.00,0.00,'202003300236423133_4.svg',0,0,1,'2020-03-30 14:36:42','0',0),(35,'Basketball',0.00000000,0.00,0.00,'202003300236423133_5.svg',0,0,1,'2020-03-30 14:36:42','0',0),(36,'Basketball',0.00000000,0.00,0.00,'202003300236423133_6.svg',0,0,1,'2020-03-30 14:36:42','0',0),(37,'Basketball',0.00000000,0.00,0.00,'202003300236423133_7.svg',0,0,1,'2020-03-30 14:36:42','0',0),(38,'Basketball',0.00000000,0.00,0.00,'202003300236423133_8.svg',0,0,1,'2020-03-30 14:36:42','0',0),(39,'Basketball',0.00000000,0.00,0.00,'202003300236423133_9.svg',0,0,1,'2020-03-30 14:36:42','0',0),(40,'Basketball',0.00000000,0.00,0.00,'202003300238429411.svg',0,0,1,'2020-03-30 14:38:42','0',0),(41,'Basketball',0.00000000,0.00,0.00,'202003300238429411_1.svg',0,0,1,'2020-03-30 14:38:42','0',0),(42,'Basketball',0.00000000,0.00,0.00,'202003300238429411_2.svg',0,0,1,'2020-03-30 14:38:42','0',0),(43,'Basketball',0.00000000,0.00,0.00,'202003300238429411_3.svg',0,0,1,'2020-03-30 14:38:42','0',0),(44,'Basketball',0.00000000,0.00,0.00,'202003300238429411_4.svg',0,0,1,'2020-03-30 14:38:42','0',0),(45,'Basketball',0.00000000,0.00,0.00,'202003300238429411_5.svg',0,0,1,'2020-03-30 14:38:42','0',0),(46,'Basketball',0.00000000,0.00,0.00,'202003300238429411_6.svg',0,0,1,'2020-03-30 14:38:42','0',0),(47,'Basketball',0.00000000,0.00,0.00,'202003300238429411_7.svg',0,0,1,'2020-03-30 14:38:42','0',0),(48,'Basketball',0.00000000,0.00,0.00,'202003300238429411_8.svg',0,0,1,'2020-03-30 14:38:42','0',0),(49,'Basketball',0.00000000,0.00,0.00,'202003300238429411_9.svg',0,0,1,'2020-03-30 14:38:42','0',0),(50,'Basketball',0.00000000,0.00,0.00,'202003300238429411_10.svg',0,0,1,'2020-03-30 14:38:42','0',0),(51,'Basketball',0.00000000,0.00,0.00,'202003300238429411_11.svg',0,0,1,'2020-03-30 14:38:42','0',0),(52,'Football',0.00000000,0.00,0.00,'202003300245101272.svg',0,0,1,'2020-03-30 14:45:10','0',0),(53,'Football',0.00000000,0.00,0.00,'202003300245101272_1.svg',0,0,1,'2020-03-30 14:45:10','0',0),(54,'Football',0.00000000,0.00,0.00,'202003300245101272_2.svg',0,0,1,'2020-03-30 14:45:10','0',0),(55,'Football',0.00000000,0.00,0.00,'202003300245101272_3.svg',0,0,1,'2020-03-30 14:45:10','0',0),(56,'Football',0.00000000,0.00,0.00,'202003300245101272_4.svg',0,0,1,'2020-03-30 14:45:10','0',0),(57,'Football',0.00000000,0.00,0.00,'202003300245101272_5.svg',0,0,1,'2020-03-30 14:45:10','0',0),(58,'Football',0.00000000,0.00,0.00,'202003300245101272_6.svg',0,0,1,'2020-03-30 14:45:10','0',0),(59,'Football',0.00000000,0.00,0.00,'202003300245101272_7.svg',0,0,1,'2020-03-30 14:45:10','0',0),(60,'Football',0.00000000,0.00,0.00,'202003300245101272_8.svg',0,0,1,'2020-03-30 14:45:10','0',0),(61,'Football',0.00000000,0.00,0.00,'202003300245101272_9.svg',0,0,1,'2020-03-30 14:45:10','0',0),(62,'Racing',0.00000000,0.00,0.00,'202003300246159198.svg',0,0,1,'2020-03-30 14:46:15','0',0),(63,'Racing',0.00000000,0.00,0.00,'202003300246159198_1.svg',0,0,1,'2020-03-30 14:46:15','0',0),(64,'Racing',0.00000000,0.00,0.00,'202003300246159198_2.svg',0,0,1,'2020-03-30 14:46:15','0',0),(65,'Racing',0.00000000,0.00,0.00,'202003300246159198_3.svg',0,0,1,'2020-03-30 14:46:15','0',0),(66,'Racing',0.00000000,0.00,0.00,'202003300246159198_4.svg',0,0,1,'2020-03-30 14:46:15','0',0),(67,'Racing',0.00000000,0.00,0.00,'202003300246159198_5.svg',0,0,1,'2020-03-30 14:46:15','0',0),(68,'Racing',0.00000000,0.00,0.00,'202003300246159198_6.svg',0,0,1,'2020-03-30 14:46:15','0',0),(69,'Racing',0.00000000,0.00,0.00,'202003300246159198_7.svg',0,0,1,'2020-03-30 14:46:15','0',0),(70,'Racing',0.00000000,0.00,0.00,'202003300246159198_8.svg',0,0,1,'2020-03-30 14:46:15','0',0),(71,'Racing',0.00000000,0.00,0.00,'202003300246159198_9.svg',0,0,1,'2020-03-30 14:46:15','0',0),(72,'Racing',0.00000000,0.00,0.00,'20200330024710494.svg',0,0,1,'2020-03-30 14:47:10','0',0),(73,'Racing',0.00000000,0.00,0.00,'20200330024710494_1.svg',0,0,1,'2020-03-30 14:47:10','0',0),(74,'Racing',0.00000000,0.00,0.00,'20200330024710494_2.svg',0,0,1,'2020-03-30 14:47:10','0',0),(75,'Racing',0.00000000,0.00,0.00,'20200330024710494_3.svg',0,0,1,'2020-03-30 14:47:10','0',0),(76,'Baby',0.00000000,0.00,0.00,'202003300251349589.svg',0,0,1,'2020-03-30 14:51:34','0',0),(77,'Baby',0.00000000,0.00,0.00,'202003300251349589_1.svg',0,0,1,'2020-03-30 14:51:34','0',0),(78,'Baby',0.00000000,0.00,0.00,'202003300251349589_2.svg',0,0,1,'2020-03-30 14:51:34','0',0),(79,'Baby',0.00000000,0.00,0.00,'202003300251349589_3.svg',0,0,1,'2020-03-30 14:51:34','0',0),(80,'Baby',0.00000000,0.00,0.00,'202003300251349589_4.svg',0,0,1,'2020-03-30 14:51:34','0',0),(81,'Baby',0.00000000,0.00,0.00,'202003300251349589_5.svg',0,0,1,'2020-03-30 14:51:34','0',0),(82,'Baby',0.00000000,0.00,0.00,'202003300251349589_6.svg',0,0,1,'2020-03-30 14:51:34','0',0),(83,'Baby',0.00000000,0.00,0.00,'202003300251349589_7.svg',0,0,1,'2020-03-30 14:51:34','0',0),(84,'Baby',0.00000000,0.00,0.00,'202003300251349589_8.svg',0,0,1,'2020-03-30 14:51:34','0',0),(85,'Baby',0.00000000,0.00,0.00,'202003300251349589_9.svg',0,0,1,'2020-03-30 14:51:34','0',0),(86,'Child',0.00000000,0.00,0.00,'202003300253261409.svg',0,0,1,'2020-03-30 14:53:26','0',0),(87,'Child',0.00000000,0.00,0.00,'202003300253261409_1.svg',0,0,1,'2020-03-30 14:53:26','0',0),(88,'Child',0.00000000,0.00,0.00,'202003300253261409_2.svg',0,0,1,'2020-03-30 14:53:26','0',0),(89,'Child',0.00000000,0.00,0.00,'202003300253261409_3.svg',0,0,1,'2020-03-30 14:53:26','0',0),(90,'Child',0.00000000,0.00,0.00,'202003300253261409_4.svg',0,0,1,'2020-03-30 14:53:26','0',0),(91,'Child',0.00000000,0.00,0.00,'202003300253261409_5.svg',0,0,1,'2020-03-30 14:53:26','0',0),(92,'Child',0.00000000,0.00,0.00,'202003300253261409_6.svg',0,0,1,'2020-03-30 14:53:26','0',0),(93,'Child',0.00000000,0.00,0.00,'202003300253261409_7.svg',0,0,1,'2020-03-30 14:53:26','0',0),(94,'Child',0.00000000,0.00,0.00,'202003300253261409_8.svg',0,0,1,'2020-03-30 14:53:26','0',0),(95,'Child',0.00000000,0.00,0.00,'202003300253261409_9.svg',0,0,1,'2020-03-30 14:53:26','0',0),(96,'Love',0.00000000,0.00,0.00,'202003300254114642.svg',0,0,1,'2020-03-30 14:54:11','0',0),(97,'Love',0.00000000,0.00,0.00,'202003300254114642_1.svg',0,0,1,'2020-03-30 14:54:11','0',0),(98,'Love',0.00000000,0.00,0.00,'202003300254114642_2.svg',0,0,1,'2020-03-30 14:54:11','0',0),(99,'Love',0.00000000,0.00,0.00,'202003300254114642_3.svg',0,0,1,'2020-03-30 14:54:11','0',0),(100,'Love',0.00000000,0.00,0.00,'202003300254114642_4.svg',0,0,1,'2020-03-30 14:54:11','0',0),(101,'Love',0.00000000,0.00,0.00,'202003300254114642_5.svg',0,0,1,'2020-03-30 14:54:11','0',0),(102,'Love',0.00000000,0.00,0.00,'202003300254114642_6.svg',0,0,1,'2020-03-30 14:54:11','0',0),(103,'Love',0.00000000,0.00,0.00,'202003300254114642_7.svg',0,0,1,'2020-03-30 14:54:11','0',0),(104,'Love',0.00000000,0.00,0.00,'202003300254114642_8.svg',0,0,1,'2020-03-30 14:54:11','0',0),(105,'Love',0.00000000,0.00,0.00,'202003300254114642_9.svg',0,0,1,'2020-03-30 14:54:11','0',0),(106,'Family',0.00000000,0.00,0.00,'202003300254444488.svg',0,0,1,'2020-03-30 14:54:44','0',0),(107,'Family',0.00000000,0.00,0.00,'202003300254444488_1.svg',0,0,1,'2020-03-30 14:54:44','0',0),(108,'Family',0.00000000,0.00,0.00,'202003300254444488_2.svg',0,0,1,'2020-03-30 14:54:44','0',0),(109,'Family',0.00000000,0.00,0.00,'202003300254444488_3.svg',0,0,1,'2020-03-30 14:54:44','0',0),(110,'Family',0.00000000,0.00,0.00,'202003300254444488_4.svg',0,0,1,'2020-03-30 14:54:44','0',0),(111,'Family',0.00000000,0.00,0.00,'202003300254444488_5.svg',0,0,1,'2020-03-30 14:54:44','0',0),(112,'Family',0.00000000,0.00,0.00,'202003300254444488_6.svg',0,0,1,'2020-03-30 14:54:44','0',0),(113,'Family',0.00000000,0.00,0.00,'202003300254444488_7.svg',0,0,1,'2020-03-30 14:54:44','0',0),(114,'Family',0.00000000,0.00,0.00,'202003300254444488_8.svg',0,0,1,'2020-03-30 14:54:44','0',0),(115,'Family',0.00000000,0.00,0.00,'202003300254444488_9.svg',0,0,1,'2020-03-30 14:54:44','0',0),(116,'Moon',0.00000000,0.00,0.00,'20200330025744387.svg',0,0,1,'2020-03-30 14:57:44','0',0),(117,'Moon',0.00000000,0.00,0.00,'20200330025744387_1.svg',0,0,1,'2020-03-30 14:57:44','0',0),(118,'Moon',0.00000000,0.00,0.00,'20200330025744387_2.svg',0,0,1,'2020-03-30 14:57:44','0',0),(119,'Moon',0.00000000,0.00,0.00,'20200330025744387_3.svg',0,0,1,'2020-03-30 14:57:44','0',0),(120,'Moon',0.00000000,0.00,0.00,'20200330025744387_4.svg',0,0,1,'2020-03-30 14:57:44','0',0),(121,'Beach',0.00000000,0.00,0.00,'202003300258409911.svg',0,0,1,'2020-03-30 14:58:40','0',0),(122,'Beach',0.00000000,0.00,0.00,'202003300258409911_1.svg',0,0,1,'2020-03-30 14:58:40','0',0),(123,'Beach',0.00000000,0.00,0.00,'202003300258409911_2.svg',0,0,1,'2020-03-30 14:58:40','0',0),(124,'Beach',0.00000000,0.00,0.00,'202003300258409911_3.svg',0,0,1,'2020-03-30 14:58:40','0',0),(125,'Beach',0.00000000,0.00,0.00,'202003300258409911_4.svg',0,0,1,'2020-03-30 14:58:40','0',0),(126,'Beach',0.00000000,0.00,0.00,'202003300258409911_5.svg',0,0,1,'2020-03-30 14:58:40','0',0),(127,'Beach',0.00000000,0.00,0.00,'202003300258409911_6.svg',0,0,1,'2020-03-30 14:58:40','0',0),(128,'Beach',0.00000000,0.00,0.00,'202003300258409911_7.svg',0,0,1,'2020-03-30 14:58:40','0',0),(134,'Beach - TEST 001',0.00000000,0.00,0.00,'20200331083640703.svg',0,0,1,'2020-03-31 08:36:40','0',0);
/*!40000 ALTER TABLE `cliparts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `color_palettes`
--

DROP TABLE IF EXISTS `color_palettes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `color_palettes` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) NOT NULL,
  `subcategory_id` bigint(20) NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `price` decimal(20,8) DEFAULT NULL,
  `value` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hex_value` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=193 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `color_palettes`
--

LOCK TABLES `color_palettes` WRITE;
/*!40000 ALTER TABLE `color_palettes` DISABLE KEYS */;
INSERT INTO `color_palettes` VALUES (1,1,28,'Light Grey',0.00000000,'0,6,6,9','#e7d8d8',1,'2020-03-30 15:00:27',0),(2,1,28,'Pink',0.00000000,'0,47,47,10','#e67b7b',1,'2020-03-30 16:11:45',0),(3,1,28,'Yellow',0.00000000,'0,3,62,4','#f6ee5e',1,'2020-03-30 16:13:10',0),(4,1,28,'Light Red',0.00000000,'0,31,31,1','#fdaeae',1,'2020-03-30 16:13:34',0),(5,1,28,'Light Blue',0.00000000,'35,6,0,3','#a0e7f7',1,'2020-03-30 16:15:24',0),(6,1,28,'Lime Green',0.00000000,'47,0,35,2','#85f9a1',1,'2020-03-30 16:15:49',0),(7,1,28,'Red',0.00000000,'0,26,26,1','#fdbaba',1,'2020-03-30 16:45:26',0),(8,1,28,'Red',0.00000000,'0,16,16,0','#ffd5d5',1,'2020-03-30 16:48:00',0),(9,1,28,'Pink',0.00000000,'0,50,2,0','#ff7ff9',1,'2020-03-30 16:48:23',0),(10,1,28,'Pink',0.00000000,'9,36,0,0','#e8a2ff',1,'2020-03-30 16:48:46',0),(11,1,28,'Pink',0.00000000,'2,16,0,0','#fad7ff',1,'2020-03-30 16:50:03',0),(12,1,28,'Pink',0.00000000,'21,39,0,3','#c296f7',1,'2020-03-30 16:50:21',0),(13,1,28,'Light Purple',0.00000000,'54,51,0,0','#757dff',1,'2020-03-30 16:51:13',0),(14,1,28,'Purple',0.00000000,'29,29,0,0','#b6b4ff',1,'2020-03-30 16:51:51',0),(15,1,28,'Greyish Blue',0.00000000,'35,22,0,2','#a3c2f9',1,'2020-03-30 16:52:35',0),(16,1,28,'Light Blue',0.00000000,'42,18,0,0','#94d2ff',1,'2020-03-30 16:53:32',0),(17,1,28,'Grey Blue',0.00000000,'34,9,0,0','#a8e9ff',1,'2020-03-30 16:54:01',0),(18,1,28,'Sea Green',0.00000000,'60,0,3,0','#65fff7',1,'2020-03-30 16:54:34',0),(19,1,28,'Light Blue',0.00000000,'42,0,0,0','#94fffe',1,'2020-03-30 16:55:09',0),(20,1,28,'Bluish White',0.00000000,'21,0,3,2','#c6fbf4',1,'2020-03-30 16:55:46',0),(21,1,28,'Bluish Green',0.00000000,'36,0,22,0','#a3ffc7',1,'2020-03-30 16:56:17',0),(22,1,28,'Green',0.00000000,'54,0,51,0','#76ff7c',1,'2020-03-30 16:56:49',0),(23,1,28,'Green',0.00000000,'31,0,25,0','#b1ffbf',1,'2020-03-30 16:57:27',0),(24,1,28,'Green',0.00000000,'19,0,19,0','#cfffcf',1,'2020-03-30 16:58:08',0),(25,1,28,'Dark Lime',0.00000000,'35,0,60,0','#a6ff66',1,'2020-03-30 16:58:34',0),(26,1,28,'Lime',0.00000000,'18,0,48,0','#d2ff84',1,'2020-03-30 16:58:58',0),(27,1,28,'Pista',0.00000000,'9,0,22,1','#e6fdc5',1,'2020-03-30 16:59:25',0),(28,1,28,'Light Yellow',0.00000000,'0,1,34,1','#fdfba8',1,'2020-03-30 16:59:51',0),(29,1,28,'Light Yellow',0.00000000,'0,7,45,4','#f5e587',1,'2020-03-30 17:01:24',0),(30,1,28,'Orange Light',0.00000000,'0,28,48,4','#f5b17f',1,'2020-03-30 17:03:39',0),(31,1,28,'Cream',0.00000000,'0,10,21,0','#ffe5ca',1,'2020-03-30 17:04:05',0),(32,1,29,'Dark',0.00000000,'0,100,100,98','#040000',1,'2020-03-30 17:04:36',0),(33,1,29,'Pink',0.00000000,'0,100,13,55','#720063',1,'2020-03-30 17:04:59',0),(34,1,29,'Pink',0.00000000,'0,100,13,35','#a5008f',1,'2020-03-30 17:05:24',0),(35,1,29,'Pink',0.00000000,'0,100,13,8','#eb00cc',1,'2020-03-30 17:06:01',0),(36,1,29,'Pink',0.00000000,'0,86,12,0','#ff23e1',1,'2020-03-30 17:06:22',0),(37,1,29,'Pink',0.00000000,'0,70,9,0','#ff4ce7',1,'2020-03-30 17:06:47',0),(38,1,29,'Purple',0.00000000,'51,100,0,54','#3a0076',1,'2020-03-30 17:07:13',0),(39,1,29,'Purple',0.00000000,'51,100,0,30','#5800b3',1,'2020-03-30 17:07:40',0),(40,1,29,'Purple',0.00000000,'51,100,0,0','#7d00ff',1,'2020-03-30 17:08:08',0),(41,1,29,'Purple',0.00000000,'43,84,0,0','#9228ff',1,'2020-03-30 17:08:38',0),(42,1,29,'Purple',0.00000000,'36,71,0,0','#a34aff',1,'2020-03-30 17:09:04',0),(43,1,29,'Blue',0.00000000,'100,80,0,66','#001156',1,'2020-03-30 17:09:31',0),(44,1,29,'Blue',0.00000000,'100,81,0,37','#001fa1',1,'2020-03-30 17:09:53',0),(45,1,29,'Blue',0.00000000,'100,81,0,18','#0028d2',1,'2020-03-30 17:10:19',0),(46,1,29,'Blue',0.00000000,'90,73,0,0','#1a46ff',1,'2020-03-30 17:10:52',0),(47,1,29,'Blue',0.00000000,'72,58,0,0','#486bff',1,'2020-03-30 17:11:17',0),(48,1,29,'Blue',0.00000000,'100,29,0,42','#006a95',1,'2020-03-30 17:11:46',0),(49,1,29,'Blue',0.00000000,'100,29,0,22','#008cc6',1,'2020-03-30 17:12:13',0),(50,1,29,'Blue',0.00000000,'100,29,0,0','#00b5ff',1,'2020-03-30 17:14:58',0),(51,1,29,'Blue',0.00000000,'78,23,0,0','#38c5ff',1,'2020-03-30 17:15:23',0),(52,1,29,'Green',0.00000000,'100,0,31,31','#00af79',1,'2020-03-30 17:15:48',0),(53,1,29,'Green',0.00000000,'100,0,31,13','#00de9a',1,'2020-03-30 17:16:13',0),(54,1,29,'Darkish Blue Green',0.00000000,'96,0,29,0','#09ffb4',1,'2020-03-30 17:16:54',0),(55,1,29,'Green',0.00000000,'74,0,23,0','#42ffc5',1,'2020-03-30 17:17:20',0),(56,1,29,'Green',0.00000000,'58,0,100,32','#49ad00',1,'2020-03-30 17:19:23',0),(57,1,29,'Green',0.00000000,'58,0,100,15','#5bd800',1,'2020-03-30 17:19:49',0),(58,1,29,'Green',0.00000000,'51,0,88,0','#7dff1e',1,'2020-03-30 17:20:16',0),(59,1,29,'Green',0.00000000,'42,0,73,0','#94ff46',1,'2020-03-30 17:20:41',0),(60,1,29,'Yellow',0.00000000,'0,15,100,31','#af9500',1,'2020-03-30 17:21:03',0),(61,1,29,'Yellow',0.00000000,'0,15,100,14','#dcbb00',1,'2020-03-30 17:21:29',0),(62,1,29,'Blood Red',0.00000000,'0,100,100,55','#720000',1,'2020-03-30 17:21:56',0),(63,1,29,'Deep Red',0.00000000,'0,100,100,28','#b80000',1,'2020-03-30 17:22:27',0),(64,1,29,'Blood Red',0.00000000,'0,100,100,0','#ff0000',1,'2020-03-30 17:22:55',0),(65,1,30,'Black ',0.00000000,'0,2,2,67','#535151',1,'2020-03-30 17:23:27',0),(66,1,30,'Grey',0.00000000,'0,2,2,67','#535151',1,'2020-03-30 17:55:53',0),(67,1,30,'Black',0.00000000,'0,30,30,92','#140e0e',1,'2020-03-30 17:56:21',0),(68,1,30,'White',0.00000000,'0,2,2,0','#fffbfb',1,'2020-03-30 17:56:53',0),(69,1,30,'Black',0.00000000,'0,2,2,75','#3f3e3e',1,'2020-03-30 17:57:48',0),(70,1,30,'Grey',0.00000000,'0,3,3,38','#9f9b9b',1,'2020-03-30 17:58:13',0),(71,1,30,'Black',0.00000000,'0,0,0,92','#141414',1,'2020-03-30 17:58:37',0),(72,1,30,'Grey',0.00000000,'0,0,0,53','#787878',1,'2020-03-30 17:59:27',0),(73,1,30,'Black',0.00000000,'0,16,16,83','#2b2424',1,'2020-03-30 18:00:29',0),(74,1,30,'Grey',0.00000000,'0,3,3,55','#726f6f',1,'2020-03-30 18:00:51',0),(75,1,30,'Light Grey',0.00000000,'0,1,1,15','#d8d6d6',1,'2020-03-30 18:01:14',0),(76,1,30,'Black',0.00000000,'0,81,81,94','#100303',1,'2020-03-30 18:01:36',0),(77,1,30,'Grey',0.00000000,'0,3,3,38','#9d9999',1,'2020-03-30 18:01:57',0),(78,1,30,'Grey',0.00000000,'0,3,3,53','#787575',1,'2020-03-30 18:02:26',0),(79,1,30,'Black',0.00000000,'0,80,80,96','#0a0202',1,'2020-03-30 18:02:49',0),(80,1,30,'Black',0.00000000,'0,40,40,96','#0a0606',1,'2020-03-30 18:03:21',0),(81,1,30,'Grey',0.00000000,'0,1,1,15','#d8d6d6',1,'2020-03-30 18:03:44',0),(82,1,30,'Grey',0.00000000,'0,2,2,50','#807e7e',1,'2020-03-30 18:04:13',0),(83,1,30,'Black',0.00000000,'0,0,0,96','#0a0a0a',1,'2020-03-30 18:04:35',0),(84,1,30,'Dark Grey',0.00000000,'0,4,4,73','#454242',1,'2020-03-30 18:05:01',0),(85,1,30,'Grey',0.00000000,'0,2,2,54','#767474',1,'2020-03-30 18:05:24',0),(86,1,30,'Grey',0.00000000,'0,0,0,15','#d9d9d9',1,'2020-03-30 18:05:47',0),(87,1,30,'White',0.00000000,'0,2,2,3','#f7f3f3',1,'2020-03-30 18:06:58',0),(88,1,30,'Black',0.00000000,'0,0,0,100','#000000',1,'2020-03-30 18:07:38',0),(89,1,30,'Grey',0.00000000,'0,0,0,75','#3f3f3f',1,'2020-03-30 18:08:02',0),(90,1,30,'Grey',0.00000000,'0,0,0,63','#5e5e5e',1,'2020-03-30 18:08:37',0),(91,1,30,'Grey',0.00000000,'0,0,0,42','#959595',1,'2020-03-30 18:09:04',0),(92,1,30,'Grey',0.00000000,'0,0,0,31','#b1b1b1',1,'2020-03-30 18:09:37',0),(95,4,37,'Pattern',0.00000000,'202003300618024393.png','',1,'2020-03-30 18:18:02',0),(96,4,37,'Pattern',0.00000000,'202003300618251382.png','',1,'2020-03-30 18:18:25',0),(97,4,37,'Blue',0.00000000,'202003300620213083.png','',1,'2020-03-30 18:20:21',0),(98,4,37,'Blue',0.00000000,'202003300623353057.png','',1,'2020-03-30 18:23:35',0),(99,4,37,'Green',0.00000000,'202003300624135511.png','',1,'2020-03-30 18:24:13',0),(100,4,37,'Red',0.00000000,'202003300624334685.png','',1,'2020-03-30 18:24:34',0),(101,4,37,'Pattern',0.00000000,'202003300633506148.png','',1,'2020-03-30 18:33:50',0),(102,4,37,'Pettern',0.00000000,'202003300634123769.png','',1,'2020-03-30 18:34:12',0),(103,4,37,'Blue',0.00000000,'202003300634329671.png','',1,'2020-03-30 18:34:32',0),(104,4,37,'Pattern',0.00000000,'202003300634559920.png','',1,'2020-03-30 18:34:55',0),(105,4,37,'Pattern',0.00000000,'202003300636033283.png','',1,'2020-03-30 18:36:03',0),(106,4,37,'Pattern',0.00000000,'202003300636249333.png','',1,'2020-03-30 18:36:24',0),(107,4,37,'Pattern',0.00000000,'20200330063648204.png','',1,'2020-03-30 18:36:48',0),(108,4,37,'Pattern',0.00000000,'20200330063725900.png','',1,'2020-03-30 18:37:25',0),(109,4,37,'Pattern',0.00000000,'20200330063753383.png','',1,'2020-03-30 18:37:53',0),(110,4,37,'Blue',0.00000000,'202003300638168877.png','',1,'2020-03-30 18:38:16',0),(111,4,37,'Pattern',0.00000000,'202003300638368049.png','',1,'2020-03-30 18:38:36',0),(112,4,37,'Red',0.00000000,'202003300638514686.png','',1,'2020-03-30 18:38:51',0),(113,4,38,'Pink',0.00000000,'202003300639098502.png','',1,'2020-03-30 18:39:09',0),(114,4,38,'Grey',0.00000000,'202003300639358806.png','',1,'2020-03-30 18:39:35',0),(115,4,38,'Blue',0.00000000,'20200330063950994.png','',1,'2020-03-30 18:39:50',0),(116,4,38,'Pink',0.00000000,'202003300640029356.png','',1,'2020-03-30 18:40:02',0),(117,4,38,'Blue',0.00000000,'202003300640168084.png','',1,'2020-03-30 18:40:16',0),(118,4,38,'Blue',0.00000000,'202003300640346077.png','',1,'2020-03-30 18:40:34',0),(119,4,38,'Green',0.00000000,'202003300640539398.png','',1,'2020-03-30 18:40:53',0),(120,4,38,'Orange',0.00000000,'202003300641086031.png','',1,'2020-03-30 18:41:08',0),(121,4,38,'Blue',0.00000000,'20200330064214459.png','',1,'2020-03-30 18:42:14',0),(122,4,38,'Green',0.00000000,'202003300642301201.png','',1,'2020-03-30 18:42:30',0),(123,4,38,'Grey',0.00000000,'202003300642464780.png','',1,'2020-03-30 18:42:46',0),(124,4,38,'Pink',0.00000000,'202003300643032494.png','',1,'2020-03-30 18:43:03',0),(125,4,38,'Pink',0.00000000,'202003300643322820.png','',1,'2020-03-30 18:43:32',0),(126,4,38,'Pink',0.00000000,'202003300643518467.png','',1,'2020-03-30 18:43:51',0),(127,2,31,'Sea Green',0.00000000,'46,139,87','#2e8b57',1,'2020-03-30 19:39:31',0),(128,2,31,'Dark Sea Green',0.00000000,'143,188,143','#8fbc8f',1,'2020-03-30 19:40:01',0),(129,2,31,'Pale Green',0.00000000,'152,251,152','#98fb98',1,'2020-03-30 19:40:27',0),(130,2,31,'Light Green',0.00000000,'144,238,144','#90ee90',1,'2020-03-30 19:41:02',0),(131,2,31,'Spring Green',0.00000000,'0,255,127','#00ff7f',1,'2020-03-30 19:41:28',0),(132,2,31,'Yellow Green',0.00000000,'154,205,50','#9acd32',1,'2020-03-30 19:41:54',0),(133,2,31,'Green Yellow',0.00000000,'173,255,47','#adff2f',1,'2020-03-30 19:42:25',0),(134,2,31,'Green',0.00000000,'0,128,0','#008000',1,'2020-03-30 19:43:30',0),(135,2,31,'Dark Green',0.00000000,'34,139,34','#228b22',1,'2020-03-30 19:43:55',0),(136,2,31,'Green',0.00000000,'0,255,0','#00ff00',1,'2020-03-30 19:44:43',0),(137,2,31,'Green',0.00000000,'44,143,96','#2c8f60',1,'2020-03-30 19:55:08',0),(138,2,31,'Light Green',0.00000000,'132,230,106','#84e66a',1,'2020-03-30 19:55:40',0),(139,2,31,'Green',0.00000000,'64,129,81','#408151',1,'2020-03-30 19:56:00',0),(140,2,31,'Green',0.00000000,'53,116,64','#357440',1,'2020-03-30 19:56:26',0),(141,2,32,'Dark Yellow',0.00000000,'204,204,0','#cccc00',1,'2020-03-30 19:56:58',0),(142,2,32,'Light Yellow',0.00000000,'255,255,51','#ffff33',1,'2020-03-30 19:57:23',0),(143,2,32,'Light Yellow',0.00000000,'255,255,102','#ffff66',1,'2020-03-30 19:57:59',0),(144,2,32,'Yellow',0.00000000,'255,255,0','#ffff00',1,'2020-03-30 19:58:22',0),(145,2,33,'Maroon',0.00000000,'128,0,0','#800000',1,'2020-03-30 19:58:48',0),(146,2,33,'Dark Red',0.00000000,'139,0,0','#8b0000',1,'2020-03-30 19:59:15',0),(147,2,33,'Indian Red',0.00000000,'205,92,92','#cd5c5c',1,'2020-03-30 19:59:39',0),(148,2,33,'Crimson',0.00000000,'220,20,60','#dc143c',1,'2020-03-30 20:00:04',0),(149,2,33,'Red',0.00000000,'178,34,34','#b22222',1,'2020-03-30 20:00:28',0),(150,2,33,'Red',0.00000000,'255,0,0','#ff0000',1,'2020-03-30 20:00:51',0),(151,5,40,'Blue',0.00000000,'#2f54a1','#2f54a1',1,'2020-03-31 03:57:08',0),(152,5,40,'Maroon',0.00000000,'#da3b3b','#da3b3b',1,'2020-03-31 03:57:32',0),(153,5,40,'Green',0.00000000,'#0c9937','#0c9937',1,'2020-03-31 03:58:02',0),(154,5,40,'Yellow',0.00000000,'#d8e612','#d8e612',1,'2020-03-31 03:58:34',0),(155,5,40,'Violet',0.00000000,'#7735e9','#7735e9',1,'2020-03-31 03:59:10',0),(156,5,40,'Brown',0.00000000,'#501818','#501818',1,'2020-03-31 03:59:46',0),(157,5,40,'Orange',0.00000000,'#d23636','#d23636',1,'2020-03-31 04:00:23',0),(158,5,40,'Grey',0.00000000,'#250505','#250505',1,'2020-03-31 04:00:42',0),(159,5,40,'Black',0.00000000,'#141313','#141313',1,'2020-03-31 04:01:00',0),(160,5,40,'Red',0.00000000,'#b40f0f','#b40f0f',1,'2020-03-31 04:01:33',0),(161,5,40,'Blue',0.00000000,'#3430fd','#3430fd',1,'2020-03-31 04:02:22',0),(163,3,63,'270 C',0.00000000,'#B4B5DF','#B4B5DF',1,'2020-03-31 06:14:02',0),(164,3,63,'7444 C',0.00000000,'#B6B8DC','#B6B8DC',1,'2020-03-31 06:14:27',0),(165,3,63,'543 C',0.00000000,'#A4C8E1','#A4C8E1',1,'2020-03-31 06:14:58',0),(166,3,63,'5493 C',0.00000000,'#7FA9AE','#7FA9AE',1,'2020-03-31 06:15:22',0),(167,3,63,'7590 C',0.00000000,'#D4B59E','#D4B59E',1,'2020-03-31 06:16:01',0),(168,3,63,'700 C',0.00000000,'#F2ACB9','#F2ACB9',1,'2020-03-31 06:16:15',0),(169,3,63,'7437 C',0.00000000,'#CCAED0','#CCAED0',1,'2020-03-31 06:16:32',0),(170,3,63,'7513 C',0.00000000,'#E1B7A7','#E1B7A7',1,'2020-03-31 06:16:50',0),(171,3,63,'421 C',0.00000000,'#B2B4B2','#B2B4B2',1,'2020-03-31 06:17:11',0),(172,3,63,'7471 C',0.00000000,'#7EDDD3','#7EDDD3',1,'2020-03-31 06:17:42',0),(173,3,63,'558 C',0.00000000,'#9ABEAA','#9ABEAA',1,'2020-03-31 06:18:04',0),(174,3,63,'580 C',0.00000000,'#C4D6A4','#C4D6A4',1,'2020-03-31 06:18:20',0),(175,3,63,'7403 C',0.00000000,'#EED484','#EED484',1,'2020-03-31 06:18:45',0),(176,3,63,'379 C',0.00000000,'#E2E868','#E2E868',1,'2020-03-31 06:19:21',0),(177,3,63,'656 C',0.00000000,'#DDE5ED','#DDE5ED',1,'2020-03-31 06:20:09',0),(178,3,64,'7566 C',0.00000000,'#AD6433','#AD6433',1,'2020-03-31 06:25:26',0),(179,3,64,'874 C',0.00000000,'#8B6F4E','#8B6F4E',1,'2020-03-31 06:26:27',0),(180,3,64,'1788 C',0.00000000,'#EE2737','#EE2737',1,'2020-03-31 06:26:50',0),(181,3,64,'7579 C',0.00000000,'#DC582A','#DC582A',1,'2020-03-31 06:27:07',0),(182,3,64,'7488 C',0.00000000,'#78D64B','#78D64B',1,'2020-03-31 06:27:28',0),(183,3,64,'2727 C',0.00000000,'#307FE2','#307FE2',1,'2020-03-31 06:27:49',0),(184,3,64,'807 C',0.00000000,'#EA27C2','#EA27C2',1,'2020-03-31 06:28:20',0),(185,3,64,'653 C',0.00000000,'#326295','#326295',1,'2020-03-31 06:28:44',0),(186,3,64,'7651 C',0.00000000,'#6A2A5B','#6A2A5B',1,'2020-03-31 06:29:04',0),(187,3,64,'267 C',0.00000000,'#5F259F','#5F259F',1,'2020-03-31 06:29:23',0),(188,3,64,'2623 C',0.00000000,'#5F2167','#5F2167',1,'2020-03-31 06:29:41',0),(189,3,64,'5605 C',0.00000000,'#22372B','#22372B',1,'2020-03-31 06:30:12',0),(190,3,64,'5605 C',0.00000000,'#22372B','#22372B',1,'2020-03-31 06:30:42',0),(191,3,64,'504 C',0.00000000,'#572932','#572932',1,'2020-03-31 06:31:13',0),(192,3,64,'213 C',0.00000000,'#E31C79','#E31C79',1,'2020-03-31 06:31:56',0);
/*!40000 ALTER TABLE `color_palettes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `color_swatches`
--

DROP TABLE IF EXISTS `color_swatches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `color_swatches` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `hex_code` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `color_type` int(10) DEFAULT NULL,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `color_swatches`
--

LOCK TABLES `color_swatches` WRITE;
/*!40000 ALTER TABLE `color_swatches` DISABLE KEYS */;
INSERT INTO `color_swatches` VALUES (1,'White','#ffffff',NULL,4,0),(2,'Black','#050404',NULL,5,0),(3,'Red','#ee0000',NULL,5,0),(4,'Green','#21e842',NULL,6,0),(5,'Blue','#021ddd',NULL,5,0);
/*!40000 ALTER TABLE `color_swatches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `color_types`
--

DROP TABLE IF EXISTS `color_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `color_types` (
  `xe_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `color_types`
--

LOCK TABLES `color_types` WRITE;
/*!40000 ALTER TABLE `color_types` DISABLE KEYS */;
INSERT INTO `color_types` VALUES (4,'White'),(5,'Dark'),(6,'Light');
/*!40000 ALTER TABLE `color_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_pattern_category_rel`
--

DROP TABLE IF EXISTS `config_pattern_category_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `config_pattern_category_rel` (
  `config_pattern_id` bigint(20) DEFAULT NULL,
  `category_id` bigint(20) DEFAULT NULL,
  KEY `config_pattern_category_rel_index_001` (`config_pattern_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_pattern_category_rel`
--

LOCK TABLES `config_pattern_category_rel` WRITE;
/*!40000 ALTER TABLE `config_pattern_category_rel` DISABLE KEYS */;
INSERT INTO `config_pattern_category_rel` VALUES (1,69),(2,69),(3,69),(4,69),(5,69);
/*!40000 ALTER TABLE `config_pattern_category_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configurator_colors`
--

DROP TABLE IF EXISTS `configurator_colors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configurator_colors` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `price` decimal(20,8) DEFAULT NULL,
  `value` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hex_value` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=193 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configurator_colors`
--

LOCK TABLES `configurator_colors` WRITE;
/*!40000 ALTER TABLE `configurator_colors` DISABLE KEYS */;
/*!40000 ALTER TABLE `configurator_colors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configurator_pattern`
--

DROP TABLE IF EXISTS `configurator_pattern`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configurator_pattern` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) DEFAULT NULL,
  `price` decimal(6,2) DEFAULT NULL,
  `file_name` varchar(60) DEFAULT NULL,
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configurator_pattern`
--

LOCK TABLES `configurator_pattern` WRITE;
/*!40000 ALTER TABLE `configurator_pattern` DISABLE KEYS */;
INSERT INTO `configurator_pattern` VALUES (1,'bricks',0.00,'202403290643443216.svg',1,'2024-04-29 09:32:00',0),(2,'spring',0.00,'202404080306247981.svg',1,'2024-04-29 09:32:00',0),(3,'grain',0.00,'202404081146041729.svg',1,'2024-04-29 09:32:00',0),(4,'spiral',0.00,'202403250731361997.svg',1,'2024-04-29 09:32:00',0),(5,'concrete',0.00,'202403290253063457.svg',1,'2024-04-29 09:32:00',0);
/*!40000 ALTER TABLE `configurator_pattern` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_additional_info`
--

DROP TABLE IF EXISTS `customer_additional_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_additional_info` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `customer_id` varchar(50) DEFAULT NULL,
  `customer_email` varchar(255) DEFAULT NULL,
  `stripe_customer_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_additional_info`
--

LOCK TABLES `customer_additional_info` WRITE;
/*!40000 ALTER TABLE `customer_additional_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_additional_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_group_assets_category_rel`
--

DROP TABLE IF EXISTS `customer_group_assets_category_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_group_assets_category_rel` (
  `customer_group_id` varchar(50) NOT NULL,
  `asset_type_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_group_assets_category_rel`
--

LOCK TABLES `customer_group_assets_category_rel` WRITE;
/*!40000 ALTER TABLE `customer_group_assets_category_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_group_assets_category_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_group_relation`
--

DROP TABLE IF EXISTS `customer_group_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_group_relation` (
  `customer_id` varchar(50) NOT NULL,
  `customer_group_id` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_group_relation`
--

LOCK TABLES `customer_group_relation` WRITE;
/*!40000 ALTER TABLE `customer_group_relation` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_group_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_group_tier_discount`
--

DROP TABLE IF EXISTS `customer_group_tier_discount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_group_tier_discount` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_group_id` varchar(50) NOT NULL,
  `qty_from` int(11) NOT NULL,
  `qty_to` int(11) NOT NULL,
  `discount_rate` float NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_group_tier_discount`
--

LOCK TABLES `customer_group_tier_discount` WRITE;
/*!40000 ALTER TABLE `customer_group_tier_discount` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_group_tier_discount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_groups`
--

DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL,
  `discount_enable` tinyint(4) NOT NULL,
  `discount_type` enum('flat','tier') DEFAULT NULL,
  `tier_price_enable` tinyint(1) NOT NULL,
  `flat_discount` float DEFAULT NULL,
  `group_url` varchar(45) DEFAULT NULL,
  `group_address` text,
  `group_img` text,
  `group_primary_email` varchar(45) DEFAULT NULL,
  `group_secondary_email` varchar(45) DEFAULT NULL,
  `group_primary_number` varchar(45) DEFAULT NULL,
  `group_alt_number` varchar(45) DEFAULT NULL,
  `group_fax` varchar(45) DEFAULT NULL,
  `slug` varchar(45) DEFAULT NULL,
  `store_id` int(11) NOT NULL,
  `store_ref_id` varchar(50) DEFAULT NULL,
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_groups`
--

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_internal_note_files`
--

DROP TABLE IF EXISTS `customer_internal_note_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_internal_note_files` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `note_id` int(11) NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_internal_note_files`
--

LOCK TABLES `customer_internal_note_files` WRITE;
/*!40000 ALTER TABLE `customer_internal_note_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_internal_note_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_internal_notes`
--

DROP TABLE IF EXISTS `customer_internal_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_internal_notes` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `customer_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `note` text COLLATE utf8_unicode_ci NOT NULL,
  `user_type` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT 'admin, agent',
  `user_id` int(11) NOT NULL,
  `seen_flag` tinyint(1) NOT NULL DEFAULT '0',
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`xe_id`),
  KEY `customer_internal_notes` (`customer_id`,`created_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_internal_notes`
--

LOCK TABLES `customer_internal_notes` WRITE;
/*!40000 ALTER TABLE `customer_internal_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_internal_notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `decoration_objects`
--

DROP TABLE IF EXISTS `decoration_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `decoration_objects` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `3d_object_file` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uv_file` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `decoration_objects`
--

LOCK TABLES `decoration_objects` WRITE;
/*!40000 ALTER TABLE `decoration_objects` DISABLE KEYS */;
/*!40000 ALTER TABLE `decoration_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `design_states`
--

DROP TABLE IF EXISTS `design_states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `design_states` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_setting_id` int(11) DEFAULT NULL,
  `product_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `product_variant_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'cart',
  `custom_price` float DEFAULT NULL,
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `selected_category_id` text COLLATE utf8_unicode_ci,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `design_states`
--

LOCK TABLES `design_states` WRITE;
/*!40000 ALTER TABLE `design_states` DISABLE KEYS */;
/*!40000 ALTER TABLE `design_states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `distress_category_rel`
--

DROP TABLE IF EXISTS `distress_category_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `distress_category_rel` (
  `distress_id` bigint(20) DEFAULT NULL,
  `category_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `distress_category_rel`
--

LOCK TABLES `distress_category_rel` WRITE;
/*!40000 ALTER TABLE `distress_category_rel` DISABLE KEYS */;
INSERT INTO `distress_category_rel` VALUES (1,21),(2,21),(3,21),(4,21),(5,21),(6,21),(7,21),(8,21),(9,21),(10,21),(11,21),(12,21),(13,21);
/*!40000 ALTER TABLE `distress_category_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `distress_tag_rel`
--

DROP TABLE IF EXISTS `distress_tag_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `distress_tag_rel` (
  `distress_id` bigint(20) DEFAULT NULL,
  `tag_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `distress_tag_rel`
--

LOCK TABLES `distress_tag_rel` WRITE;
/*!40000 ALTER TABLE `distress_tag_rel` DISABLE KEYS */;
INSERT INTO `distress_tag_rel` VALUES (2,6),(3,7),(4,7),(5,7),(6,16),(7,16),(7,6),(8,6),(9,6),(10,6),(11,6),(12,6),(13,7);
/*!40000 ALTER TABLE `distress_tag_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `distresses`
--

DROP TABLE IF EXISTS `distresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `distresses` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `distresses`
--

LOCK TABLES `distresses` WRITE;
/*!40000 ALTER TABLE `distresses` DISABLE KEYS */;
INSERT INTO `distresses` VALUES (2,'Distress','202003300629173054.jpg',1,'2020-03-30 18:29:17',0),(3,'Distress Effect','202003300630349558.png',1,'2020-03-30 18:30:34',0),(4,'Distress Effect','202003300630565691.png',1,'2020-03-30 18:30:56',0),(5,'Distress Effect','202003300631151926.png',1,'2020-03-30 18:31:15',0),(8,'Distress','202003310848568937.png',1,'2020-03-31 08:48:56',0),(9,'Distress','202003310849161969.png',1,'2020-03-31 08:49:16',0),(10,'Distress','202003310849335632.png',1,'2020-03-31 08:49:33',0),(11,'Distress','202003310849509466.png',1,'2020-03-31 08:49:50',0),(12,'Distress','202003310850064436.png',1,'2020-03-31 08:50:06',0),(13,'Distress Effect','202003310850352984.png',1,'2020-03-31 08:50:35',0);
/*!40000 ALTER TABLE `distresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_log`
--

DROP TABLE IF EXISTS `email_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_log` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `module` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `message` text COLLATE utf8_unicode_ci NOT NULL,
  `total_email_count` int(11) NOT NULL,
  `success_email` text COLLATE utf8_unicode_ci,
  `failure_email` text COLLATE utf8_unicode_ci,
  `skipped_email` text COLLATE utf8_unicode_ci,
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_log`
--

LOCK TABLES `email_log` WRITE;
/*!40000 ALTER TABLE `email_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `engraved_surfaces`
--

DROP TABLE IF EXISTS `engraved_surfaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `engraved_surfaces` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `surface_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `engraved_type` enum('image','color') COLLATE utf8_unicode_ci DEFAULT NULL,
  `engrave_type_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'color code or image url',
  `engrave_preview_type` enum('image','color') COLLATE utf8_unicode_ci DEFAULT NULL,
  `engrave_preview_type_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shadow_direction` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shadow_size` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shadow_opacity` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shadow_strength` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shadow_blur` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_user_defined` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `engraved_surfaces`
--

LOCK TABLES `engraved_surfaces` WRITE;
/*!40000 ALTER TABLE `engraved_surfaces` DISABLE KEYS */;
INSERT INTO `engraved_surfaces` VALUES (1,'Wooden',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),(2,'Metal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `engraved_surfaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `features`
--

DROP TABLE IF EXISTS `features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `features` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_type_id` int(11) NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `features`
--

LOCK TABLES `features` WRITE;
/*!40000 ALTER TABLE `features` DISABLE KEYS */;
INSERT INTO `features` VALUES (1,2,'Clipart library','clipart'),(2,11,'Use from templates','template'),(3,1,'Backgrounds','background'),(4,0,'Draw with your hand','drawing'),(5,9,'Shapes library','shape'),(6,0,'Upload design','image'),(7,0,'Add text','text'),(8,0,'Team jersey','team'),(9,0,'VDP','vdp'),(10,0,'AR','ar'),(11,0,'Gallery','gallery'),(12,0,'QR code','qr'),(13,5,'Distress','distress');
/*!40000 ALTER TABLE `features` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `font_category_rel`
--

DROP TABLE IF EXISTS `font_category_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `font_category_rel` (
  `font_id` bigint(20) DEFAULT NULL,
  `category_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `font_category_rel`
--

LOCK TABLES `font_category_rel` WRITE;
/*!40000 ALTER TABLE `font_category_rel` DISABLE KEYS */;
INSERT INTO `font_category_rel` VALUES (10,49),(10,50),(17,48),(17,49),(17,50),(17,51),(18,51),(18,50),(19,48),(19,49),(19,50),(19,51),(26,66),(27,66),(28,66),(29,66),(30,66),(31,66),(32,66),(33,66),(34,66),(35,66),(36,67),(37,67),(38,67),(39,67),(40,67),(41,67),(42,67),(43,67),(44,67),(45,67),(46,67),(47,67),(48,67),(49,67),(50,67),(51,67);
/*!40000 ALTER TABLE `font_category_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `font_styles`
--

DROP TABLE IF EXISTS `font_styles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `font_styles` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `style` varchar(20) DEFAULT NULL,
  `file_name` varchar(50) DEFAULT NULL,
  `font_family` varchar(60) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `font_id` bigint(20) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `font_styles`
--

LOCK TABLES `font_styles` WRITE;
/*!40000 ALTER TABLE `font_styles` DISABLE KEYS */;
/*!40000 ALTER TABLE `font_styles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `font_tag_rel`
--

DROP TABLE IF EXISTS `font_tag_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `font_tag_rel` (
  `font_id` bigint(20) DEFAULT NULL,
  `tag_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `font_tag_rel`
--

LOCK TABLES `font_tag_rel` WRITE;
/*!40000 ALTER TABLE `font_tag_rel` DISABLE KEYS */;
INSERT INTO `font_tag_rel` VALUES (17,12),(17,13),(18,14),(19,15),(25,17),(26,18),(28,19),(29,18),(30,20),(31,18),(32,18),(33,18),(34,18),(35,18),(36,18),(37,18),(38,18),(39,18),(40,18),(41,18),(42,18),(43,18),(44,18),(45,18),(46,18),(47,18),(48,18),(49,18),(50,18),(51,18);
/*!40000 ALTER TABLE `font_tag_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fonts`
--

DROP TABLE IF EXISTS `fonts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fonts` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price` decimal(20,8) DEFAULT NULL,
  `font_family` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `total_used` int(11) DEFAULT '0',
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fonts`
--

LOCK TABLES `fonts` WRITE;
/*!40000 ALTER TABLE `fonts` DISABLE KEYS */;
INSERT INTO `fonts` VALUES (26,'akaPosse',0.00000000,'akaPosse','202003310925011161.ttf',0,1,'2020-03-31 09:25:01',0),(27,'Alpha_Echo',0.00000000,'Alpha Echo','202003310925265354.ttf',0,1,'2020-03-31 09:25:26',0),(28,'Anton',0.00000000,'Anton','202003310926045250.ttf',0,1,'2020-03-31 09:26:04',0),(29,'Averia Libre',0.00000000,'Averia Libre','202003310926304601.ttf',0,1,'2020-03-31 09:26:30',0),(30,'BEBAS___',0.00000000,'Bebas','202003310926531715.ttf',0,1,'2020-03-31 09:26:53',0),(31,'Baloo',0.00000000,'Baloo','202003310927225801.ttf',0,1,'2020-03-31 09:27:22',0),(32,'Bungee',0.00000000,'Bungee','202003310929169703.ttf',0,1,'2020-03-31 09:29:16',0),(33,'CargoCrate',0.00000000,'CargoCrate','202003310930204749.ttf',0,1,'2020-03-31 09:30:20',0),(34,'Concert One',0.00000000,'Concert One','202003310931204507.ttf',0,1,'2020-03-31 09:31:20',0),(35,'Coiny',0.00000000,'Coiny','202003310932003155.ttf',0,1,'2020-03-31 09:32:00',0),(36,'Damion',0.00000000,'Damion','202003310933007365.ttf',0,1,'2020-03-31 09:33:00',0),(37,'Chango',0.00000000,'Chango','20200331093410121.ttf',0,1,'2020-03-31 09:34:10',0),(38,'Chela_One',0.00000000,'Chela One','202003310934373497.ttf',0,1,'2020-03-31 09:34:37',0),(39,'Coda',0.00000000,'Coda','202003310935105799.ttf',0,1,'2020-03-31 09:35:10',0),(40,'Concert_One',0.00000000,'Concert One','20200331093542313.ttf',0,1,'2020-03-31 09:35:42',0),(41,'Cousine',0.00000000,'Cousine','202003310936266388.ttf',0,1,'2020-03-31 09:36:26',0),(42,'Emblema One',0.00000000,'Emblema One','202003310937494491.ttf',0,1,'2020-03-31 09:37:49',0),(43,'Erica_One',0.00000000,'Erica One','202003310938179303.ttf',0,1,'2020-03-31 09:38:17',0),(44,'Expletus Sans',0.00000000,'Expletus Sans','202003310938424099.ttf',0,1,'2020-03-31 09:38:42',0),(45,'Fruktur',0.00000000,'Fruktur','202003310939502704.ttf',0,1,'2020-03-31 09:39:50',0),(46,'German Beauty',0.00000000,'German Beauty','202003310940145872.ttf',0,1,'2020-03-31 09:40:14',0),(47,'Goblin_One',0.00000000,'Goblin One','202003310941254635.ttf',0,1,'2020-03-31 09:41:25',0),(48,'Kavoon',0.00000000,'Kavoon','20200331094256611.ttf',0,1,'2020-03-31 09:42:56',0),(49,'Luckiest Guy',0.00000000,'Luckiest Guy','202003310943504592.ttf',0,1,'2020-03-31 09:43:50',0),(50,'McLaren',0.00000000,'McLaren','202003310944322269.ttf',0,1,'2020-03-31 09:44:32',0),(51,'Titan One',0.00000000,'Titan One','202003310946125894.ttf',0,1,'2020-03-31 09:46:12',0);
/*!40000 ALTER TABLE `fonts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `graphic_font_letters`
--

DROP TABLE IF EXISTS `graphic_font_letters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `graphic_font_letters` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `graphic_font_id` bigint(20) DEFAULT NULL,
  `name` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `font_type` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `graphic_font_letters`
--

LOCK TABLES `graphic_font_letters` WRITE;
/*!40000 ALTER TABLE `graphic_font_letters` DISABLE KEYS */;
INSERT INTO `graphic_font_letters` VALUES (1,1,'a','202003300731373682.svg','letter'),(2,1,'0',NULL,'number'),(5,4,'A','202003311025119118.svg','letter');
/*!40000 ALTER TABLE `graphic_font_letters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `graphic_font_tag_rel`
--

DROP TABLE IF EXISTS `graphic_font_tag_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `graphic_font_tag_rel` (
  `graphic_font_id` bigint(20) DEFAULT NULL,
  `tag_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `graphic_font_tag_rel`
--

LOCK TABLES `graphic_font_tag_rel` WRITE;
/*!40000 ALTER TABLE `graphic_font_tag_rel` DISABLE KEYS */;
INSERT INTO `graphic_font_tag_rel` VALUES (4,9);
/*!40000 ALTER TABLE `graphic_font_tag_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `graphic_fonts`
--

DROP TABLE IF EXISTS `graphic_fonts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `graphic_fonts` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price` decimal(20,8) DEFAULT NULL,
  `is_letter_style` tinyint(1) NOT NULL DEFAULT '0',
  `is_number_style` tinyint(1) NOT NULL DEFAULT '0',
  `is_special_character_style` tinyint(1) NOT NULL DEFAULT '0',
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `graphic_fonts`
--

LOCK TABLES `graphic_fonts` WRITE;
/*!40000 ALTER TABLE `graphic_fonts` DISABLE KEYS */;
INSERT INTO `graphic_fonts` VALUES (1,'Text FX',0.00000000,1,1,0,1,'2020-03-30 19:31:37',0),(4,'Text Style',0.00000000,1,0,0,1,'2020-03-31 10:25:11',0);
/*!40000 ALTER TABLE `graphic_fonts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `languages` (
  `xe_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flag` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_enable` tinyint(1) DEFAULT '0',
  `is_default` tinyint(1) DEFAULT '0',
  `store_id` int(4) DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','lang_english.json','english.png','tool',1,1,1),(2,'English','lang_english.json','english.png','admin',1,1,1),(3,'Dutch','lang_dutch.json','dutch.png','tool',0,0,1),(4,'German','lang_german.json','german.png','admin',0,0,1),(5,'French','lang_french.json','french.png','admin',0,0,1),(6,'Italian','lang_italian.json','italian.png','admin',0,0,1),(7,'Spanish','lang_spanish.json','spanish.png','admin',0,0,1),(8,'Japanese','lang_japanese.json','japanese.png','admin',0,0,1),(9,'Chinese','lang_chinese.json','chinese.png','admin',0,0,1),(10,'Dutch','lang_dutch.json','dutch.png','admin',0,0,1),(11,'Greek','lang_greek.json','greek.png','admin',0,0,1),(12,'Hebrew','lang_hebrew.json','hebrew.png','admin',0,0,1),(13,'Polish','lang_polish.json','polish.png','admin',0,0,1),(14,'Portuguese','lang_portuguese.json','portuguese.png','admin',0,0,1),(15,'Norwegian','lang_norwegian.json','norwegian.png','admin',0,0,1),(16,'French','lang_french.json','french.png','tool',0,0,1),(17,'German','lang_german.json','german.png','tool',0,0,1),(18,'Italian','lang_italian.json','italian.png','tool',0,0,1),(19,'Japanese','lang_japanese.json','japanese.png','tool',0,0,1),(20,'Polish','lang_polish.json','polish.png','tool',0,0,1),(21,'Portuguese','lang_portuguese.json','portuguese.png','tool',0,0,1),(22,'Spanish','lang_spanish.json','spanish.png','tool',0,0,1),(23,'Greek','lang_greek.json','greek.png','tool',0,0,1),(24,'Arabic','lang_arabic.json','arabic.png','tool',0,0,1),(25,'Chinese','lang_chinese.json','chinese.png','tool',0,0,1),(26,'Norwegian','lang_norwegian.json','norwegian.png','tool',0,0,1),(27,'Hebrew','lang_hebrew.json','hebrew.png','tool',0,0,1),(28,'Finnish','lang_finnish.json','finnish.png','tool',0,0,1),(29,'Finnish','lang_finnish.json','finnish.png','admin',0,0,1),(30,'Romanian','lang_romanian.json','romanian.png','tool',0,0,1),(31,'Romanian','lang_romanian.json','romanian.png','admin',0,0,1),(32,'Arabic','lang_arabic.json','arabic.png','admin',0,0,1);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `layouts`
--

DROP TABLE IF EXISTS `layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `layouts` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `layouts`
--

LOCK TABLES `layouts` WRITE;
/*!40000 ALTER TABLE `layouts` DISABLE KEYS */;
INSERT INTO `layouts` VALUES (1,'Theme 1','theme-1.svg'),(2,'Theme 2','theme-2.svg'),(3,'Theme 3','theme-3.svg');
/*!40000 ALTER TABLE `layouts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mask_tag_rel`
--

DROP TABLE IF EXISTS `mask_tag_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mask_tag_rel` (
  `mask_id` bigint(20) DEFAULT NULL,
  `tag_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mask_tag_rel`
--

LOCK TABLES `mask_tag_rel` WRITE;
/*!40000 ALTER TABLE `mask_tag_rel` DISABLE KEYS */;
INSERT INTO `mask_tag_rel` VALUES (2,8),(3,8),(4,8),(5,8),(7,8),(10,8);
/*!40000 ALTER TABLE `mask_tag_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `masks`
--

DROP TABLE IF EXISTS `masks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `masks` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mask_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `masks`
--

LOCK TABLES `masks` WRITE;
/*!40000 ALTER TABLE `masks` DISABLE KEYS */;
INSERT INTO `masks` VALUES (1,'Mask','202003300710438854.svg','202003300710439245.png',1,'2020-03-30 19:10:43',0),(2,'Image Mask','202003300711067645.svg','202003300711064245.png',1,'2020-03-30 19:11:06',0),(3,'Image Mask','202003300716447500.svg','202003300716443929.png',1,'2020-03-30 19:16:44',0),(4,'Image Mask','202003300717197689.svg','202003300717194262.png',1,'2020-03-30 19:17:19',0),(5,'Image Mask','202003300717381284.svg','202003300717385967.png',1,'2020-03-30 19:17:38',0),(6,'Image Mask','202003300718257831.svg','20200330071825492.png',1,'2020-03-30 19:18:25',0),(7,'Image Mask','202003300718519907.svg','202003300718517714.png',1,'2020-03-30 19:18:51',0),(8,'Image Mask','202003300719493322.svg','202003300719494632.png',1,'2020-03-30 19:19:49',0),(9,'Image Mask','202003300720085306.svg','202003300720084902.png',1,'2020-03-30 19:20:08',0),(10,'Image Mask','202003300720303956.svg','202003300720302447.png',1,'2020-03-30 19:20:30',0);
/*!40000 ALTER TABLE `masks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_item_token`
--

DROP TABLE IF EXISTS `order_item_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_item_token` (
  `order_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `order_item_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `token` text COLLATE utf8_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_item_token`
--

LOCK TABLES `order_item_token` WRITE;
/*!40000 ALTER TABLE `order_item_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_item_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_log_files`
--

DROP TABLE IF EXISTS `order_log_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_log_files` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_log_id` bigint(20) DEFAULT NULL,
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_log_files`
--

LOCK TABLES `order_log_files` WRITE;
/*!40000 ALTER TABLE `order_log_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_log_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_logs`
--

DROP TABLE IF EXISTS `order_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_logs` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `agent_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `agent_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `message` mediumtext COLLATE utf8_unicode_ci,
  `log_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `artwork_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `artwork_approval_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_logs`
--

LOCK TABLES `order_logs` WRITE;
/*!40000 ALTER TABLE `order_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `artwork_status` enum('pending','approved','changed','cancelled','rejected') COLLATE utf8_unicode_ci NOT NULL,
  `order_status` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'received',
  `production_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-Not started, 1-In-Progress, 2-Completed',
  `production_percentage` int(4) NOT NULL DEFAULT '0',
  `store_id` int(4) NOT NULL DEFAULT '1',
  `customer_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `po_status` int(7) NOT NULL DEFAULT '0',
  `order_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `product_count` int(5) DEFAULT NULL,
  PRIMARY KEY (`xe_id`),
  KEY `orders_index_key_01` (`order_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `overlogo_images`
--

DROP TABLE IF EXISTS `overlogo_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `overlogo_images` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `browser_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `overlogo_images`
--

LOCK TABLES `overlogo_images` WRITE;
/*!40000 ALTER TABLE `overlogo_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `overlogo_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `plugin_settings`
--

DROP TABLE IF EXISTS `plugin_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `plugin_settings` (
  `xe_id` int(3) NOT NULL AUTO_INCREMENT,
  `catalog_code` varchar(50) NOT NULL,
  `settings` text,
  `created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_date` datetime DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `plugin_settings`
--

LOCK TABLES `plugin_settings` WRITE;
/*!40000 ALTER TABLE `plugin_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `plugin_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `po_internal_note`
--

DROP TABLE IF EXISTS `po_internal_note`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `po_internal_note` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `po_id` int(11) NOT NULL,
  `user_type` enum('admin','agent') COLLATE utf8_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `note` text COLLATE utf8_unicode_ci,
  `seen_flag` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `po_internal_note`
--

LOCK TABLES `po_internal_note` WRITE;
/*!40000 ALTER TABLE `po_internal_note` DISABLE KEYS */;
/*!40000 ALTER TABLE `po_internal_note` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `po_internal_note_files`
--

DROP TABLE IF EXISTS `po_internal_note_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `po_internal_note_files` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `note_id` int(11) NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `po_internal_note_files`
--

LOCK TABLES `po_internal_note_files` WRITE;
/*!40000 ALTER TABLE `po_internal_note_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `po_internal_note_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `po_line_item_status`
--

DROP TABLE IF EXISTS `po_line_item_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `po_line_item_status` (
  `xe_id` int(7) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `status_name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `color_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `is_default` enum('1','0') COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `sort_order` int(4) NOT NULL,
  `status` enum('1','0') COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `po_line_item_status`
--

LOCK TABLES `po_line_item_status` WRITE;
/*!40000 ALTER TABLE `po_line_item_status` DISABLE KEYS */;
INSERT INTO `po_line_item_status` VALUES (1,1,'Pending','#fabc02','1',1,'1'),(2,1,'Out of stock','#FF0000','1',2,'1'),(3,1,'Received','#33a952','1',3,'1'),(4,1,'PO sent','#cc8800','1',4,'0'),(5,1,'Partially received','#997300','1',5,'0');
/*!40000 ALTER TABLE `po_line_item_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `po_log`
--

DROP TABLE IF EXISTS `po_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `po_log` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `po_id` int(11) NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `user_type` enum('admin','customer','agent') COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'i.e agent data in case of agent assignment  ',
  `user_id` int(11) DEFAULT NULL COMMENT 'i.e agent data in case of agent assignment',
  `created_date` datetime DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `po_log`
--

LOCK TABLES `po_log` WRITE;
/*!40000 ALTER TABLE `po_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `po_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `price_advanced_price_settings`
--

DROP TABLE IF EXISTS `price_advanced_price_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `price_advanced_price_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `advanced_price_type` text COLLATE utf8_unicode_ci,
  `no_of_colors_allowed` int(11) DEFAULT NULL,
  `is_full_color` tinyint(1) DEFAULT '0',
  `area_calculation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'design_area, bound_area, print_area',
  `min_price` decimal(20,8) DEFAULT NULL,
  `price_cal_type` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'design area price calculation type.',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `price_advanced_price_settings`
--

LOCK TABLES `price_advanced_price_settings` WRITE;
/*!40000 ALTER TABLE `price_advanced_price_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `price_advanced_price_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `price_default_settings`
--

DROP TABLE IF EXISTS `price_default_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `price_default_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `price_module_setting_id` int(11) NOT NULL,
  `price_key` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price_value` decimal(20,8) DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `price_default_settings`
--

LOCK TABLES `price_default_settings` WRITE;
/*!40000 ALTER TABLE `price_default_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `price_default_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `price_module_settings`
--

DROP TABLE IF EXISTS `price_module_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `price_module_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `print_profile_pricing_id` int(11) NOT NULL,
  `price_module_id` int(11) NOT NULL,
  `module_status` tinyint(1) NOT NULL,
  `is_default_price` tinyint(1) DEFAULT '0',
  `is_quote_enabled` tinyint(1) DEFAULT '0',
  `is_advance_price` tinyint(1) DEFAULT '0',
  `advance_price_settings_id` int(11) DEFAULT NULL,
  `is_quantity_tier` tinyint(1) DEFAULT '0',
  `quantity_tier_type` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `default_stitch_count_per_inch` varchar(30) COLLATE utf8_unicode_ci DEFAULT '2000',
  `max_thread_color` int(11) DEFAULT '0',
  `output_formats` mediumtext COLLATE utf8_unicode_ci,
  `digitization_cost` mediumtext COLLATE utf8_unicode_ci,
  `extra_cost` mediumtext COLLATE utf8_unicode_ci,
  `stitch_count_unit_id` tinyint(5) DEFAULT '1',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `price_module_settings`
--

LOCK TABLES `price_module_settings` WRITE;
/*!40000 ALTER TABLE `price_module_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `price_module_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `price_modules`
--

DROP TABLE IF EXISTS `price_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `price_modules` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `slug` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `sort_order_index` int(11) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `price_modules`
--

LOCK TABLES `price_modules` WRITE;
/*!40000 ALTER TABLE `price_modules` DISABLE KEYS */;
INSERT INTO `price_modules` VALUES (1,'setup',1),(2,'simple-deco',2),(3,'vdp',3),(4,'name-number',4),(5,'artwork',5),(6,'sleeve',6),(7,'image',7),(8,'letter',8),(9,'clipart',9),(10,'fonts',10),(11,'background',11),(12,'foil',12),(13,'stitch-count',13),(14,'embroidery-preview',14);
/*!40000 ALTER TABLE `price_modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `price_tier_quantity_ranges`
--

DROP TABLE IF EXISTS `price_tier_quantity_ranges`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `price_tier_quantity_ranges` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `price_module_setting_id` int(11) NOT NULL,
  `quantity_from` int(8) DEFAULT NULL,
  `quantity_to` int(8) DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `price_tier_quantity_ranges`
--

LOCK TABLES `price_tier_quantity_ranges` WRITE;
/*!40000 ALTER TABLE `price_tier_quantity_ranges` DISABLE KEYS */;
/*!40000 ALTER TABLE `price_tier_quantity_ranges` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `price_tier_values`
--

DROP TABLE IF EXISTS `price_tier_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `price_tier_values` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attribute_type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price_module_setting_id` int(11) NOT NULL,
  `print_area_index` int(5) DEFAULT NULL,
  `color_index` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `print_area_id` int(11) DEFAULT NULL COMMENT 'print area sequence index',
  `range_from` int(11) DEFAULT NULL COMMENT 'square inch value / no fo letters',
  `range_to` int(11) DEFAULT NULL COMMENT 'square inch value/ no fo letters',
  `key_name` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'For name&number, vdp, sleeve price key id',
  `screen_cost` decimal(20,8) DEFAULT NULL,
  `setup_cost` decimal(20,8) DEFAULT NULL,
  `greater_price` int(11) DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `price_tier_values`
--

LOCK TABLES `price_tier_values` WRITE;
/*!40000 ALTER TABLE `price_tier_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `price_tier_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `price_tier_whitebases`
--

DROP TABLE IF EXISTS `price_tier_whitebases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `price_tier_whitebases` (
  `price_tier_value_id` bigint(20) DEFAULT NULL,
  `tier_range_id` int(11) DEFAULT NULL,
  `white_base_type` char(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price` decimal(20,8) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `price_tier_whitebases`
--

LOCK TABLES `price_tier_whitebases` WRITE;
/*!40000 ALTER TABLE `price_tier_whitebases` DISABLE KEYS */;
/*!40000 ALTER TABLE `price_tier_whitebases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `print_area_types`
--

DROP TABLE IF EXISTS `print_area_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `print_area_types` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '0',
  `store_id` int(4) DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `print_area_types`
--

LOCK TABLES `print_area_types` WRITE;
/*!40000 ALTER TABLE `print_area_types` DISABLE KEYS */;
INSERT INTO `print_area_types` VALUES (1,'Rectangle','rectangle.svg',0,1),(2,'Square','square.svg',0,1),(3,'Circle','circle.svg',0,1),(4,'Triangle','tringle.svg',0,1),(5,'Elipse','ellipse.svg',0,1),(6,'Without bleed Mark',NULL,1,1),(7,'With bleed Mark',NULL,1,1);
/*!40000 ALTER TABLE `print_area_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `print_areas`
--

DROP TABLE IF EXISTS `print_areas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `print_areas` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `print_area_type_id` int(11) NOT NULL,
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `width` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `height` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price` decimal(20,8) DEFAULT NULL,
  `is_user_defined` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `is_default` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `store_id` int(4) DEFAULT NULL,
  `bleed_width` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bleed_height` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `safe_width` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `safe_height` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `print_areas`
--

LOCK TABLES `print_areas` WRITE;
/*!40000 ALTER TABLE `print_areas` DISABLE KEYS */;
INSERT INTO `print_areas` VALUES (3,'A3',1,NULL,'11.69','16.54',0.00000000,'0','0',1,NULL,NULL,NULL,NULL,0),(4,'A4',1,NULL,'8.27','11.69',0.00000000,'0','0',1,NULL,NULL,NULL,NULL,0),(5,'A5',1,NULL,'5.83','8.27',0.00000000,'0','0',1,NULL,NULL,NULL,NULL,0),(6,'A6',1,NULL,'4.13','5.83',0.00000000,'0','0',1,NULL,NULL,NULL,NULL,0),(7,'A7',1,NULL,'2.91','4.13',0.00000000,'0','0',1,NULL,NULL,NULL,NULL,0),(8,'A8',1,NULL,'2.05','2.91',0.00000000,'0','0',1,NULL,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `print_areas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `print_profile_allowed_formats`
--

DROP TABLE IF EXISTS `print_profile_allowed_formats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `print_profile_allowed_formats` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` char(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'image',
  `is_disabled` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `print_profile_allowed_formats`
--

LOCK TABLES `print_profile_allowed_formats` WRITE;
/*!40000 ALTER TABLE `print_profile_allowed_formats` DISABLE KEYS */;
INSERT INTO `print_profile_allowed_formats` VALUES (1,'svg','image',0),(2,'jpeg','image',0),(3,'jpg','image',0),(4,'png','image',0),(5,'gif','image',0),(6,'bmp','image',0),(7,'pdf','image',0),(8,'ai','image',0),(9,'psd','image',0),(10,'eps','image',0),(11,'cdr','image',0),(12,'dxf','image',0),(13,'tif','image',0),(14,'pdf','order',0),(15,'png','order',0),(16,'svg','order',0);
/*!40000 ALTER TABLE `print_profile_allowed_formats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `print_profile_assets_category_rel`
--

DROP TABLE IF EXISTS `print_profile_assets_category_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `print_profile_assets_category_rel` (
  `print_profile_id` int(11) NOT NULL,
  `asset_type_id` int(11) NOT NULL,
  `category_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `print_profile_assets_category_rel`
--

LOCK TABLES `print_profile_assets_category_rel` WRITE;
/*!40000 ALTER TABLE `print_profile_assets_category_rel` DISABLE KEYS */;
INSERT INTO `print_profile_assets_category_rel` VALUES (2,1,'19'),(2,2,'57'),(2,2,'58'),(2,2,'59'),(2,2,'61'),(2,3,'28'),(2,3,'29'),(2,3,'30'),(2,3,'31'),(2,3,'32'),(2,3,'38'),(2,3,'40'),(2,3,'63'),(2,3,'64'),(2,6,'66'),(2,6,'67'),(2,9,'20'),(2,11,'46'),(1,1,'19'),(1,2,'57'),(1,2,'58'),(1,2,'59'),(1,2,'60'),(1,3,'28'),(1,3,'29'),(1,3,'30'),(1,3,'31'),(1,3,'32'),(1,3,'33'),(1,3,'37'),(1,3,'38'),(1,3,'40'),(1,3,'63'),(1,3,'64'),(1,6,'66'),(1,6,'67'),(1,9,'20'),(1,11,'46'),(1,3,'1'),(1,3,'2'),(1,3,'3'),(1,3,'4'),(1,3,'5'),(2,3,'1'),(2,3,'2'),(2,3,'3'),(2,3,'4'),(2,3,'5');
/*!40000 ALTER TABLE `print_profile_assets_category_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `print_profile_attribute_rel`
--

DROP TABLE IF EXISTS `print_profile_attribute_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `print_profile_attribute_rel` (
  `attribute_term_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tier_range_id` int(11) DEFAULT NULL,
  `print_profile_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `print_profile_attribute_rel`
--

LOCK TABLES `print_profile_attribute_rel` WRITE;
/*!40000 ALTER TABLE `print_profile_attribute_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `print_profile_attribute_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `print_profile_decoration_setting_rel`
--

DROP TABLE IF EXISTS `print_profile_decoration_setting_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `print_profile_decoration_setting_rel` (
  `print_profile_id` int(11) NOT NULL,
  `decoration_setting_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `print_profile_decoration_setting_rel`
--

LOCK TABLES `print_profile_decoration_setting_rel` WRITE;
/*!40000 ALTER TABLE `print_profile_decoration_setting_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `print_profile_decoration_setting_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `print_profile_engrave_settings`
--

DROP TABLE IF EXISTS `print_profile_engrave_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `print_profile_engrave_settings` (
  `print_profile_id` int(11) NOT NULL,
  `engraved_surface_id` int(11) DEFAULT '0',
  `is_engraved_surface` tinyint(1) DEFAULT '0',
  `is_auto_convert` tinyint(1) DEFAULT '0',
  `is_hide_color_options` tinyint(1) DEFAULT '0',
  `auto_convert_type` enum('BW','Grayscale') COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_engrave_image` tinyint(1) DEFAULT '0',
  `is_engrave_preview_image` tinyint(1) DEFAULT '0',
  `is_BWGray_enabled` tinyint(1) DEFAULT '0',
  `is_black_white` tinyint(1) DEFAULT '0',
  `is_gary_scale` tinyint(1) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `print_profile_engrave_settings`
--

LOCK TABLES `print_profile_engrave_settings` WRITE;
/*!40000 ALTER TABLE `print_profile_engrave_settings` DISABLE KEYS */;
INSERT INTO `print_profile_engrave_settings` VALUES (1,1,0,0,0,'BW',0,0,0,0,0),(2,1,0,0,0,'BW',0,0,0,0,0);
/*!40000 ALTER TABLE `print_profile_engrave_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `print_profile_feature_rel`
--

DROP TABLE IF EXISTS `print_profile_feature_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `print_profile_feature_rel` (
  `print_profile_id` int(11) NOT NULL,
  `feature_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `print_profile_feature_rel`
--

LOCK TABLES `print_profile_feature_rel` WRITE;
/*!40000 ALTER TABLE `print_profile_feature_rel` DISABLE KEYS */;
INSERT INTO `print_profile_feature_rel` VALUES (1,1),(1,2),(1,3),(1,4),(1,5),(1,6),(1,7),(1,9),(1,10),(2,1),(2,2),(2,3),(2,5),(2,6),(2,7);
/*!40000 ALTER TABLE `print_profile_feature_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `print_profile_pricings`
--

DROP TABLE IF EXISTS `print_profile_pricings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `print_profile_pricings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `print_profile_id` int(11) NOT NULL,
  `is_white_base` tinyint(1) NOT NULL DEFAULT '0',
  `white_base_type` enum('DLW','DL','') COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_setup_price` tinyint(1) NOT NULL,
  `setup_price` decimal(20,8) DEFAULT NULL,
  `setup_type_product` enum('per_product','per_product_side') COLLATE utf8_unicode_ci DEFAULT NULL,
  `setup_type_order` enum('single_order','multiple_order') COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `print_profile_pricings`
--

LOCK TABLES `print_profile_pricings` WRITE;
/*!40000 ALTER TABLE `print_profile_pricings` DISABLE KEYS */;
/*!40000 ALTER TABLE `print_profile_pricings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `print_profile_product_setting_rel`
--

DROP TABLE IF EXISTS `print_profile_product_setting_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `print_profile_product_setting_rel` (
  `print_profile_id` int(11) NOT NULL,
  `product_setting_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `print_profile_product_setting_rel`
--

LOCK TABLES `print_profile_product_setting_rel` WRITE;
/*!40000 ALTER TABLE `print_profile_product_setting_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `print_profile_product_setting_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `print_profiles`
--

DROP TABLE IF EXISTS `print_profiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `print_profiles` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `file_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `status` tinyint(1) DEFAULT '0',
  `is_vdp_enabled` tinyint(1) DEFAULT '0',
  `vdp_data` mediumtext COLLATE utf8_unicode_ci,
  `is_laser_engrave_enabled` tinyint(1) DEFAULT '0',
  `image_settings` mediumtext COLLATE utf8_unicode_ci,
  `color_settings` mediumtext COLLATE utf8_unicode_ci,
  `order_settings` mediumtext COLLATE utf8_unicode_ci,
  `embroidery_settings` mediumtext COLLATE utf8_unicode_ci,
  `text_settings` mediumtext COLLATE utf8_unicode_ci,
  `misc_settings` mediumtext COLLATE utf8_unicode_ci,
  `name_number_settings` mediumtext COLLATE utf8_unicode_ci,
  `ar_settings` mediumtext COLLATE utf8_unicode_ci,
  `is_price_setting` tinyint(1) DEFAULT '0',
  `is_product_setting` tinyint(1) DEFAULT '0',
  `is_assets_setting` tinyint(1) DEFAULT '0',
  `allow_full_color` tinyint(1) DEFAULT '0',
  `is_disabled` tinyint(1) DEFAULT '0',
  `is_draft` tinyint(1) DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `sticker_settings` mediumtext COLLATE utf8_unicode_ci,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  `is_category_assigned` tinyint(1) DEFAULT '1',
  `template_settings` mediumtext COLLATE utf8_unicode_ci,
  `user_design_settings` mediumtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `print_profiles`
--

LOCK TABLES `print_profiles` WRITE;
/*!40000 ALTER TABLE `print_profiles` DISABLE KEYS */;
INSERT INTO `print_profiles` VALUES (1,1,'DTG','202003060207555090.png','Unlimited color spectrum.\nNo minimum order quantity.\nRealistic print quality.',0,1,'0',0,'{\"allowed_image_format\":[1,2,3,4],\"image_processing_type\":\"quick\",\"is_auto_convert_image\":0,\"is_more_color_options\":1,\"color_option_value\":8,\"is_white_removal\":1,\"image_effects\":{\"is_image_mask\":1,\"is_image_filter\":1},\"show_color_option\":{\"grey_scale\":1,\"one_color\":1,\"bw\":1,\"monochrome\":1},\"auto_convert_image_type\":\"\"}','{\"show_color_picker\":1,\"fill_color_code\":\"#000000\",\"border_color_code\":\"#000000\",\"max_colors_allowed\":9,\"is_max_color_allowed\":0}','{\"min_order_qty\":1,\"is_include_product_image\":\"exclude\",\"is_horizontally_flip\":0,\"is_color_separation_enabled\":0,\"is_min_order_qty\":0,\"allowed_order_format\":[14,15,16],\"is_invert_color_enabled\":0,\"is_bleed_mark_enabled\":0,\"bleed_mark\":{\"crop_mark\":0,\"cut_mark\":0}}','{\"is_embroidery_enabled\":0}','{\"do_user_upload_fonts\":1,\"is_text_stroke\":1,\"is_multiline_text\":1,\"do_show_graphic_fonts\":1}','{\"allow_user_uplaod_bg\":1,\"clipart_options\":\"add\",\"template_options\":\"replace\",\"shape_options\":\"add\"}',NULL,'{\"is_ar_enabled\":1,\"height\":3,\"width\":3}',0,0,0,0,0,1,'2020-03-06 19:37:55',NULL,0,1,NULL,NULL),(2,1,'Screen print','202003060244143853.png','Transfer any artwork on the products.\nNo minimum quantities.\nUnlimited color spectrum.',0,0,'0',0,'{\"allowed_image_format\":[1,2,3,4],\"image_processing_type\":\"quick\",\"is_auto_convert_image\":0,\"is_more_color_options\":1,\"color_option_value\":8,\"is_white_removal\":1,\"image_effects\":{\"is_image_mask\":1,\"is_image_filter\":1},\"show_color_option\":{\"grey_scale\":1,\"one_color\":1,\"bw\":1,\"monochrome\":1},\"auto_convert_image_type\":\"\"}','{\"show_color_picker\":1,\"fill_color_code\":\"#000000\",\"border_color_code\":\"#000000\",\"max_colors_allowed\":9,\"is_max_color_allowed\":0}','{\"min_order_qty\":1,\"is_include_product_image\":\"exclude\",\"is_horizontally_flip\":0,\"is_color_separation_enabled\":0,\"is_min_order_qty\":0,\"allowed_order_format\":[14,15,16],\"is_invert_color_enabled\":0,\"is_bleed_mark_enabled\":0,\"bleed_mark\":{\"crop_mark\":0,\"cut_mark\":0}}','{\"is_embroidery_enabled\":0}','{\"do_user_upload_fonts\":1,\"is_text_stroke\":1,\"is_multiline_text\":1,\"do_show_graphic_fonts\":1}','{\"allow_user_uplaod_bg\":1,\"clipart_options\":\"add\",\"template_options\":\"replace\",\"shape_options\":\"add\"}',NULL,'{\"is_ar_enabled\":1,\"height\":3,\"width\":3}',0,0,0,0,0,1,'2020-03-06 20:14:14',NULL,0,1,NULL,NULL);
/*!40000 ALTER TABLE `print_profiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `privileges_sub_modules`
--

DROP TABLE IF EXISTS `privileges_sub_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `privileges_sub_modules` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_privilege_id` int(10) NOT NULL,
  `type` varchar(255) NOT NULL COMMENT 'Operator, Agent',
  `slug` varchar(255) NOT NULL,
  `comments` text,
  `is_default` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `privileges_sub_modules`
--

LOCK TABLES `privileges_sub_modules` WRITE;
/*!40000 ALTER TABLE `privileges_sub_modules` DISABLE KEYS */;
INSERT INTO `privileges_sub_modules` VALUES (1,7,'Manage customers','manage_customer',NULL,1),(2,7,'Send promotional emails','send_promotional_emails',NULL,1),(3,8,'Manage quotation','manage_quotation',NULL,1),(4,8,'Re-assign option','reassign_option',NULL,1),(5,9,'Manage vendors','manage_vendors',NULL,1),(6,9,'Manage PO','manage_po',NULL,1),(7,11,'Change due date','change_due_date',NULL,1),(8,11,'Mark as done','mark_as_done',NULL,1),(9,1,'Import catalog','import_catalog',NULL,1),(10,1,'Create decorated product','create_decorated_product',NULL,1),(11,1,'Decoration Settings','product_decoration_settings',NULL,1),(12,2,'Clipart','clipart',NULL,1),(13,2,'Backgrounds','background',NULL,1),(14,2,'Shapes','shapes',NULL,1),(15,2,'Printable colors','colors',NULL,1),(16,2,'Fonts','fonts',NULL,1),(17,2,'Graphic font','graphic-font',NULL,1),(18,2,'Image masks','image-mask',NULL,1),(19,2,'Templates','template',NULL,1),(21,4,'Template on products','template-on-products',NULL,1),(22,4,'Appearance','appearance',NULL,1),(23,4,'Image','image',NULL,1),(24,4,'Store','store',NULL,1),(25,4,'Cart','cart',NULL,1),(26,4,'Order','orders',NULL,1),(27,4,'Language','language',NULL,1),(28,4,'General','general',NULL,1),(29,10,'Show Price','order_show_price',NULL,1),(30,11,'Show Price','production_show_price',NULL,1),(31,4,'Integration','integration',NULL,1),(32,7,'Customer group','customer_group',NULL,1),(33,8,'Quotation settings','quotation_settings',NULL,1),(34,9,'Purchase order settings','po_settings',NULL,1),(35,11,'Production settings','production_settings',NULL,1),(36,2,'Distress','distress',NULL,1),(37,2,'Configurator Patterns','configurator-pattern',NULL,1);
/*!40000 ALTER TABLE `privileges_sub_modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `privileges_sub_modules_rel`
--

DROP TABLE IF EXISTS `privileges_sub_modules_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `privileges_sub_modules_rel` (
  `privilege_rel_id` int(11) NOT NULL,
  `privileges_sub_module_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `privileges_sub_modules_rel`
--

LOCK TABLES `privileges_sub_modules_rel` WRITE;
/*!40000 ALTER TABLE `privileges_sub_modules_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `privileges_sub_modules_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_category_settings_rel`
--

DROP TABLE IF EXISTS `product_category_settings_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_category_settings_rel` (
  `product_setting_id` int(11) NOT NULL,
  `product_category_id` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `is_3d_preview` tinyint(1) NOT NULL DEFAULT '0',
  `is_product_image` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_category_settings_rel`
--

LOCK TABLES `product_category_settings_rel` WRITE;
/*!40000 ALTER TABLE `product_category_settings_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_category_settings_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_configurator`
--

DROP TABLE IF EXISTS `product_configurator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_configurator` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price` decimal(20,8) DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_configurator`
--

LOCK TABLES `product_configurator` WRITE;
/*!40000 ALTER TABLE `product_configurator` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_configurator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_configurator_sides`
--

DROP TABLE IF EXISTS `product_configurator_sides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_configurator_sides` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `section_id` bigint(20) DEFAULT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `side_path_obj` text COLLATE utf8_unicode_ci,
  `preview_file` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `svg_file` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_configurator_sides`
--

LOCK TABLES `product_configurator_sides` WRITE;
/*!40000 ALTER TABLE `product_configurator_sides` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_configurator_sides` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_decoration_settings`
--

DROP TABLE IF EXISTS `product_decoration_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_decoration_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_setting_id` int(11) NOT NULL,
  `product_side_id` int(11) DEFAULT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dimension` mediumtext COLLATE utf8_unicode_ci,
  `print_area_id` bigint(20) NOT NULL,
  `sub_print_area_type` enum('normal_size','custom_size','associate_size_variant') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'normal_size',
  `pre_defined_dimensions` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_defined_dimensions` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_min_height` float(5,2) DEFAULT NULL,
  `custom_max_height` float(5,2) DEFAULT NULL,
  `custom_min_width` float(5,2) DEFAULT NULL,
  `custom_max_width` float(5,2) DEFAULT NULL,
  `custom_bound_price` float(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Price per square unit',
  `is_border_enable` tinyint(1) NOT NULL DEFAULT '0',
  `is_sides_allow` tinyint(1) NOT NULL DEFAULT '0',
  `no_of_sides` int(11) NOT NULL DEFAULT '0',
  `is_dimension_enable` tinyint(1) NOT NULL DEFAULT '0',
  `locations` mediumtext COLLATE utf8_unicode_ci,
  `bleed_mark_data` text COLLATE utf8_unicode_ci,
  `shape_mark_data` longtext COLLATE utf8_unicode_ci,
  `image_overlay` tinyint(1) NOT NULL DEFAULT '0',
  `multiply_overlay` tinyint(1) NOT NULL DEFAULT '0',
  `overlay_file_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_disable_design` tinyint(1) NOT NULL DEFAULT '0',
  `default_pp_id` int(11) DEFAULT '0' COMMENT 'Default Print Profile Id',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_decoration_settings`
--

LOCK TABLES `product_decoration_settings` WRITE;
/*!40000 ALTER TABLE `product_decoration_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_decoration_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_image_settings_rel`
--

DROP TABLE IF EXISTS `product_image_settings_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_image_settings_rel` (
  `product_setting_id` int(11) NOT NULL,
  `product_image_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_image_settings_rel`
--

LOCK TABLES `product_image_settings_rel` WRITE;
/*!40000 ALTER TABLE `product_image_settings_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_image_settings_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_image_sides`
--

DROP TABLE IF EXISTS `product_image_sides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_image_sides` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_image_id` int(11) NOT NULL,
  `side_name` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort_order` int(11) NOT NULL,
  `file_name` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_image_sides`
--

LOCK TABLES `product_image_sides` WRITE;
/*!40000 ALTER TABLE `product_image_sides` DISABLE KEYS */;
INSERT INTO `product_image_sides` VALUES (1,1,'front',1,'20200401114920544.png'),(2,1,'back',2,'202004011149206852.png'),(3,1,'left',3,'202004011149205955.png'),(4,1,'right',4,'202004011149201730.png');
/*!40000 ALTER TABLE `product_image_sides` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_images`
--

DROP TABLE IF EXISTS `product_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_images` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `is_disable` tinyint(1) DEFAULT '0',
  `store_id` int(4) DEFAULT NULL,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  `is_catalog` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_images`
--

LOCK TABLES `product_images` WRITE;
/*!40000 ALTER TABLE `product_images` DISABLE KEYS */;
INSERT INTO `product_images` VALUES (1,'tshirt',0,1,0,0);
/*!40000 ALTER TABLE `product_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_option_rel`
--

DROP TABLE IF EXISTS `product_option_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_option_rel` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `option_id` int(11) NOT NULL,
  `option_values` longtext COLLATE utf8_unicode_ci,
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'sort position',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_option_rel`
--

LOCK TABLES `product_option_rel` WRITE;
/*!40000 ALTER TABLE `product_option_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_option_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_option_setting_rel`
--

DROP TABLE IF EXISTS `product_option_setting_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_option_setting_rel` (
  `product_id` varchar(50) NOT NULL,
  `option_id` varchar(50) NOT NULL,
  `option_value` varchar(50) NOT NULL,
  `product_setting_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_option_setting_rel`
--

LOCK TABLES `product_option_setting_rel` WRITE;
/*!40000 ALTER TABLE `product_option_setting_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_option_setting_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_options`
--

DROP TABLE IF EXISTS `product_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_options` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_options`
--

LOCK TABLES `product_options` WRITE;
/*!40000 ALTER TABLE `product_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_overlogo_decoration_settings`
--

DROP TABLE IF EXISTS `product_overlogo_decoration_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_overlogo_decoration_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_setting_id` int(11) NOT NULL,
  `product_side_id` int(11) DEFAULT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `surface` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `path` mediumtext COLLATE utf8_unicode_ci,
  `print_size` mediumtext COLLATE utf8_unicode_ci,
  `logo_position` mediumtext COLLATE utf8_unicode_ci,
  `height` int(6) DEFAULT NULL,
  `width` int(6) DEFAULT NULL,
  `print_area_id` bigint(20) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_overlogo_decoration_settings`
--

LOCK TABLES `product_overlogo_decoration_settings` WRITE;
/*!40000 ALTER TABLE `product_overlogo_decoration_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_overlogo_decoration_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_overlogo_settings`
--

DROP TABLE IF EXISTS `product_overlogo_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_overlogo_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `store_id` int(11) DEFAULT NULL,
  `is_overlogo` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_overlogo_settings`
--

LOCK TABLES `product_overlogo_settings` WRITE;
/*!40000 ALTER TABLE `product_overlogo_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_overlogo_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_overlogo_sides`
--

DROP TABLE IF EXISTS `product_overlogo_sides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_overlogo_sides` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_setting_id` int(11) NOT NULL,
  `side_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `is_visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_overlogo_sides`
--

LOCK TABLES `product_overlogo_sides` WRITE;
/*!40000 ALTER TABLE `product_overlogo_sides` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_overlogo_sides` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_section_images`
--

DROP TABLE IF EXISTS `product_section_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_section_images` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `section_id` bigint(20) DEFAULT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `thumb_value` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price` decimal(20,8) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_disable` tinyint(1) DEFAULT '0',
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_section_images`
--

LOCK TABLES `product_section_images` WRITE;
/*!40000 ALTER TABLE `product_section_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_section_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_sections`
--

DROP TABLE IF EXISTS `product_sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_sections` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `sort_order` bigint(20) DEFAULT NULL,
  `is_disable` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_sections`
--

LOCK TABLES `product_sections` WRITE;
/*!40000 ALTER TABLE `product_sections` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_sections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_settings`
--

DROP TABLE IF EXISTS `product_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `store_id` int(4) DEFAULT NULL,
  `is_variable_decoration` tinyint(1) DEFAULT '0',
  `is_ruler` tinyint(1) DEFAULT '0',
  `is_crop_mark` tinyint(1) NOT NULL DEFAULT '0',
  `is_safe_zone` tinyint(1) NOT NULL DEFAULT '0',
  `crop_value` float NOT NULL,
  `safe_value` float NOT NULL,
  `is_3d_preview` tinyint(1) NOT NULL DEFAULT '0',
  `3d_object_file` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `3d_object` mediumtext COLLATE utf8_unicode_ci,
  `is_configurator` tinyint(1) DEFAULT '0',
  `scale_unit_id` int(11) NOT NULL,
  `is_custom_size` tinyint(1) DEFAULT '0',
  `decoration_type` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `decoration_dimensions` mediumtext COLLATE utf8_unicode_ci,
  `custom_size_unit_price` decimal(20,8) DEFAULT NULL,
  `is_svg_configurator` tinyint(1) NOT NULL DEFAULT '0',
  `custom_size` text COLLATE utf8_unicode_ci,
  `is_increment` tinyint(1) NOT NULL DEFAULT '0',
  `increment_values` text COLLATE utf8_unicode_ci,
  `dnt_inventory` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=track inventory, 1=do not track inventory',
  `custom_variant` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=store, 1=custom',
  `is_applied_color` tinyint(1) NOT NULL DEFAULT '0',
  `is_prod_desc` longtext COLLATE utf8_unicode_ci,
  `is_prod_rotate` tinyint(1) NOT NULL DEFAULT '0',
  `is_use_full_width` tinyint(1) NOT NULL DEFAULT '0',
  `is_applied_pattern` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_settings`
--

LOCK TABLES `product_settings` WRITE;
/*!40000 ALTER TABLE `product_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_settings_rel`
--

DROP TABLE IF EXISTS `product_settings_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_settings_rel` (
  `product_setting_id` int(11) NOT NULL,
  `product_id` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `is_3d_preview` tinyint(1) NOT NULL DEFAULT '0',
  `is_product_image` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_settings_rel`
--

LOCK TABLES `product_settings_rel` WRITE;
/*!40000 ALTER TABLE `product_settings_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_settings_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_sides`
--

DROP TABLE IF EXISTS `product_sides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_sides` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_setting_id` int(11) NOT NULL,
  `side_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `side_index` int(11) DEFAULT NULL,
  `product_image_dimension` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `is_visible` tinyint(1) NOT NULL DEFAULT '1',
  `product_image_side_id` int(11) DEFAULT NULL,
  `image_overlay` tinyint(1) DEFAULT '0',
  `multiply_overlay` tinyint(1) DEFAULT '0',
  `overlay_file_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_sides`
--

LOCK TABLES `product_sides` WRITE;
/*!40000 ALTER TABLE `product_sides` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_sides` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_size_variant_decoration_settings`
--

DROP TABLE IF EXISTS `product_size_variant_decoration_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_size_variant_decoration_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `decoration_setting_id` int(11) NOT NULL,
  `print_area_id` bigint(20) DEFAULT NULL,
  `size_variant_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_size_variant_decoration_settings`
--

LOCK TABLES `product_size_variant_decoration_settings` WRITE;
/*!40000 ALTER TABLE `product_size_variant_decoration_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_size_variant_decoration_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_variant_rel`
--

DROP TABLE IF EXISTS `product_variant_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variant_rel` (
  `variant_id` int(11) NOT NULL,
  `product_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_variant_rel`
--

LOCK TABLES `product_variant_rel` WRITE;
/*!40000 ALTER TABLE `product_variant_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_variant_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_variants`
--

DROP TABLE IF EXISTS `product_variants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variants` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text COLLATE utf8_unicode_ci,
  `price` decimal(10,2) NOT NULL,
  `sku` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `image_id` int(11) DEFAULT NULL,
  `barcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inventory` int(11) NOT NULL,
  `weight` decimal(10,2) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_variants`
--

LOCK TABLES `product_variants` WRITE;
/*!40000 ALTER TABLE `product_variants` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_variants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_email_templates`
--

DROP TABLE IF EXISTS `production_email_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_email_templates` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `template_type_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `message` mediumtext COLLATE utf8_unicode_ci,
  `is_configured` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '0-Configured, 1-Not Configured',
  `template_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_email_templates`
--

LOCK TABLES `production_email_templates` WRITE;
/*!40000 ALTER TABLE `production_email_templates` DISABLE KEYS */;
INSERT INTO `production_email_templates` VALUES (1,1,1,'quote_sent','Quotation request placed successfully','<div>Hi {customer_name}</div><div><br></div><div>We have received the quotation request for your order with quotation reference number {quote_id}. You can click on the link below to see the status of your quotation.</div><div><br></div><div>{public_url}</div><div><br></div><div>We will look into your quotation request and get back to you at the earliest.</div>','1',NULL),(2,1,1,'quote_approval','Quotation request Approved','<div>We are glad to inform you that your quotation with reference number {quote_id} has been approved.<br></div><div><br></div><div>You can click on the link below to see the status of your quotation.</div><div><br></div><div>{public_url}</div><div><br></div><div>Thank you for shopping with us.</div>','1',NULL),(3,1,1,'quote_reject','Quotation request Declined','<div>Hi {customer_name}</div><div><br></div><div>We would like to inform you that your quotation with reference number {quote_id} has been declined. We value your time and effort for reaching out to us for a quotation. We are looking forward to provide a better deal to you in the near future.<br></div><div><br></div><div>You can click on the link below to see the status of your quotation.</div><div><br></div><div>{public_url}</div><div><br></div><div>Thank you for shopping with us.</div>','1',NULL),(4,1,1,'convert_to_order','Order Received','<div>Hi {customer_name}</div><div><br></div><div>Your quotation request with reference number {quote_id} has been recieved as order at our production site. The order is expected to be delivered to you by {delivery_date}.<br></div><div><br></div><div>You can click on the link below to see the status of your quotation.</div><div><br></div><div>{public_url}</div><div><br></div><div>Thank you for shopping with us.</div>','1',NULL),(5,1,1,'request_payment','Payment is pending','<div>Hi {customer_name}</div><div><br></div><div>Your quotation request with reference number {quote_id} has been approved and we are expecting the payment of {request_payment_amount} towards it. The order request will be sent to production after acknowledgement of the successful payment.<br></div><div><br></div><div>You can click on the link below to see the status of your quotation.</div><div><br></div><div>{public_url}</div><div><br></div><div>Thank you for shopping with us.</div>','1',NULL),(6,1,1,'receive_payment','Payment is Received','<div>Hi {customer_name}</div><div><br></div><div>We have receieved a payment of {payment_amount} towards your quotation request with reference number {quote_id}. You will be notified soon once the order is placed with the requested items.</div><div><br></div><div>You can click on the link below to see the status of your quotation.</div><div><br></div><div>{public_url}</div><div><br></div><div>Thank you for shopping with us.</div>','1',NULL),(7,1,1,'bulk_resend_quotation','Quotation request placed successfully','<div>Hi</div><div><br></div><div>We have received the quotation request for your order with quotation reference number {quote_id}. You can click on the link below to see the status of your quotation.</div><div><br></div><div>{public_url}</div><div><br></div><div>We will look into your quotation request and get back to you at the earliest.</div>','1',NULL),(8,1,1,'bulk_quotation_approval','Quotation request Approved','<div>Hi</div><div><br></div><div>We are glad to inform you that your quotation with reference number {quote_id} has been approved.<br></div><div><br></div><div>You can click on the link below to see the status of your quotation.</div><div><br></div><div>{public_url}</div><div><br></div><div>Thank you for shopping with us.</div>','1',NULL),(9,1,1,'bulk_payment_reminder','Payment is pending','<div>Hi</div><div><br></div><div>Your quotation request with reference number {quote_id} has been approved and we are expecting the payment of {request_payment_amount} towards it. The order request will be sent to production after acknowledgement of the successful payment.<br></div><div><br></div><div>You can click on the link below to see the status of your quotation.</div><div><br></div><div>{public_url}</div><div><br></div><div>Thank you for shopping with us.</div>','1',NULL),(10,1,2,'order_email_send','Artwork files for Order {order_id}  {customer_name}','<div><div>Hello</div></div><div>Please find the details of the customer below.<br>Customer name {customer_name}</div><div>Customer email  {customer_email}</div><div>Customer address {customer_address}<br>Order Status  {order_status}</div><div>Order Created Date {order_created_date}</div><div>Order Artwork Status {artwork_status}</div><div>Order Total  {order_value}</div><div>Payment Type  {payment_type}</div><div>Order Notes {order_notes}</div><div>Product Name {product_name}</div><div>Customer Mobile No {mobile_no}</div><div>Also find the artwork files for this order {order_id} in the attachment.</div><div><br></div><div><br></div><div><b>Thanks</b><br><b><i>ImprintNext</i></b></div>','1',NULL),(11,1,6,'promotional_email','Hi {customer_name}','<div>Hello {customer_name}</div><div><br></div><div><span>Please find the below details</span><span>.</span><br></div><div>Customer email {customer_email}<span><br></span></div><div>Your Last Order {last_order}</div><div>Address {customer_address}</div><div>Register Date {signup_date}</div><div><br></div><div><br></div><div><b>Thanks</b><br><i><b>ImprintNext</b></i><br></div>','1',NULL),(12,1,4,'start_printing','Updates on your order id #{order_id}','<span>Hi {customer_name},<br><br>We are happy to inform you that the printing of the item {item_name} for order id# {order_id} is completed.You will be notified further on your order related updates.<br><br>Thank you.</span><br>','0',NULL),(13,1,4,'shipping','Updates on your order id #{order_id}','<span>Hi {customer_name},<br><br>We are happy to inform you that the shipping of the item {item_name} for order id# {order_id} is completed.You will be notified with the shipping details very soon.<br><br>Thank you.</span><br>','0',NULL),(14,1,3,'send_po','Purchase Order','<span>Hello {contact_name},</span><br><br><span>A purchase odrder ID#: {order_id} is created. Please check the attached PDF for the purchase order details.</span><br><br><span>Thanks</span>','1',NULL),(15,1,7,'request_a_quote','Quotation request submitted','<span>Hello,<br><br>A quotation is requested by {customer_name} (email: {customer_email}) on {requested_date}.</span><br><br><div><b>Quotation request information:</b> {form_data}</div><br><div><b>Product information:</b> {product_data}<br><div><span><br>Thank you.</span><br></div></div>','1',NULL);
/*!40000 ALTER TABLE `production_email_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_hub_modules`
--

DROP TABLE IF EXISTS `production_hub_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_hub_modules` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_hub_modules`
--

LOCK TABLES `production_hub_modules` WRITE;
/*!40000 ALTER TABLE `production_hub_modules` DISABLE KEYS */;
INSERT INTO `production_hub_modules` VALUES (1,'Quotation'),(2,'Order'),(3,'Purchase Order'),(4,'Production'),(5,'Email Setting'),(6,'Customer'),(7,'Request Quote');
/*!40000 ALTER TABLE `production_hub_modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_hub_settings`
--

DROP TABLE IF EXISTS `production_hub_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_hub_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `module_id` int(4) NOT NULL,
  `setting_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `setting_value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `flag` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT 'Represent value is changed or not',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_hub_settings`
--

LOCK TABLES `production_hub_settings` WRITE;
/*!40000 ALTER TABLE `production_hub_settings` DISABLE KEYS */;
INSERT INTO `production_hub_settings` VALUES (1,1,1,'is_quote_id_enable','true','0'),(2,1,1,'quote_id','{\"prefix\":\"IM\",\"starting_number\":1,\"postfix\":\"NXT\"}','0'),(3,1,1,'is_tags_enabled','true','0'),(4,1,1,'is_artwork_approval_enable','true','0'),(5,1,1,'is_rush_order_enable','false','0'),(6,1,1,'is_resend_quotation_mail','true','0'),(7,1,1,'is_quote_app_reminder','true','0'),(8,1,1,'is_minimum_payment','true','0'),(9,1,1,'minimum_payment_percent','10','0'),(10,1,1,'is_payment_reminder','true','0'),(11,1,1,'sender_email','','0'),(12,1,1,'company_name','','0'),(13,1,1,'color_code','','0'),(14,1,1,'phone_number','','0'),(15,1,1,'city','','0'),(16,1,1,'state','','0'),(17,1,1,'state_id','','0'),(18,1,1,'country','','0'),(19,1,1,'country_id','','0'),(20,1,1,'zip_code','','0'),(21,1,1,'address','','0'),(22,1,1,'company_logo','','0'),(23,1,4,'is_production','true','0'),(24,1,4,'job_card','{\"prefix\":\"IM\",\"starting_number\":1,\"postfix\":\"NXT\"}','0'),(25,1,4,'is_communication_enabled','true','0'),(26,1,4,'is_automatic_job_creation','false','0'),(27,1,4,'mandatory_purchase_order','false','0'),(28,1,4,'mark_as_done','true','0'),(29,1,3,'synchronize_with_store','true','0'),(30,1,3,'purchase_order_id','{\"prefix\":\"PO\",\"starting_number\":4448,\"postfix\":\"XE\"}','0'),(31,1,3,'convert_order','{\"is_enabled\":true,\"conversion_days\":7,\"is_order_qty_exception_enabled\":true,\"order_qty\":1,\"is_rush_order_exception_enabled\":false}','0'),(32,1,3,'last_po_date','{\"date\":\"\"}','0'),(33,1,4,'time_format','24','0'),(34,1,4,'working_hours','{\"starts_at\":\"10:30\",\"ends_at\":\"19:30\"}','0'),(35,1,4,'weekends','[\"sat\"]','0'),(36,1,4,'is_barcode_enable','false','0'),(37,1,1,'is_add_multiple_line_item','false','0'),(38,1,1,'is_shipping_cost_enable','true','0'),(39,1,1,'is_tax_enable','true','0'),(40,1,1,'shipping_methods','[{\"shipping_name\":\"Free\",\"shipping_price\":\"0\"},{\"shipping_name\":\"Regular\",\"shipping_price\":\"50\"},{\"shipping_name\":\"Express\",\"shipping_price\":\"100\"}]','0'),(41,1,1,'tax_percent','[\"5\",\"7\"]','0'),(42,1,1,'is_show_dashboard_quotes','false','0');
/*!40000 ALTER TABLE `production_hub_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_job_agents`
--

DROP TABLE IF EXISTS `production_job_agents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_job_agents` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `job_id` int(11) NOT NULL,
  `job_stage_id` int(11) NOT NULL,
  `is_group` tinyint(1) NOT NULL,
  `agent_id` int(11) NOT NULL,
  PRIMARY KEY (`xe_id`),
  KEY `production_job_agents_index_key_01` (`job_id`,`job_stage_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_job_agents`
--

LOCK TABLES `production_job_agents` WRITE;
/*!40000 ALTER TABLE `production_job_agents` DISABLE KEYS */;
/*!40000 ALTER TABLE `production_job_agents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_job_holidays`
--

DROP TABLE IF EXISTS `production_job_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_job_holidays` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `holiday_name` varchar(255) DEFAULT NULL,
  `day` varchar(50) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_job_holidays`
--

LOCK TABLES `production_job_holidays` WRITE;
/*!40000 ALTER TABLE `production_job_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `production_job_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_job_log`
--

DROP TABLE IF EXISTS `production_job_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_job_log` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `job_id` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `user_type` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'admin, customer, agent, operator',
  `user_id` int(11) NOT NULL,
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`xe_id`),
  KEY `production_job_log_index_key_01` (`job_id`,`created_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_job_log`
--

LOCK TABLES `production_job_log` WRITE;
/*!40000 ALTER TABLE `production_job_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `production_job_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_job_note_files`
--

DROP TABLE IF EXISTS `production_job_note_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_job_note_files` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `note_id` int(11) NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_job_note_files`
--

LOCK TABLES `production_job_note_files` WRITE;
/*!40000 ALTER TABLE `production_job_note_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `production_job_note_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_job_notes`
--

DROP TABLE IF EXISTS `production_job_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_job_notes` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `job_id` int(11) NOT NULL,
  `note` text COLLATE utf8_unicode_ci NOT NULL,
  `user_type` enum('admin','agent') COLLATE utf8_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `seen_flag` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`xe_id`),
  KEY `production_job_notes_index_key_01` (`job_id`,`created_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_job_notes`
--

LOCK TABLES `production_job_notes` WRITE;
/*!40000 ALTER TABLE `production_job_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `production_job_notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_job_stages`
--

DROP TABLE IF EXISTS `production_job_stages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_job_stages` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `job_id` int(11) NOT NULL,
  `print_method_id` int(11) NOT NULL,
  `stages_id` int(11) NOT NULL,
  `stage_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `stage_color_code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_date` datetime NOT NULL,
  `starting_date` datetime DEFAULT NULL,
  `exp_completion_date` datetime DEFAULT NULL,
  `completion_date` datetime DEFAULT NULL,
  `status` enum('not-started','in-progress','completed','delay') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'in-progress',
  `message` text COLLATE utf8_unicode_ci,
  `completed_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`xe_id`),
  KEY `production_job_stages_index_key_01` (`job_id`,`print_method_id`,`stages_id`,`exp_completion_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_job_stages`
--

LOCK TABLES `production_job_stages` WRITE;
/*!40000 ALTER TABLE `production_job_stages` DISABLE KEYS */;
/*!40000 ALTER TABLE `production_job_stages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_jobs`
--

DROP TABLE IF EXISTS `production_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_jobs` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `job_id` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `order_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `order_item_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `order_item_quantity` int(11) NOT NULL,
  `job_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `job_status` enum('not-started','progressing','completed','delay') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'not-started',
  `note` text COLLATE utf8_unicode_ci,
  `comp_percentage` int(4) NOT NULL DEFAULT '0',
  `due_date` datetime DEFAULT NULL,
  `scheduled_date` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `current_stage_id` int(11) NOT NULL,
  PRIMARY KEY (`xe_id`),
  KEY `production_jobs_index_key_01` (`job_id`,`order_id`,`job_title`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_jobs`
--

LOCK TABLES `production_jobs` WRITE;
/*!40000 ALTER TABLE `production_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `production_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_quickbooks_rel`
--

DROP TABLE IF EXISTS `production_quickbooks_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_quickbooks_rel` (
  `module_type` varchar(50) NOT NULL COMMENT 'quotation or customer or vendor etc',
  `imp_id` varchar(50) NOT NULL COMMENT 'quotation_id or customer_id etc generated in store',
  `quickbooks_id` varchar(30) NOT NULL COMMENT 'estimate_id or customer_id or vendor_id generated in Quickbooks'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_quickbooks_rel`
--

LOCK TABLES `production_quickbooks_rel` WRITE;
/*!40000 ALTER TABLE `production_quickbooks_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `production_quickbooks_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_status`
--

DROP TABLE IF EXISTS `production_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_status` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `status_name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `color_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `module_id` int(11) NOT NULL,
  `is_default` enum('0','1') COLLATE utf8_unicode_ci NOT NULL,
  `sort_order` int(4) NOT NULL,
  `status` enum('1','0') COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_status`
--

LOCK TABLES `production_status` WRITE;
/*!40000 ALTER TABLE `production_status` DISABLE KEYS */;
INSERT INTO `production_status` VALUES (1,1,'Open','#23e6dc',1,'1',1,'1','open'),(2,1,'Rejected','#f30d0d',1,'1',2,'1','rejected'),(3,1,'Sent','#49ce49',1,'1',3,'1','sent'),(4,1,'Approved','#e4d23d',1,'1',4,'1','approved'),(5,1,'Ordered','#8c23e6',1,'1',5,'1','ordered'),(6,1,'Start Printing','#49ce49',4,'1',1,'1','start_printing'),(7,1,'Shipping','#8c23e6',4,'1',2,'1','shipping');
/*!40000 ALTER TABLE `production_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_status_assignee_rel`
--

DROP TABLE IF EXISTS `production_status_assignee_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_status_assignee_rel` (
  `status_id` int(11) NOT NULL,
  `assignee_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_status_assignee_rel`
--

LOCK TABLES `production_status_assignee_rel` WRITE;
/*!40000 ALTER TABLE `production_status_assignee_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `production_status_assignee_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_status_features`
--

DROP TABLE IF EXISTS `production_status_features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_status_features` (
  `status_id` int(11) DEFAULT NULL,
  `duration` int(11) NOT NULL,
  `is_global` tinyint(1) NOT NULL DEFAULT '0',
  `is_group` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_status_features`
--

LOCK TABLES `production_status_features` WRITE;
/*!40000 ALTER TABLE `production_status_features` DISABLE KEYS */;
INSERT INTO `production_status_features` VALUES (6,12,0,0),(7,12,1,0);
/*!40000 ALTER TABLE `production_status_features` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_status_print_profile_rel`
--

DROP TABLE IF EXISTS `production_status_print_profile_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_status_print_profile_rel` (
  `status_id` int(11) DEFAULT NULL,
  `print_profile_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_status_print_profile_rel`
--

LOCK TABLES `production_status_print_profile_rel` WRITE;
/*!40000 ALTER TABLE `production_status_print_profile_rel` DISABLE KEYS */;
INSERT INTO `production_status_print_profile_rel` VALUES (6,1),(6,2);
/*!40000 ALTER TABLE `production_status_print_profile_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_tags`
--

DROP TABLE IF EXISTS `production_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_tags` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `module_id` int(11) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_tags`
--

LOCK TABLES `production_tags` WRITE;
/*!40000 ALTER TABLE `production_tags` DISABLE KEYS */;
INSERT INTO `production_tags` VALUES (1,1,'rush order',1),(2,1,'quote',1),(3,1,'new customer',1),(4,1,'returning customer',1),(5,1,'large order',1);
/*!40000 ALTER TABLE `production_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `production_template_abbriviations`
--

DROP TABLE IF EXISTS `production_template_abbriviations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_template_abbriviations` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `abbr_name` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `module_id` int(11) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `production_template_abbriviations`
--

LOCK TABLES `production_template_abbriviations` WRITE;
/*!40000 ALTER TABLE `production_template_abbriviations` DISABLE KEYS */;
INSERT INTO `production_template_abbriviations` VALUES (1,'{quote_id}',1),(2,'{quote_date}',1),(3,'{customer_name}',1),(4,'{payment_date}',1),(5,'{shipping_date}',1),(6,'{delivery_date}',1),(7,'{payment_amount}',1),(8,'{payment_due_amount}',1),(9,'{public_url}',1),(10,'{reject_note}',1),(11,'{request_payment_amount}',1),(12,'{quote_total_amount}',1),(13,'{order_id}',2),(14,'{order_status}',2),(15,'{artwork_status}',2),(16,'{order_created_date}',2),(17,'{order_value}',2),(18,'{payment_type}',2),(19,'{order_notes}',2),(20,'{product_name}',2),(21,'{customer_name}',2),(22,'{customer_address}',2),(23,'{mobile_no}',2),(24,'{customer_email}',2),(25,'{customer_name}',6),(26,'{customer_address}',6),(27,'{customer_email}',6),(28,'{signup_date}',6),(29,'{order_value}',6),(30,'{number_of_orders}',6),(31,'{last_order}',6),(32,'{mobile_no}',6),(33,'{job_id}',4),(34,'{order_id}',4),(35,'{order_item_id}',4),(36,'{customer_name}',4),(37,'{customer_email}',4),(38,'{item_name}',4),(39,'{print_profile}',4),(40,'{stage_name}',4),(41,'{quote_total_amount}',1),(42,'{public_url}',2),(43,'{quote_pdf_download}',1),(44,'{po_id}',3),(45,'{contact_name}',3),(46,'{vendor_name}',3),(47,'{vendor_email}',3),(48,'{created_date}',3),(49,'{expected_date_of_delivery}',3),(50,'{form_data}',7),(51,'{product_data}',7),(52,'{customer_name}',7),(53,'{customer_email}',7),(54,'{requested_date}',7);
/*!40000 ALTER TABLE `production_template_abbriviations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchase_order`
--

DROP TABLE IF EXISTS `purchase_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_order` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `po_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `status_id` int(4) NOT NULL,
  `store_id` int(4) NOT NULL,
  `vendor_id` int(7) NOT NULL,
  `ship_address_id` int(7) NOT NULL,
  `po_notes` text COLLATE utf8_unicode_ci,
  `expected_delivery_date` date NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`xe_id`),
  KEY `purchase_order_index_key_01` (`po_id`,`status_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchase_order`
--

LOCK TABLES `purchase_order` WRITE;
/*!40000 ALTER TABLE `purchase_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `purchase_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchase_order_items`
--

DROP TABLE IF EXISTS `purchase_order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_order_items` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_order_id` int(11) NOT NULL,
  `order_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `order_item_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `status_id` int(4) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchase_order_items`
--

LOCK TABLES `purchase_order_items` WRITE;
/*!40000 ALTER TABLE `purchase_order_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `purchase_order_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchase_order_status`
--

DROP TABLE IF EXISTS `purchase_order_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_order_status` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `status_name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `color_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `module_id` int(11) NOT NULL,
  `is_default` enum('0','1') COLLATE utf8_unicode_ci NOT NULL,
  `sort_order` int(4) NOT NULL,
  `status` enum('1','0') COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchase_order_status`
--

LOCK TABLES `purchase_order_status` WRITE;
/*!40000 ALTER TABLE `purchase_order_status` DISABLE KEYS */;
INSERT INTO `purchase_order_status` VALUES (6,1,'PO sent','#1a73e8',3,'1',1,'1','po-sent'),(7,1,'Partially received','#f23cfd',3,'1',3,'1','partially'),(8,1,'Received','#49ce49',3,'1',4,'1','received'),(9,1,'Pending','#e4d23d',3,'1',2,'1','pending');
/*!40000 ALTER TABLE `purchase_order_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotation_request_details`
--

DROP TABLE IF EXISTS `quotation_request_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quotation_request_details` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_id` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `product_details` mediumtext COLLATE utf8_unicode_ci,
  `design_details` mediumtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotation_request_details`
--

LOCK TABLES `quotation_request_details` WRITE;
/*!40000 ALTER TABLE `quotation_request_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotation_request_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotation_request_form_values`
--

DROP TABLE IF EXISTS `quotation_request_form_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quotation_request_form_values` (
  `quote_id` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `form_key` mediumtext COLLATE utf8_unicode_ci,
  `form_value` mediumtext COLLATE utf8_unicode_ci,
  `form_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotation_request_form_values`
--

LOCK TABLES `quotation_request_form_values` WRITE;
/*!40000 ALTER TABLE `quotation_request_form_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotation_request_form_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotations`
--

DROP TABLE IF EXISTS `quotations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quotations` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `quote_id` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `customer_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shipping_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `agent_id` int(11) DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'admin, customer, agent',
  `created_by_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quote_source` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'admin, tool, form',
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `ship_by_date` datetime DEFAULT NULL,
  `exp_delivery_date` datetime DEFAULT NULL,
  `is_artwork` tinyint(1) NOT NULL DEFAULT '0',
  `is_rush` tinyint(1) NOT NULL DEFAULT '0',
  `rush_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'percentage, flat',
  `rush_amount` float(10,2) DEFAULT NULL COMMENT 'value depends upon rush_type',
  `discount_type` enum('percentage','flat') COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_amount` float(10,2) DEFAULT NULL COMMENT 'value depends upon discount_type',
  `shipping_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shipping_amount` float(10,2) DEFAULT NULL,
  `tax_amount` float(10,2) DEFAULT NULL,
  `design_total` float(10,2) DEFAULT NULL,
  `quote_total` float(10,2) DEFAULT NULL,
  `note` mediumtext COLLATE utf8_unicode_ci,
  `status_id` int(11) DEFAULT NULL,
  `draft_flag` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-send to customer,1-save as draft',
  `reject_note` mediumtext COLLATE utf8_unicode_ci,
  `invoice_id` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `request_payment` float(10,2) DEFAULT NULL,
  `request_date` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `customer_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_availability` tinyint(1) NOT NULL DEFAULT '0',
  `is_ready_to_send` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-not ready, 1-ready',
  `quotation_request_id` int(11) DEFAULT NULL,
  `archive_status` tinyint(1) DEFAULT '0',
  `currency_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`xe_id`),
  KEY `quotation_index_key_01` (`quote_id`,`customer_id`,`customer_name`,`customer_email`,`title`,`status_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotations`
--

LOCK TABLES `quotations` WRITE;
/*!40000 ALTER TABLE `quotations` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_conversation_files`
--

DROP TABLE IF EXISTS `quote_conversation_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_conversation_files` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `conversation_id` int(11) NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_conversation_files`
--

LOCK TABLES `quote_conversation_files` WRITE;
/*!40000 ALTER TABLE `quote_conversation_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `quote_conversation_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_conversations`
--

DROP TABLE IF EXISTS `quote_conversations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_conversations` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_id` int(11) NOT NULL,
  `user_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_type` enum('admin','agent','customer') COLLATE utf8_unicode_ci NOT NULL,
  `message` mediumtext COLLATE utf8_unicode_ci,
  `seen_flag` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_conversations`
--

LOCK TABLES `quote_conversations` WRITE;
/*!40000 ALTER TABLE `quote_conversations` DISABLE KEYS */;
/*!40000 ALTER TABLE `quote_conversations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_dynamic_form_attribute`
--

DROP TABLE IF EXISTS `quote_dynamic_form_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_dynamic_form_attribute` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `input_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_dynamic_form_attribute`
--

LOCK TABLES `quote_dynamic_form_attribute` WRITE;
/*!40000 ALTER TABLE `quote_dynamic_form_attribute` DISABLE KEYS */;
INSERT INTO `quote_dynamic_form_attribute` VALUES (1,'Text'),(2,'Email'),(3,'Number'),(4,'Select option'),(5,'Checkbox'),(6,'Radio Button'),(7,'Textarea'),(8,'Upload files'),(9,'Date Picker');
/*!40000 ALTER TABLE `quote_dynamic_form_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_dynamic_form_values`
--

DROP TABLE IF EXISTS `quote_dynamic_form_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_dynamic_form_values` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `label_slug` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `attribute_id` int(11) NOT NULL,
  `placeholder` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` mediumtext COLLATE utf8_unicode_ci,
  `is_required` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-Optional,1-Required',
  `sort_order` int(5) DEFAULT NULL,
  `store_id` int(4) NOT NULL DEFAULT '1',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_dynamic_form_values`
--

LOCK TABLES `quote_dynamic_form_values` WRITE;
/*!40000 ALTER TABLE `quote_dynamic_form_values` DISABLE KEYS */;
INSERT INTO `quote_dynamic_form_values` VALUES (1,'Customer name','customername',1,'Customer name',NULL,1,NULL,1,1),(2,'Customer email','customeremail',2,'Customer email',NULL,1,NULL,1,1);
/*!40000 ALTER TABLE `quote_dynamic_form_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_internal_note`
--

DROP TABLE IF EXISTS `quote_internal_note`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_internal_note` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_id` int(11) NOT NULL,
  `user_type` enum('admin','agent') COLLATE utf8_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `note` mediumtext COLLATE utf8_unicode_ci,
  `seen_flag` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_internal_note`
--

LOCK TABLES `quote_internal_note` WRITE;
/*!40000 ALTER TABLE `quote_internal_note` DISABLE KEYS */;
/*!40000 ALTER TABLE `quote_internal_note` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_internal_note_files`
--

DROP TABLE IF EXISTS `quote_internal_note_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_internal_note_files` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `note_id` int(11) NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_internal_note_files`
--

LOCK TABLES `quote_internal_note_files` WRITE;
/*!40000 ALTER TABLE `quote_internal_note_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `quote_internal_note_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_item_files`
--

DROP TABLE IF EXISTS `quote_item_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_item_files` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `side_id` int(11) NOT NULL,
  `decoration_area_id` int(11) NOT NULL,
  `print_method_id` int(11) NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `preview_file` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra_data` mediumtext COLLATE utf8_unicode_ci,
  `decoration_settings_id` int(11) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_item_files`
--

LOCK TABLES `quote_item_files` WRITE;
/*!40000 ALTER TABLE `quote_item_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `quote_item_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_item_variants`
--

DROP TABLE IF EXISTS `quote_item_variants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_item_variants` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `variant_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_price` float(10,2) NOT NULL,
  `options` text COLLATE utf8_unicode_ci,
  `attribute` text COLLATE utf8_unicode_ci,
  `updated_price` float(10,2) DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_item_variants`
--

LOCK TABLES `quote_item_variants` WRITE;
/*!40000 ALTER TABLE `quote_item_variants` DISABLE KEYS */;
/*!40000 ALTER TABLE `quote_item_variants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_items`
--

DROP TABLE IF EXISTS `quote_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_items` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_id` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `product_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `artwork_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'uploaded_file, design_tool, no_decoration',
  `custom_design_id` int(11) DEFAULT NULL,
  `design_cost` float(10,2) DEFAULT NULL,
  `unit_total` float(10,2) DEFAULT NULL,
  `is_variable_decoration` tinyint(1) DEFAULT NULL COMMENT '0-not a vdp, 1- vdp',
  `is_custom_size` tinyint(1) DEFAULT NULL COMMENT '0-not custom size, 1- custom size',
  `custom_size_dimension` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_size_dimension_unit` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_decorated_product` tinyint(1) DEFAULT '0' COMMENT '0- not decorated product, 1- decorated product',
  `is_redesign` tinyint(1) DEFAULT '1' COMMENT '0- no redesign option, 1- redesign option',
  `is_team_jersey` tinyint(1) DEFAULT '0',
  `product_type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_sticker` tinyint(1) DEFAULT '0',
  `is_tier_total_qty` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`xe_id`),
  KEY `quote_items_index_key_01` (`quote_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_items`
--

LOCK TABLES `quote_items` WRITE;
/*!40000 ALTER TABLE `quote_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `quote_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_log`
--

DROP TABLE IF EXISTS `quote_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_log` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_id` int(11) NOT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `user_type` enum('admin','customer','agent') COLLATE utf8_unicode_ci NOT NULL COMMENT 'i.e agent data in case of agent assignment  ',
  `user_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'i.e agent data in case of agent assignment',
  `created_date` datetime NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_log`
--

LOCK TABLES `quote_log` WRITE;
/*!40000 ALTER TABLE `quote_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `quote_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_payment_methods`
--

DROP TABLE IF EXISTS `quote_payment_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_payment_methods` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) DEFAULT NULL,
  `payment_type` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `payment_mode` enum('test','live') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'test',
  `is_selected` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_payment_methods`
--

LOCK TABLES `quote_payment_methods` WRITE;
/*!40000 ALTER TABLE `quote_payment_methods` DISABLE KEYS */;
INSERT INTO `quote_payment_methods` VALUES (1,1,'PayPal','test',1),(2,1,'Stripe','test',0);
/*!40000 ALTER TABLE `quote_payment_methods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_payment_settings`
--

DROP TABLE IF EXISTS `quote_payment_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_payment_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_method_id` int(11) NOT NULL,
  `keyname` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `keyvalue` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_payment_settings`
--

LOCK TABLES `quote_payment_settings` WRITE;
/*!40000 ALTER TABLE `quote_payment_settings` DISABLE KEYS */;
INSERT INTO `quote_payment_settings` VALUES (1,1,'merchant_email_id',NULL);
/*!40000 ALTER TABLE `quote_payment_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_payments`
--

DROP TABLE IF EXISTS `quote_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_payments` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_id` int(11) NOT NULL,
  `payment_amount` float(10,2) NOT NULL,
  `txn_id` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_mode` enum('online','offline','cash','cheque','bank transfer','credit card','others') COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_status` enum('pending','paid') COLLATE utf8_unicode_ci DEFAULT NULL,
  `note` mediumtext COLLATE utf8_unicode_ci,
  `payment_method_id` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0 in case of other payment mode',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_payments`
--

LOCK TABLES `quote_payments` WRITE;
/*!40000 ALTER TABLE `quote_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `quote_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_sticker_data`
--

DROP TABLE IF EXISTS `quote_sticker_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_sticker_data` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_item_id` int(11) DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_sticker_data`
--

LOCK TABLES `quote_sticker_data` WRITE;
/*!40000 ALTER TABLE `quote_sticker_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `quote_sticker_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quote_tag_rel`
--

DROP TABLE IF EXISTS `quote_tag_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quote_tag_rel` (
  `quote_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quote_tag_rel`
--

LOCK TABLES `quote_tag_rel` WRITE;
/*!40000 ALTER TABLE `quote_tag_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `quote_tag_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_channel`
--

DROP TABLE IF EXISTS `sales_channel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_channel` (
  `xe_id` int(4) NOT NULL AUTO_INCREMENT,
  `channel_name` varchar(100) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_channel`
--

LOCK TABLES `sales_channel` WRITE;
/*!40000 ALTER TABLE `sales_channel` DISABLE KEYS */;
INSERT INTO `sales_channel` VALUES (1,'Online Store'),(2,'Amazon');
/*!40000 ALTER TABLE `sales_channel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_channel_artwork`
--

DROP TABLE IF EXISTS `sales_channel_artwork`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_channel_artwork` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` int(11) NOT NULL,
  `sku` varchar(100) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_channel_artwork`
--

LOCK TABLES `sales_channel_artwork` WRITE;
/*!40000 ALTER TABLE `sales_channel_artwork` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_channel_artwork` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_channel_artwork_relation`
--

DROP TABLE IF EXISTS `sales_channel_artwork_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_channel_artwork_relation` (
  `artwork_id` int(11) NOT NULL,
  `sales_channel_id` int(4) NOT NULL,
  `product_id` varchar(100) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_channel_artwork_relation`
--

LOCK TABLES `sales_channel_artwork_relation` WRITE;
/*!40000 ALTER TABLE `sales_channel_artwork_relation` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_channel_artwork_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schema_version_xe`
--

DROP TABLE IF EXISTS `schema_version_xe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `schema_version_xe` (
  `version` bigint(20) NOT NULL,
  `name` mediumtext COLLATE utf8_unicode_ci,
  `md5` mediumtext COLLATE utf8_unicode_ci,
  `run_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schema_version_xe`
--

LOCK TABLES `schema_version_xe` WRITE;
/*!40000 ALTER TABLE `schema_version_xe` DISABLE KEYS */;
INSERT INTO `schema_version_xe` VALUES (0,NULL,NULL,'2025-08-25 05:14:24'),(1,'augmented_realities','7ed1ed6f418c5ca1f340774e3e84500f','2025-08-25 05:14:25'),(2,'backgrounds','145b34a4182f34ae110e3e41ffa33ffe','2025-08-25 05:14:25'),(3,'browser_image','f48826deb9fa6b51bd5e99338110fa15','2025-08-25 05:14:25'),(4,'cliparts','bca69db0e373ee0041758c751182c4e2','2025-08-25 05:14:25'),(5,'color','bfd35d9b30ed4974d0fb97e31ff933b1','2025-08-25 05:14:25'),(6,'common','137128991fa0189b5957de9d2e642e31','2025-08-25 05:14:25'),(7,'configurator','2747b3e10693529954cd4ad050f060a1','2025-08-25 05:14:25'),(8,'decoration_area','745ed9710aa0c3cf8518ba88b936a6a3','2025-08-25 05:14:25'),(9,'distress','4f444800192c577b735314ae33f68347','2025-08-25 05:14:25'),(10,'font','0bd1f22e43bb8ef6feb0fc2b0b2cafe1','2025-08-25 05:14:25'),(11,'graphic_fonts','13fb512d75be756db1077a35914d9ebc','2025-08-25 05:14:26'),(12,'mask','b3e2889ca017a2ad703003e67153d02c','2025-08-25 05:14:26'),(13,'order','75d0b39c2a48599829ec0ad212aef7e3','2025-08-25 05:14:26'),(14,'print_profile','846c0301e0b740a204b6255b6be86757','2025-08-25 05:14:26'),(15,'product_pricing','f4b004d665fdce28a06cb2cfa2a1ef74','2025-08-25 05:14:26'),(16,'product_setting','9455ec84e26c33f9b27d64867fcd787b','2025-08-25 05:14:27'),(17,'settings','ef8ef7bdf6ffd72fbd4eea451233a1e5','2025-08-25 05:14:27'),(18,'shape','f7ee4405938dfff2a4d8bda8bc791ea7','2025-08-25 05:14:27'),(19,'template','7e3c5adcd555aa99571ecc858ccf3d77','2025-08-25 05:14:27'),(20,'user-design','246546f86d2577dd048cdf750caec92a','2025-08-25 05:14:27'),(21,'users','86faeffd6bfc3feee23aebee26f51a33','2025-08-25 05:14:27'),(22,'word_cloud','4e898776ab2116435eb900304b885764','2025-08-25 05:14:27'),(23,'add_two_question_user','a716d1eed0323b01a7163a1eede9c1b0','2025-08-25 05:14:27'),(24,'custom_size','2baf53273cdf02934ca9d529d41d70fe','2025-08-25 05:14:27'),(25,'insert_assets_parent_category_print_profile_rel','08f7fa8e1e1eb38b01793213a6c4e4cd','2025-08-25 05:14:27'),(26,'order_item_token','a8f1581045a47439ddfabf85bad69261','2025-08-25 05:14:27'),(27,'order_status','074bd449a9b6312297089eb1c065cbbe','2025-08-25 05:14:28'),(28,'sticker_settings','ab1fe01565db91288c2c735f018b1dd0','2025-08-25 05:14:28'),(29,'update_user_privileges (2)','25698e7cf820a51b611c24be9f85c658','2025-08-25 05:14:28'),(30,'update_user_privileges','25698e7cf820a51b611c24be9f85c658','2025-08-25 05:14:28'),(31,'uv_files','b9d55e18901bc2c4ba8ae4895ddf85c2','2025-08-25 05:14:28'),(32,'product_catalog','4a7a755765ec935b7c16ff7020aac006','2025-08-25 05:14:28'),(33,'sticker_addon','eb686190830832ebd41188a74cbafa7e','2025-08-25 05:14:28'),(34,'quotation','d4ab0907b95bf7e6efed633ec3edd4a3','2025-08-25 05:14:28'),(35,'update_user_privileges','17b93c2b88d359228f0a547335bb292b','2025-08-25 05:14:28'),(36,'advance_settings','bbe96a24477a9866a8ab710fb7e4ba26','2025-08-25 05:14:29'),(37,'custom_size_unit_price','a5869e88ebd0f8fd8f8df3f2329d5c4f','2025-08-25 05:14:29'),(38,'decoration_width_height','0bcfd3a320145573ee986dd8d4ff768c','2025-08-25 05:14:29'),(39,'product_decoration','ad1f4b52c87f186026a47048b759b77a','2025-08-25 05:14:29'),(40,'quote_item_files','c383ace90c63000c8be222c1b9250e47','2025-08-25 05:14:29'),(41,'unit_label','9c3a8ee3e441d4982703d7fc8fcd1f11','2025-08-25 05:14:29'),(42,'x_y_location','e76d8ee9792593dbf5d1285ee79bf9b9','2025-08-25 05:14:29'),(43,'quote_item_files','2c934e048f2b14443db9075f7f9cb724','2025-08-25 05:14:29'),(44,'add_language','f87c909dff6943b2858aab7765f9230f','2025-08-25 05:14:29'),(45,'customer_email_template','23903fb0ce08f27e8e3c7d21d7bd22b7','2025-08-25 05:14:29'),(46,'design_state_category','6684a9d00ac9d31bbb5fb49712f60518','2025-08-25 05:14:29'),(47,'pricing_price_type','8dfc5bf6f4f909ac915b78c0434cfa3b','2025-08-25 05:14:30'),(48,'qr_feature','9b0f7c82434cae99557aa0220b24d03a','2025-08-25 05:14:30'),(49,'utf8','ceb746d446b8907e0ab4d3afd247e984','2025-08-25 05:14:36'),(50,'quote_item_variants','295fd4740bffed1627e02223e55180af','2025-08-25 05:14:36'),(51,'dropbox_drive','e4d029c0e734d00901d972fd242513e4','2025-08-25 05:14:36'),(52,'productions','7aa76c5560d9245ff6d5cb17102abe9b','2025-08-25 05:14:36'),(53,'purchase_order','1d102da3e121ed0b98d5c56795cccde1','2025-08-25 05:14:36'),(54,'quote_item_files','2c934e048f2b14443db9075f7f9cb724','2025-08-25 05:14:36'),(55,'ship_address','7b19ea4e8e029ed6d9cab69a07a59b43','2025-08-25 05:14:36'),(56,'vendor','b4511d47e33c08f3dc60d7bb73f78e8e','2025-08-25 05:14:37'),(57,'customer_email_template','a63712021d65ac17a1ddb1c034de6cfe','2025-08-25 05:14:37'),(58,'dynamic_deco_cost','ca94dafbbf4c0f26fc7329da32df38fa','2025-08-25 05:14:37'),(59,'design_states','85afa89f2d3a636c6c6b99664f79d8d9','2025-08-25 05:14:37'),(60,'email_log','851069b08ab78185180d725bbde2a486','2025-08-25 05:14:37'),(61,'quotations','5c813b1c810cc034253f743d2bec4148','2025-08-25 05:14:37'),(62,'app_currency','a8c2a379f8f22f0cd547b18104fb5fbd','2025-08-25 05:14:37'),(63,'orders','ee5f848384befbd50f95477fe316dfa9','2025-08-25 05:14:37'),(64,'production_status','769a2562356bd0654c5c66d1c2ba80e9','2025-08-25 05:14:37'),(65,'quote_items','93b9beb8c8d6195bd84ab84c25295c33','2025-08-25 05:14:37'),(66,'svg_configurator','2793bb964f4005830ff850acb8884d00','2025-08-25 05:14:37'),(67,'user_store_rel','cd385b02ac8d973d8a360c7782317d0f','2025-08-25 05:14:38'),(68,'image_overlay','08880bc11dba5155425f5ba3b3ae69c5','2025-08-25 05:14:38'),(69,'kiosk_transaction','0937a132bbd7b1b96b1d6ea9c22d9c12','2025-08-25 05:14:38'),(70,'missing_schema_from_400','44a68870188cf68d7c0782694bcede4f','2025-08-25 05:14:38'),(71,'thread_count_price','b4ca3850cd54db26a61e1358e6b5a557','2025-08-25 05:14:38'),(72,'alter_print_profile_engrave_settings','0abdc9e71edbbb56c95e9f5394118025','2025-08-25 05:14:38'),(73,'bleed_mark_and_safe_mark','0e877ae8e190bd9908da91a4c58577c8','2025-08-25 05:14:38'),(74,'categories','5fe581a8e6f35f5b4a0a941b96d59814','2025-08-25 05:14:38'),(75,'customer_internal_note','91b727db04087ac56408efcd9186bf3a','2025-08-25 05:14:38'),(76,'install_language','d62dc33a6673998155799a1fae37360c','2025-08-25 05:14:38'),(77,'production_email_templates','726f94402e2a9bd639dfc722446b5654','2025-08-25 05:14:38'),(78,'production_job_holidays','f4587f216098f41289a68e54073da3b7','2025-08-25 05:14:38'),(79,'quotations','e9a27c50837e6476e37c63d61e1f2236','2025-08-25 05:14:39'),(80,'quote_dynamic_form_values','fdd791ee0f59c0300c468615d80aa0e4','2025-08-25 05:14:39'),(81,'users','ce89d7a39a9a9e02ae8f40d4602cad28','2025-08-25 05:14:40'),(82,'over_logo','3ba2d793d0ef8a39fdbe4b35175c3085','2025-08-25 05:14:40'),(83,'assets_import','40ad4246463f43e9358e0af52a90b219','2025-08-25 05:14:40'),(84,'privileges_sub_modules','14c0e0e04045496338c804884259824b','2025-08-25 05:14:40'),(85,'customer_group','a4ed69d40f0037d225e8c19b446018bd','2025-08-25 05:14:40'),(86,'is_disable_design','4c54e6bf76eeed0496d1225ab09c5089','2025-08-25 05:14:40'),(87,'quotation_payment','9347303bdc13628a247358288df88d70','2025-08-25 05:14:40'),(88,'decoration_area','b3d399ac5d485791595625acca726eab','2025-08-25 05:14:40'),(89,'default_pp_id','a0c016267e27eaa83a3e0ac90dcc7d4c','2025-08-25 05:14:40'),(90,'embroidery_cost','9c052c1ea38e4c77a65c9ac577a5fc23','2025-08-25 05:14:40'),(91,'production_job_stages','af96aaeb62f84c07bf8be43bb6fbb40d','2025-08-25 05:14:40'),(92,'quotation_log','efa18ee6e2038bf907151c54f1d805dd','2025-08-25 05:14:40'),(93,'orders','be926f2b6d46f2214b171d29e742438e','2025-08-25 05:14:41'),(94,'privileges_sub_modules','381661711bfe87871353e64917005c81','2025-08-25 05:14:41'),(95,'quotation_archive','da34c3e461b1a51fc65d24d647e4a9a5','2025-08-25 05:14:41'),(96,'request_a_quote','1f088d530ca28e6619be643c0cbdeb2e','2025-08-25 05:14:41'),(97,'bar_code','96b1ef826969bdc0163a4e17beebb0d3','2025-08-25 05:14:41'),(98,'over_logo','cdfce9aad0794c7a6562581b6d1e05b9','2025-08-25 05:14:41'),(99,'printful_shipstation','2d89a66a6541968f5412695f62576a43','2025-08-25 05:14:41'),(100,'category_image','6b34f99665d3191c7c408197dba52de5','2025-08-25 05:14:41'),(101,'embroidery_ price_setting','4b0691b13724ee589046a9f316528f43','2025-08-25 05:14:41'),(102,'price_modules','a9573e74a5388e1caa9b88283458f271','2025-08-25 05:14:41'),(103,'s3_assets','a9c9205eed008288ac2cd5c6f8c4a154','2025-08-25 05:14:42'),(104,'alter_print_profile','635ad730188088346774ddaa8a0163e6','2025-08-25 05:14:42'),(105,'catalog_product_rel','3a56873e7ebd4b5ae42bb5a97b6bb6e0','2025-08-25 05:14:42'),(106,'category_listing','fc13e977573b56ed5bf44d5c27094c91','2025-08-25 05:14:42'),(107,'product_setting','3e44ac822308dff4519557397325b95d','2025-08-25 05:14:43'),(108,'production_email_template','e451f05a76fd77d6455eab0754797451','2025-08-25 05:14:43'),(109,'quote_items','2a8b37594a093d70600f1e4c266c7899','2025-08-25 05:14:43'),(110,'user_privileges','09163fc0343d14dd1c2668ae6283682c','2025-08-25 05:14:43'),(111,'catalog_product_rel','85f948cbfde317147963d4a59f56c0cc','2025-08-25 05:14:43'),(112,'templates','fc4b7915d2ac56807d88b776723e385b','2025-08-25 05:14:43'),(113,'alter_price_module_settings','97512cd8842533fda2a742aa7756aaa4','2025-08-25 05:14:43'),(114,'decoration_objects','7cad72550a145a2fd86fc44933fb6800','2025-08-25 05:14:43'),(115,'price_decimal_changes','3ba7ebc2d8f69f47380111daa032396d','2025-08-25 05:14:44'),(116,'print_profile_feature','9f817de6e6a958d6dd462476e92884f0','2025-08-25 05:14:44'),(117,'privileges_sub_modules','e2916ce4f23ae734f548d82e17a1c932','2025-08-25 05:14:44'),(118,'product_setting','1e0e78b0e764f3f635d1dd90c17835bf','2025-08-25 05:14:44'),(119,'production_hub_settings','dac49902f0813b1afc6cb9a992bfc3ac','2025-08-25 05:14:44'),(120,'settings','e003bbdb499c51d521e8a6e4fb34092c','2025-08-25 05:14:44'),(121,'shopify_variants','c53d82770a83d1d96bfc939fce9931d9','2025-08-25 05:14:44'),(122,'marketplace','d645c34f38bb30e69211ff88a460fa99','2025-08-25 05:14:44'),(123,'quotation_enhancement','37216823d05e4534998c1941006dab07','2025-08-25 05:14:44'),(124,'quotation_enhancement','c954ab9a3a5c9ca0b7da3142287379a9','2025-08-25 05:14:44'),(125,'alter_price_advanced_price_settings','d04990b2ece137da50a98861177280f0','2025-08-25 05:14:45'),(126,'blank_product_add_cart','07c789a1cfe657a3524556a23b3c8ff8','2025-08-25 05:14:45'),(127,'category_asset_changes','3c70acac5e669970342eda12aafbb88a','2025-08-25 05:14:45'),(128,'production_job_logs','93081509134c3c0970f6a279be649e74','2025-08-25 05:14:45'),(129,'quotation_enhancement','5a25b01e6bafe5e5a7f0f8a021d41f8c','2025-08-25 05:14:45'),(130,'sticker_compatibility','48cc746b5671825c7d743a70169130e3','2025-08-25 05:14:45'),(131,'template_data','f8af79ff56f4572072b1af8cd71d8156','2025-08-25 05:14:45'),(132,'alter_user_design','9356daa9ddb7ad3e060a55577a15729d','2025-08-25 05:14:45'),(133,'quotation_conversation','96d97547c8445c32971c1d71c7c764d9','2025-08-25 05:14:45'),(134,'shape_mark_data_changes','755bbcca4a9bfcadc0490b00e608db16','2025-08-25 05:14:45'),(135,'alter_catalog_product_rel','b2e37be1f4f2770b28e126d040165b2c','2025-08-25 05:14:45'),(136,'alter_print_profile','34747c9d8eb0d88cd189423a66a72be6','2025-08-25 05:14:45'),(137,'app_currency','11e94d602103a0c6799ac302f4c937d9','2025-08-25 05:14:45'),(138,'config-pattern','eacaf19a6553716069e9ff4083a513c7','2025-08-25 05:14:45'),(139,'configurator_pattern','35ca88825b37d86ff166ab6f9f017400','2025-08-25 05:14:45'),(140,'design_states','bb6b10015858cb65ed2e98ea488685fd','2025-08-25 05:14:45'),(141,'distress_effect','b0820a7e87201f1572541ab77d6a76cf','2025-08-25 05:14:45'),(142,'order_artwork_approval','db55182c8ffa816d6aabdf4288339562','2025-08-25 05:14:46'),(143,'product_image_changes','18563f94fbe5e9328c9252006e4714fc','2025-08-25 05:14:46'),(144,'templates_changes','bbf07b450f8097c0e356ccd0929c35a4','2025-08-25 05:14:46'),(145,'distress_effect_changes','a8e787c508ab55a768305db577379e3d','2025-08-25 05:14:46'),(146,'quotation_tier_price','407626620bed01b6d85f1529d674cfd0','2025-08-25 05:14:46'),(147,'svg_configurator_setting_change','996609c70a90bbc4e2826564495c887a','2025-08-25 05:14:46'),(148,'template_url','731437c5d746762cde644b7c885ebdac','2025-08-25 05:14:46'),(149,'add_language','76fe25b1b8bcbc09f7b7645e0090c4c3','2025-08-25 05:14:46'),(150,'alter_product_settings','8e739b011586cbfeb25da7a2727073fd','2025-08-25 05:14:46'),(151,'configurator_color','efdaa1ef81c7893c4e9ff0b23b5101df','2025-08-25 05:14:46'),(152,'font_styles','e774b2a2f5d0efd1f9bba7d3c2dd7417','2025-08-25 05:14:46'),(153,'product_option_setting_rel','c1b2b704fefc88d21639efe28f065355','2025-08-25 05:14:46'),(154,'quotation_payment_settings','b067962c4e5e795607b9ad665136a385','2025-08-25 05:14:46'),(155,'users','ce743ce444a9eff6b02e5f28366ebbe1','2025-08-25 05:14:46');
/*!40000 ALTER TABLE `schema_version_xe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `security_questions`
--

DROP TABLE IF EXISTS `security_questions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `security_questions` (
  `xe_id` int(4) NOT NULL AUTO_INCREMENT,
  `question` mediumtext COLLATE utf8_unicode_ci,
  `store_id` int(4) DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `security_questions`
--

LOCK TABLES `security_questions` WRITE;
/*!40000 ALTER TABLE `security_questions` DISABLE KEYS */;
INSERT INTO `security_questions` VALUES (1,'What was your first pet?',1),(2,'What was the model of your first car?',1),(3,'In what city were you born?',1),(4,'What was your childhood nickname?',1);
/*!40000 ALTER TABLE `security_questions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setting_value` mediumtext COLLATE utf8_unicode_ci,
  `type` tinyint(1) DEFAULT '0',
  `store_id` int(4) DEFAULT NULL,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'revision_no','1',0,1,'2020-03-30 17:00:58'),(40,'color','color',4,1,'2020-03-30 17:00:58'),(41,'size','size',4,1,'2020-03-30 17:00:58'),(58,'direct_check_out','1',5,1,'2020-03-31 11:02:55'),(59,'cart_terms_condition','{\"is_enabled\":true,\"description\":\"Please make sure you are uploading high resolution images when customizing your product.  If your artwork does not follow our recommended guidelines, we cannot guarantee the quality of the final printed product. Please make sure to check your design for SPELLING, CLARITY OF THE IMAGES and TEXT PLACEMENT. What you see on the screen is what we will be printing on the product. We are not responsible for the customers supplied artwork, spelling or wrong placement of the text.\"}',5,1,'2020-03-31 11:02:55'),(60,'order_notes','{\"is_enabled\":true,\"description\":\"Notes are the first thing we check when we start work on your order. Tell us if you have any question on the printing process, quality or any customization.\"}',5,1,'2020-03-31 11:02:55'),(70,'measurement_unit','{\"unit\":1,\"display_lebel\":\"Inch\"}',1,1,'2020-03-31 11:18:17'),(71,'currency','{\"currencyId\":1,\"currency\":\"$\",\"separator\":\".\",\"post_fix\":\"USD\"}',1,1,'2020-03-31 11:18:17'),(72,'email','admin@gmail.com',1,1,'2020-03-31 11:18:17'),(73,'advance_settings','{\"prompt_close_window\":true,\"price_segregation\":true,\"progress_wizard\":true,\"social_share\":false,\"order_artwork_status\":true,\"maximum_gallery_size\": 200}',1,1,'2025-08-25 05:14:28'),(74,'facebook_import','{\"app_id\":\"\",\"domain_name\":\"\",\"url\":\"\"}',3,1,'2020-03-31 11:18:54'),(75,'dropbox_import','{\"is_enabled\":false}',3,1,'2025-08-25 05:14:35'),(76,'google_drive_import','{\"is_enabled\":false}',3,1,'2025-08-25 05:14:35'),(77,'file_uploaded','{\"width\":\"200\",\"height\":\"200\",\"low_resolution\":true,\"max_file\":\"10\",\"upload_tip\":true,\"tip_message\":\"On uploading one or several images, you agree to terms on using these images. Make use of third party images or infringing somebody else\'s rights in unlawful.\"}',3,1,'2020-03-31 11:18:54'),(78,'terms_condition','{\"is_enabled\":true,\"message\":\"By uploading an Image you guarantee that any people which are clearly identifiable have consented to have their likeness printed or displayed, or that you have full rights to use the Image in this manner and accept full responsibility for such use.\",\"is_default_status\":false}',3,1,'2020-03-31 11:18:54'),(91,'theme_color','#5667d6',2,1,'2020-03-31 11:26:54'),(92,'custom_css','style.css',2,1,'2020-03-31 11:26:54'),(93,'theme_layouts','1',2,1,'2020-03-31 11:26:54'),(94,'barcode_settings','{\"columns\": [{\"value\": 1,\"is_active\": 1},{\"value\": 2,\"is_active\": 0}],\"label_font_size\": [{\"value\": \"5px\",\"is_active\": 1}, {\"value\": \"10px\",\"is_active\": 0}, {\"value\": \"15px\",\"is_active\": 0}],\"font_size\": [{\"value\": \"10px\",\"is_active\": 1}, {\"value\": \"15px\",\"is_active\": 0}, {\"value\": \"20px\",\"is_active\": 0}],\"margin\": [{\"value\": \"15px\",\"is_active\": 0},{\"value\": \"20px\",\"is_active\": 0}]}',0,1,'2025-08-25 05:14:40'),(95,'is_email_settings_enabled','0',1,1,'2025-08-25 05:14:44'),(96,'order_blank_products','{\"is_enabled\":false}',5,1,'2025-08-25 05:14:44'),(97,'aspect_ratio','{\"is_enabled\":false,\"message\":\"By enabling this option, user can able to scale from four direction of the image\"}',3,1,'2025-08-25 05:14:44');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shape_category_rel`
--

DROP TABLE IF EXISTS `shape_category_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shape_category_rel` (
  `shape_id` bigint(20) DEFAULT NULL,
  `category_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shape_category_rel`
--

LOCK TABLES `shape_category_rel` WRITE;
/*!40000 ALTER TABLE `shape_category_rel` DISABLE KEYS */;
INSERT INTO `shape_category_rel` VALUES (1,20),(2,20),(3,20),(4,20),(5,20),(6,20),(7,20),(8,20),(9,20),(10,20),(11,20),(12,20),(13,20),(14,20),(15,20),(16,20),(17,20),(18,20),(19,20),(20,20);
/*!40000 ALTER TABLE `shape_category_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shape_tag_rel`
--

DROP TABLE IF EXISTS `shape_tag_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shape_tag_rel` (
  `shape_id` bigint(20) DEFAULT NULL,
  `tag_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shape_tag_rel`
--

LOCK TABLES `shape_tag_rel` WRITE;
/*!40000 ALTER TABLE `shape_tag_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `shape_tag_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shapes`
--

DROP TABLE IF EXISTS `shapes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shapes` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shapes`
--

LOCK TABLES `shapes` WRITE;
/*!40000 ALTER TABLE `shapes` DISABLE KEYS */;
INSERT INTO `shapes` VALUES (1,'Shapes','202003300113458330.svg',1,'2020-03-30 13:13:45',0),(2,'Shapes','202003300113458330_1.svg',1,'2020-03-30 13:13:45',0),(3,'Shapes','202003300113458330_2.svg',1,'2020-03-30 13:13:45',0),(4,'Shapes','202003300113458330_3.svg',1,'2020-03-30 13:13:45',0),(5,'Shapes','202003300113458330_4.svg',1,'2020-03-30 13:13:45',0),(6,'Shapes','202003300113458330_5.svg',1,'2020-03-30 13:13:46',0),(7,'Shapes','202003300113458330_6.svg',1,'2020-03-30 13:13:46',0),(8,'Shapes','202003300113458330_7.svg',1,'2020-03-30 13:13:46',0),(9,'Shapes','202003300113458330_8.svg',1,'2020-03-30 13:13:46',0),(10,'Shapes','202003300113458330_9.svg',1,'2020-03-30 13:13:46',0),(11,'Shapes','202003300113458330_10.svg',1,'2020-03-30 13:13:46',0),(12,'Shapes','202003300113458330_11.svg',1,'2020-03-30 13:13:46',0),(13,'Shapes','202003300113458330_12.svg',1,'2020-03-30 13:13:46',0),(14,'Shapes','202003300113458330_13.svg',1,'2020-03-30 13:13:46',0),(15,'Shapes','202003300113458330_14.svg',1,'2020-03-30 13:13:46',0),(16,'Shapes','202003300113458330_15.svg',1,'2020-03-30 13:13:46',0),(17,'Shapes','202003300113458330_16.svg',1,'2020-03-30 13:13:46',0),(18,'Shapes','202003300113458330_17.svg',1,'2020-03-30 13:13:46',0),(19,'Shapes','202003300113458330_18.svg',1,'2020-03-30 13:13:46',0),(20,'Shapes','202003300113458330_19.svg',1,'2020-03-30 13:13:46',0);
/*!40000 ALTER TABLE `shapes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ship_to_address`
--

DROP TABLE IF EXISTS `ship_to_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ship_to_address` (
  `xe_id` int(7) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `company_name` varchar(30) DEFAULT NULL,
  `country_code` varchar(12) DEFAULT NULL,
  `state_code` varchar(20) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `zip_code` varchar(12) DEFAULT NULL,
  `ship_address` text,
  `store_id` int(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ship_to_address`
--

LOCK TABLES `ship_to_address` WRITE;
/*!40000 ALTER TABLE `ship_to_address` DISABLE KEYS */;
/*!40000 ALTER TABLE `ship_to_address` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stores`
--

DROP TABLE IF EXISTS `stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stores` (
  `xe_id` int(4) NOT NULL AUTO_INCREMENT,
  `store_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_url` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) DEFAULT '1',
  `settings` mediumtext COLLATE utf8_unicode_ci,
  `is_active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stores`
--

LOCK TABLES `stores` WRITE;
/*!40000 ALTER TABLE `stores` DISABLE KEYS */;
/*!40000 ALTER TABLE `stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tags` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(4) DEFAULT NULL,
  PRIMARY KEY (`xe_id`),
  KEY `tags_index_001` (`name`,`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (19,'Anton',1),(26,'Arrow',1),(11,'Ball',1),(3,'Basketball',1),(10,'Beach',1),(20,'Bebas',1),(27,'Circle',1),(6,'Distress',1),(7,'Distress Effect',1),(12,'fdfds',1),(21,'first',1),(18,'Font',1),(4,'Football',1),(25,'Heart',1),(8,'Image Mask',1),(17,'Italic Fonts',1),(2,'Orange',1),(30,'Oval',1),(14,'Pacifico',1),(29,'Polygon',1),(5,'Racing',1),(28,'Rectangle',1),(15,'roboto',1),(1,'Sea Green',1),(13,'sgdfgdf',1),(24,'Shapes',1),(31,'Star',1),(9,'Text Style',1),(16,'Texture',1),(22,'Word Cloud',1),(23,'Word Coud',1);
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `team_jersey_data`
--

DROP TABLE IF EXISTS `team_jersey_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `team_jersey_data` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_item_id` int(11) DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `team_jersey_data`
--

LOCK TABLES `team_jersey_data` WRITE;
/*!40000 ALTER TABLE `team_jersey_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `team_jersey_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_category_rel`
--

DROP TABLE IF EXISTS `template_category_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_category_rel` (
  `template_id` int(11) DEFAULT NULL,
  `category_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_category_rel`
--

LOCK TABLES `template_category_rel` WRITE;
/*!40000 ALTER TABLE `template_category_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `template_category_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_print_profile_rel`
--

DROP TABLE IF EXISTS `template_print_profile_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_print_profile_rel` (
  `template_id` int(11) NOT NULL,
  `print_profile_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_print_profile_rel`
--

LOCK TABLES `template_print_profile_rel` WRITE;
/*!40000 ALTER TABLE `template_print_profile_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `template_print_profile_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_tag_rel`
--

DROP TABLE IF EXISTS `template_tag_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_tag_rel` (
  `template_id` int(11) NOT NULL,
  `tag_id` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_tag_rel`
--

LOCK TABLES `template_tag_rel` WRITE;
/*!40000 ALTER TABLE `template_tag_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `template_tag_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `templates`
--

DROP TABLE IF EXISTS `templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `templates` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` int(11) NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `no_of_colors` int(11) DEFAULT NULL,
  `color_hash_codes` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template_index` smallint(4) DEFAULT NULL,
  `is_easy_edit` tinyint(1) DEFAULT '0',
  `total_used` int(11) DEFAULT '0',
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `is_imported` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `is_blank_canvas` tinyint(1) DEFAULT '0',
  `show_in_tool` tinyint(4) NOT NULL DEFAULT '1',
  `template_url` text COLLATE utf8_unicode_ci,
  `temp_token` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `templates`
--

LOCK TABLES `templates` WRITE;
/*!40000 ALTER TABLE `templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `xe_id` int(11) NOT NULL,
  `order_id` varchar(9) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount` decimal(20,8) DEFAULT NULL,
  `transaction_id` varchar(254) COLLATE utf8_unicode_ci NOT NULL,
  `payment_mode` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transactions`
--

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_designs`
--

DROP TABLE IF EXISTS `user_designs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_designs` (
  `xe_id` int(10) NOT NULL AUTO_INCREMENT,
  `customer_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `design_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `print_profile_id` int(11) DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_designs`
--

LOCK TABLES `user_designs` WRITE;
/*!40000 ALTER TABLE `user_designs` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_designs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_module_privilege_rel`
--

DROP TABLE IF EXISTS `user_module_privilege_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_module_privilege_rel` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `role_type` varchar(255) NOT NULL COMMENT 'Operator, Agent',
  `privilege_id` int(10) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_module_privilege_rel`
--

LOCK TABLES `user_module_privilege_rel` WRITE;
/*!40000 ALTER TABLE `user_module_privilege_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_module_privilege_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_privileges`
--

DROP TABLE IF EXISTS `user_privileges`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_privileges` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `store_id` int(4) DEFAULT NULL,
  `status` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_privileges`
--

LOCK TABLES `user_privileges` WRITE;
/*!40000 ALTER TABLE `user_privileges` DISABLE KEYS */;
INSERT INTO `user_privileges` VALUES (1,'Products',1,'1'),(2,'Assets',1,'1'),(3,'Print method',1,'1'),(4,'Global settings',1,'1'),(5,'Production Hub',1,'0'),(6,'Users',1,'0'),(7,'Customers',1,'1'),(8,'Quotation',1,'1'),(9,'Vendor and Purchase order',1,'1'),(10,'Orders',1,'1'),(11,'Production',1,'1');
/*!40000 ALTER TABLE `user_privileges` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_privileges_rel`
--

DROP TABLE IF EXISTS `user_privileges_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_privileges_rel` (
  `user_id` int(11) NOT NULL,
  `privilege_id` int(11) NOT NULL,
  `privilege_type` text COLLATE utf8_unicode_ci COMMENT 'vallue = all/{''view'':1, ''create'':0, ''update'':0, ''delete'':0}'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_privileges_rel`
--

LOCK TABLES `user_privileges_rel` WRITE;
/*!40000 ALTER TABLE `user_privileges_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_privileges_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_role_privileges_rel`
--

DROP TABLE IF EXISTS `user_role_privileges_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_role_privileges_rel` (
  `role_id` int(10) NOT NULL,
  `privilege_id` int(10) NOT NULL,
  `privilege_type` mediumtext COLLATE utf8_unicode_ci,
  `xe_id` int(10) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_role_privileges_rel`
--

LOCK TABLES `user_role_privileges_rel` WRITE;
/*!40000 ALTER TABLE `user_role_privileges_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_role_privileges_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_role_rel`
--

DROP TABLE IF EXISTS `user_role_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_role_rel` (
  `user_id` int(10) NOT NULL,
  `role_id` int(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_role_rel`
--

LOCK TABLES `user_role_rel` WRITE;
/*!40000 ALTER TABLE `user_role_rel` DISABLE KEYS */;
INSERT INTO `user_role_rel` VALUES (1,1);
/*!40000 ALTER TABLE `user_role_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_roles`
--

DROP TABLE IF EXISTS `user_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_roles` (
  `xe_id` int(10) NOT NULL AUTO_INCREMENT,
  `role_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `store_id` int(4) DEFAULT NULL,
  `is_default` tinyint(1) DEFAULT '0' COMMENT '0-not default, 1-default',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_roles`
--

LOCK TABLES `user_roles` WRITE;
/*!40000 ALTER TABLE `user_roles` DISABLE KEYS */;
INSERT INTO `user_roles` VALUES (1,'Super Admin',1,1),(2,'Operator',1,1),(3,'API User',1,1);
/*!40000 ALTER TABLE `user_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_store_rel`
--

DROP TABLE IF EXISTS `user_store_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_store_rel` (
  `user_id` int(7) NOT NULL,
  `store_id` int(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_store_rel`
--

LOCK TABLES `user_store_rel` WRITE;
/*!40000 ALTER TABLE `user_store_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_store_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_sub_module_privilege_rel`
--

DROP TABLE IF EXISTS `user_sub_module_privilege_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_sub_module_privilege_rel` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_module_privilege_id` int(11) NOT NULL,
  `action_id` int(11) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_sub_module_privilege_rel`
--

LOCK TABLES `user_sub_module_privilege_rel` WRITE;
/*!40000 ALTER TABLE `user_sub_module_privilege_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_sub_module_privilege_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_upload_image`
--

DROP TABLE IF EXISTS `user_upload_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_upload_image` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customer_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `original_file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `cloud_storage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_upload_image`
--

LOCK TABLES `user_upload_image` WRITE;
/*!40000 ALTER TABLE `user_upload_image` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_upload_image` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vendor`
--

DROP TABLE IF EXISTS `vendor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vendor` (
  `xe_id` int(7) NOT NULL AUTO_INCREMENT,
  `company_name` varchar(40) NOT NULL,
  `contact_name` varchar(40) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `logo` varchar(35) DEFAULT NULL,
  `country_code` varchar(30) DEFAULT NULL,
  `state_code` varchar(30) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `zip_code` varchar(30) DEFAULT NULL,
  `billing_address` text,
  `is_live` tinyint(1) NOT NULL DEFAULT '0',
  `store_id` int(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`xe_id`),
  KEY `vendor_index_key_01` (`company_name`,`contact_name`,`email`,`country_code`,`state_code`,`city`,`zip_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vendor`
--

LOCK TABLES `vendor` WRITE;
/*!40000 ALTER TABLE `vendor` DISABLE KEYS */;
/*!40000 ALTER TABLE `vendor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vendor_category_rel`
--

DROP TABLE IF EXISTS `vendor_category_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vendor_category_rel` (
  `vendor_id` int(7) NOT NULL,
  `category_id` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vendor_category_rel`
--

LOCK TABLES `vendor_category_rel` WRITE;
/*!40000 ALTER TABLE `vendor_category_rel` DISABLE KEYS */;
/*!40000 ALTER TABLE `vendor_category_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `word_cloud_category_rel`
--

DROP TABLE IF EXISTS `word_cloud_category_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `word_cloud_category_rel` (
  `word_cloud_id` bigint(20) DEFAULT NULL,
  `category_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `word_cloud_category_rel`
--

LOCK TABLES `word_cloud_category_rel` WRITE;
/*!40000 ALTER TABLE `word_cloud_category_rel` DISABLE KEYS */;
INSERT INTO `word_cloud_category_rel` VALUES (2,68),(3,68),(4,68),(5,68),(6,68),(7,68),(8,68),(9,68),(10,68),(11,68),(12,68),(13,68);
/*!40000 ALTER TABLE `word_cloud_category_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `word_cloud_tag_rel`
--

DROP TABLE IF EXISTS `word_cloud_tag_rel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `word_cloud_tag_rel` (
  `word_cloud_id` bigint(20) DEFAULT NULL,
  `tag_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `word_cloud_tag_rel`
--

LOCK TABLES `word_cloud_tag_rel` WRITE;
/*!40000 ALTER TABLE `word_cloud_tag_rel` DISABLE KEYS */;
INSERT INTO `word_cloud_tag_rel` VALUES (1,21),(2,22),(3,22),(4,22),(5,23),(6,24),(7,25),(8,26),(9,27),(10,28),(11,29),(12,30),(13,31);
/*!40000 ALTER TABLE `word_cloud_tag_rel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `word_clouds`
--

DROP TABLE IF EXISTS `word_clouds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `word_clouds` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(4) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `word_clouds`
--

LOCK TABLES `word_clouds` WRITE;
/*!40000 ALTER TABLE `word_clouds` DISABLE KEYS */;
INSERT INTO `word_clouds` VALUES (2,'Word CLoud','202003311017362243.png',1,'2020-03-31 10:17:36'),(3,'Word Cloud','20200331101855521.png',1,'2020-03-31 10:18:55'),(4,'Word Cloud','202003311019314430.png',1,'2020-03-31 10:19:31'),(5,'Word Cloud','202003311020073064.png',1,'2020-03-31 10:20:07'),(6,'Shapes','202003311020263641.png',1,'2020-03-31 10:20:26'),(7,'Heart','202003311020564536.png',1,'2020-03-31 10:20:56'),(8,'Arrow','20200331102120415.png',1,'2020-03-31 10:21:20'),(9,'Circle','20200331102137630.png',1,'2020-03-31 10:21:37'),(10,'Rectangle','202003311021546845.png',1,'2020-03-31 10:21:55'),(11,'Polygon','20200331102210581.png',1,'2020-03-31 10:22:10'),(12,'Oval','202003311022279060.png',1,'2020-03-31 10:22:27'),(13,'Star','202003311022477408.png',1,'2020-03-31 10:22:47');
/*!40000 ALTER TABLE `word_clouds` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-08-25  5:14:46
