<?php
/**
 * Email Log Model
 *
 * PHP version 5.6
 *
 * @category  Component
 * @package   Component
 * @author    Debashri Bhakat <debashrib@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://imprintnext.io
 */
namespace App\Components\Models;

/**
 * Email Log Model
 *
 * @category Component
 * @package  Component
 * @author   Debashri Bhakat <debashrib@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://imprintnext.io
 */
class EmailLog extends \Illuminate\Database\Eloquent\Model
{
    protected $primaryKey = 'xe_id';
    protected $table = 'email_log';
    protected $fillable = ['store_id' , 'module', 'type', 'subject', 'message', 'total_email_count', 'success_email', 'failure_email', 'skipped_email', 'clear_flag', 'created_date'];
    public $timestamps = false;
}
