<?php
/**
 * Woocommerce Store's Common functionalities will be written here
 *
 * PHP version 5.6
 *
 * @category  Woo-Commerce
 * @package   Store
 * @author    Tanmaya Patra <tanmayap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace CommonStoreSpace\Controllers;

use App\Components\Controllers\Component as ParentController;
use Automattic\WooCommerce\Client;

/**
 * Asset Type Class
 *
 * @category Woo-Commerce
 * @package  Store
 * @author   Tanmaya Patra <tanmayap@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class StoreController extends ParentController
{
    /**
     * Initialize Constructor
     * 
     * @var string
     */
    public $storePath = '';

     /**
     * Initialize variable
     * 
     * @var string
     */
    public $restURL = '';
    
    /**
     * Initialize Constructor
     */
    public function __construct()
    {
        $apiURL = str_replace('/'.BASE_DIR.'/', '/', API_URL);
        $this->restURL = $apiURL.'wp-json/ImprintnextProductDesigner/';
        $baseDirPath = explode(BASE_DIR, RELATIVE_PATH);
        $rootPath = $baseDirPath[0];
        $this->storePath = array('abspath' => $rootPath);
        $this->wc = new Client(
            $apiURL,
            API_CK,
            API_CS,
            [
                'wp_api' => true,
                'timeout' => 36000,
                'version' => API_VER,
                //'query_string_auth' => true,
                'verify_ssl' => IS_API_SECURE,
            ]
        );
        $this->includeWordPressCoreFile();
        set_time_limit(0);
    }

    /**
     * Include wordpress core file to get the default wc function accessible
     *
     * @author malay@riaxe.com
     * @date   11 Sept 2024
     */

    public function includeWordPressCoreFile() {
        // Include files from Wordpress core
        require_once $this->storePath['abspath'] . "wp-load.php";
    }

    /**
     * Get the response from the custome rest api get request
     *
     * @param $endpoint Rest endpoint
     * @param $params Parameters to be passed
     *
     * @author malay@riaxe.com
     * @date   11 Sept 2024
     * @return Array response
     */
    public function requestGet($endpoint, $params='') {
        $url = $this->restURL.$endpoint;
        if($params != ''){
            $buildQuery = http_build_query($params, '', '&');
            $url = $url.'?'.$buildQuery;
        }
        $wcResponse = wp_safe_remote_get($url);
        $response = json_clean_decode($wcResponse['body'],true);
        return $response;
    }

    /**
     * Get the response from the custome rest api post request
     *
     * @param $endpoint Rest endpoint
     * @param $params Parameters to be passed
     *
     * @author malay@riaxe.com
     * @date   11 Sept 2024
     * @return Array response
     */
    public function requestPost($endpoint, $params='') {
        $url = $this->restURL.$endpoint;
        if($params != ''){
            $buildQuery = http_build_query($params, '', '&');
            $url = $url.'?'.$buildQuery;
        }
        $wcResponse = wp_safe_remote_post($url);
        $response = json_clean_decode($wcResponse['body'],true);
        return $response;
    }
}
