<?php
/**
 * Routes
 *
 * PHP version 5.6
 *
 * @category  Routes
 * @package   SLIM_Routes
 * @author    Sanjeeb Dakhinaray <steve@imprintnext.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin ProductsController
 */

use App\Middlewares\ValidateJWTToken as ValidateJWT;

use App\Modules\Artwork\Controllers\ArtworkController as Artwork;

$container = $app->getContainer();


/**
 * Integration Routes List
 */
$app->group(
    '/artwork', function () use ($app) {
    $app->post('', Artwork::class . ':saveMarketPlaceArtwork');
    $app->get('', Artwork::class . ':getAllArtwork');
    }
)->add(new ValidateJWT($container));


