<?php
/**
 * This Model used for Order Artwork Conversation files
 * corresponding models
 *
 * PHP version 5.6
 *
 * @category  Orders
 * @package   Orders
 * @author    Diana <diana@imprintnext.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace App\Modules\Orders\Models;
/**
 * Orders Controller
 *
 * @category Orders
 * @package  Orders
 * @author   Diana <diana@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class ArtworkApprovalConvFiles extends \Illuminate\Database\Eloquent\Model {
	protected $table = 'artwork_approval_conv_files';
	protected $primaryKey = 'xe_id';
	protected $fillable = [
		'conv_id', 'file'
	];
	public $timestamps = false;
	protected $appends = ['thumbnail', 'file_name'];

    /**
     * Regenerate File Full URL for front-end
     *
     * @author debashrib@riaxe.com
     * @date   26 May 2019
     * @return file relation object
     */
    public function getFileNameAttribute()
    {
        if (isset($this->attributes['file']) 
            && $this->attributes['file'] != ""
        ) {
            return path('read', 'order') .'conversation/'. $this->attributes['file'];
        }
        return null;
    }
    /**
     * Regenerate Thumb File Full URL for front-end
     *
     * @author debashrib@riaxe.com
     * @date   26 May 2019
     * @return file relation object
     */
    public function getThumbnailAttribute()
    {
        if (isset($this->attributes['file'])
            && $this->attributes['file'] != ""
        ) {
            $pathInfo = pathinfo($this->attributes['file']);
            $fileExt = $pathInfo['extension'];
            $displayLogo = strtolower($fileExt) . '-logo.png';
            if ($fileExt == 'zip' || $fileExt == 'pdf' || $fileExt == 'PDF' || $fileExt == 'ZIP' || $fileExt == 'txt' || $fileExt == 'TXT') {
                return path('read', 'common') . $displayLogo;
            } else {
                if ($fileExt == 'svg' || $fileExt == 'SVG' || $fileExt == 'bmp' || $fileExt == 'BMP') {
                    return path('read', 'order') . 'conversation/'
                    . $this->attributes['file'];
                }
            }
            return path('read', 'order') .'conversation/'. 'thumb_' 
                . $this->attributes['file'];
        }
        return null;
    }
}
