<?php
/**
 * Product Side
 *
 * PHP version 5.6
 *
 * @category  Product Overlogo Sides
 * @package   Products
 * @author    Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
 * @copyright 2020-2021 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */

namespace App\Modules\OverLogo\Models;

/**
 * Product Side Class
 *
 * @category Overlogo Sides
 * @package  Products
 * @author   Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class ProductOverlogoSide extends \Illuminate\Database\Eloquent\Model
{
    protected $primaryKey = 'xe_id';
    protected $guarded = ['xe_id'];
    protected $fillable = [
        'product_setting_id', 
        'side_name', 
        'is_visible'
    ];
    public $timestamps = false;
    /**
     * Create One-to-Many relationship between Product Side and Product
     * Decoration Setting
     *
     * @author Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
     * @date   27 Oct 2021
     * @return relationship object of category
     */
    public function product_overlogo_decoration_setting()
    {
        return $this->hasMany(
            'App\Modules\Products\Models\ProductOverlogoDecorationSetting', 
            'product_side_id', 
            'xe_id' 
        );
    }
}
