<?php

/**
 * Product Options
 *
 * PHP version 5.6
 *
 * @category  Product_Variants
 * @package   Products
 * @author    Debasis Rath <dan@imprintnext.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */

namespace App\Modules\Products\Models;

/**
 * ProductOptions Class
 *
 * @category Product_Variants
 * @package  Products
 * @author   Debasis Rath <dan@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class ProductOptions extends \Illuminate\Database\Eloquent\Model
{
    protected $table = 'product_options';
    protected $primaryKey = 'xe_id';
    protected $guarded = ['xe_id'];

    protected $fillable = ['name'];

    public $timestamps = false;
    protected $modelPath = 'App\Modules\Products\Models';

     /**
     * Create One-to-Many relationship between ProductOptions and ProductOptionRel
     *
     * @author  Debasis Rath <dan@imprintnext.com>
     * @date    16-Nov-2022
     * @return relationship object of product options
     */
    public function optionVal()
    {
        return $this->hasOne(
            'App\Modules\Products\Models\ProductOptionRel',
            'option_id',
            'xe_id'
        );
    }
}