/* Update Settings value for dropbox_import settings in settings table */

UPDATE settings SET setting_value = '{"is_enabled":false}' WHERE setting_key = 'dropbox_import';

/* Update Settings value for google_drive_import settings in settings table */

UPDATE settings SET setting_value = '{"is_enabled":false}' WHERE setting_key = 'google_drive_import';
-- Add new column production_status in  orders table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'orders'
        AND table_schema = DATABASE()
        AND column_name IN('production_status')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE orders ADD production_status ENUM('0','1','2') NOT NULL DEFAULT '0' COMMENT '0-Not started, 1-In-Progress, 2-Completed';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column production_percentage in  orders table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'orders'
        AND table_schema = DATABASE()
        AND column_name IN('production_percentage')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE orders ADD production_percentage INT(4) NOT NULL DEFAULT 0;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column store_id in  orders table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'orders'
        AND table_schema = DATABASE()
        AND column_name IN('store_id')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE orders ADD store_id INT(4) NOT NULL DEFAULT 1;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column customer_id in  orders table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'orders'
        AND table_schema = DATABASE()
        AND column_name IN('customer_id')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE orders ADD customer_id VARCHAR(50) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add indexing in orders table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.STATISTICS
        WHERE table_name = 'orders'
        AND table_schema = DATABASE()
        AND index_name =  'orders_index_key_01'
    ) <= 0,
    "ALTER TABLE orders ADD INDEX orders_index_key_01 (order_id, customer_id);",
  "SELECT 1"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Data for the table `production_hub_settings` for Production 
INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '4', 'is_production', 'true', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings 
where store_id='1' and module_id='4' and setting_key='is_production');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '4', 'job_card', '{"prefix":"IM","starting_number":1,"postfix":"NXT"}', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings 
where store_id='1' and module_id='4' and setting_key='job_card');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '4', 'is_communication_enabled', 'true', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings 
where store_id='1' and module_id='4' and setting_key='is_communication_enabled');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '4', 'is_automatic_job_creation', 'false', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings 
where store_id='1' and module_id='4' and setting_key='is_automatic_job_creation');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '4', 'mandatory_purchase_order', 'false', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings  
where store_id='1' and module_id='4' and setting_key='mandatory_purchase_order');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '4', 'mark_as_done', 'true', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings  
where store_id='1' and module_id='4' and setting_key='mark_as_done');

-- Data for the table `production_status` for Production

INSERT INTO production_status (store_id, status_name, color_code, module_id, is_default, sort_order, status)
SELECT '1', 'Start Printing', '#49ce49', '4', '1', '1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, status_name FROM production_status  
where store_id='1' and module_id='4' and status_name='Start Printing');

INSERT INTO production_status (store_id, status_name, color_code, module_id, is_default, sort_order, status)
SELECT '1', 'Shipping', '#8c23e6', '4', '1', '2', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, status_name FROM production_status  
where store_id='1' and module_id='4' and status_name='Shipping');


-- Table structure for table `production_status_print_profile_rel` 

CREATE TABLE IF NOT EXISTS `production_status_print_profile_rel` (
  `status_id` int(11) DEFAULT NULL,
  `print_profile_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO production_status_print_profile_rel (status_id, print_profile_id)
SELECT (SELECT xe_id FROM production_status WHERE status_name = 'Start Printing' AND module_id = 4 AND store_id = 1), '1'
FROM DUAL
WHERE NOT EXISTS (SELECT status_id, print_profile_id FROM production_status_print_profile_rel where status_id= (SELECT xe_id FROM production_status WHERE status_name = 'Start Printing' AND module_id = 4 AND store_id = 1) and print_profile_id='1');

INSERT INTO production_status_print_profile_rel (status_id, print_profile_id)
SELECT (SELECT xe_id FROM production_status WHERE status_name = 'Start Printing' AND module_id = 4 AND store_id = 1), '2'
FROM DUAL
WHERE NOT EXISTS (SELECT status_id, print_profile_id FROM production_status_print_profile_rel where status_id= (SELECT xe_id FROM production_status WHERE status_name = 'Start Printing' AND module_id = 4 AND store_id = 1) and print_profile_id='2');

-- Table structure for table `production_status_features` 

CREATE TABLE IF NOT EXISTS `production_status_features` (
  `status_id` int(11) DEFAULT NULL,
  `duration` int(11) NOT NULL,
  `is_global` tinyint(1) NOT NULL DEFAULT '0',
  `is_group` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO production_status_features (status_id, duration, is_global, is_group)
SELECT (SELECT xe_id FROM production_status WHERE status_name = 'Start Printing' AND module_id = 4 AND store_id = 1), '12', '0', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT status_id FROM production_status_features where status_id= (SELECT xe_id FROM production_status WHERE status_name = 'Start Printing' AND module_id = 4 AND store_id = 1));

INSERT INTO production_status_features (status_id, duration, is_global, is_group)
SELECT (SELECT xe_id FROM production_status WHERE status_name = 'Shipping' AND module_id = 4 AND store_id = 1), '12', '1', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT status_id FROM production_status_features where status_id= (SELECT xe_id FROM production_status WHERE status_name = 'Shipping' AND module_id = 4 AND store_id = 1));


-- Table structure for table `production_status_assignee_rel` 

CREATE TABLE IF NOT EXISTS `production_status_assignee_rel` (
  `status_id` int(11) NOT NULL,
  `assignee_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Data for the table `production_email_templates` 
INSERT INTO production_email_templates (store_id, module_id, template_type_name, subject, message, is_configured)
SELECT '1', '4', 'start_printing', 'Updates on your order id #{order_id}', '<span>Hi {customer_name},<br><br>We are happy to inform you that the printing of the item {item_name} for order id# {order_id} is completed.You will be notified further on your order related updates.<br><br>Thank you.</span><br>', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, template_type_name FROM production_email_templates  
where store_id='1' and module_id='4' and template_type_name='start_printing');

INSERT INTO production_email_templates (store_id, module_id, template_type_name, subject, message, is_configured)
SELECT '1', '4', 'shipping', 'Updates on your order id #{order_id}', '<span>Hi {customer_name},<br><br>We are happy to inform you that the shipping of the item {item_name} for order id# {order_id} is completed.You will be notified with the shipping details very soon.<br><br>Thank you.</span><br>', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, template_type_name FROM production_email_templates  
where store_id='1' and module_id='4' and template_type_name='shipping');

-- Data for the table `production_template_abbriviations` for Production 

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{job_id}','4'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations  
where abbr_name='{job_id}' and module_id='4');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{order_id}','4'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations  
where abbr_name='{order_id}' and module_id='4');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{order_item_id}','4'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations  
where abbr_name='{order_item_id}' and module_id='4');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{customer_name}','4'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations  
where abbr_name='{customer_name}' and module_id='4');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{customer_email}','4'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations  
where abbr_name='{customer_email}' and module_id='4');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{item_name}','4'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations  
where abbr_name='{item_name}' and module_id='4');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{print_profile}','4'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations  
where abbr_name='{print_profile}' and module_id='4');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{stage_name}','4'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations  
where abbr_name='{stage_name}' and module_id='4');

-- Table structure for table production_jobs 

CREATE TABLE IF NOT EXISTS `production_jobs` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` INT(4) NOT NULL,
  `job_id` VARCHAR(30) NOT NULL,
  `order_id` VARCHAR(50) NOT NULL,
  `order_item_id` VARCHAR(50) NOT NULL,
  `order_item_quantity` INT(11) NOT NULL,
  `job_title` VARCHAR(255) NOT NULL,
  `job_status` ENUM('not-started','progressing','completed','delay') NOT NULL DEFAULT 'not-started',
  `note` TEXT  NULL,
  `comp_percentage` INT(4) NOT NULL DEFAULT 0,
  `due_date` DATETIME  NULL,
  `scheduled_date` DATETIME  NULL,
  `created_at` DATETIME NOT NULL,
  `current_stage_id` INT(11) NOT NULL,
  PRIMARY KEY (xe_id),
  KEY production_jobs_index_key_01 (job_id,order_id,job_title,store_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table production_job_notes 

CREATE TABLE IF NOT EXISTS `production_job_notes` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `job_id` int(11) NOT NULL,
  `note` TEXT NOT NULL,
  `user_type` ENUM('admin','agent') NOT NULL , 
  `user_id` INT(11) NOT NULL , 
  `seen_flag` ENUM('0','1') NOT NULL DEFAULT '0',
  `created_date` DATETIME NOT NULL,
  PRIMARY KEY (xe_id),
  KEY production_job_notes_index_key_01 (job_id,created_date)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table `quote_internal_note_files` 

CREATE TABLE IF NOT EXISTS `production_job_note_files` ( 
  `xe_id` INT(11) NOT NULL AUTO_INCREMENT , 
  `note_id` INT(11) NOT NULL ,
  `file` VARCHAR(255) NOT NULL ,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table production_job_stages 

CREATE TABLE IF NOT EXISTS `production_job_stages` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `job_id` INT(11) NOT NULL,
  `print_method_id` INT(11) NOT NULL,
  `stages_id` INT(11) NOT NULL,
  `stage_name` VARCHAR(255) NOT NULL,
  `stage_color_code` VARCHAR(255) NOT NULL,
  `created_date` DATETIME NOT NULL,
  `starting_date` DATETIME  NULL,
  `exp_completion_date` DATETIME  NULL,
  `completion_date` DATETIME NULL,
  `status` ENUM('not-started','in-progress','completed','delay') NOT NULL DEFAULT 'in-progress',
  `message` TEXT NULL,
  PRIMARY KEY (xe_id),
  KEY production_job_stages_index_key_01 (job_id,print_method_id,stages_id,exp_completion_date)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table production_job_agents 

CREATE TABLE IF NOT EXISTS `production_job_agents` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `job_id` INT(11) NOT NULL,
  `job_stage_id` INT(11) NOT NULL,
  `is_group` TINYINT(1) NOT NULL,
  `agent_id` INT(11) NOT NULL,
  PRIMARY KEY (xe_id),
  KEY production_job_agents_index_key_01 (job_id,job_stage_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table production_job_log 

CREATE TABLE IF NOT EXISTS `production_job_log` (
  `xe_id` INT(11) NOT NULL AUTO_INCREMENT,
  `job_id` INT(11) NOT NULL,
  `title` VARCHAR(255) NOT NULL,
  `description` TEXT NULL,
  `user_type` ENUM('admin','agent','customer') NOT NULL,
  `user_id` INT(11) NOT NULL,
  `created_date` DATETIME NOT NULL,
  PRIMARY KEY (xe_id),
  KEY production_job_log_index_key_01 (job_id,created_date)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




/*Table structure for table purchase_order*/

CREATE TABLE IF NOT EXISTS purchase_order (
  xe_id int(11)  NOT NULL AUTO_INCREMENT,
  po_id varchar(20) NOT NULL,
  status_id int(4) NOT NULL,
  store_id int(4) NOT NULL,
  vendor_id int(7) NOT NULL,
  ship_address_id int(7) NOT NULL,
  po_notes text DEFAULT NULL,
  expected_delivery_date date NOT NULL,
  created_at date NOT NULL,
  PRIMARY KEY(xe_id)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Table structure for table purchase_order_details*/

CREATE TABLE IF NOT EXISTS purchase_order_items (
  xe_id int(11) NOT NULL AUTO_INCREMENT,
  purchase_order_id int(11) NOT NULL,
  order_id varchar(60) NOT NULL,
  order_item_id varchar(60) NOT NULL,
  status_id int(4) NOT NULL,
  PRIMARY KEY(xe_id)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Table structure for table po_line_item_status*/

CREATE TABLE IF NOT EXISTS po_line_item_status (
  xe_id int(7) NOT NULL AUTO_INCREMENT,
  store_id int(4) NOT NULL,
  status_name varchar(20) NOT NULL,
  color_code varchar(10) NOT NULL,
  is_default enum('1','0') NOT NULL DEFAULT '1',
  sort_order int(4) NOT NULL,
  status enum('1','0') NOT NULL DEFAULT '1',
  PRIMARY KEY(xe_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


/*Table structure for table `purchase_order_status`*/

CREATE TABLE `purchase_order_status` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `status_name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `color_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `module_id` int(11) NOT NULL,
  `is_default` enum('0','1') COLLATE utf8_unicode_ci NOT NULL,
  `sort_order` int(4) NOT NULL,
  `status` enum('1','0') COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COLLATE=utf8_unicode_ci;

-- Data for the table `purchase_order_status`

INSERT INTO purchase_order_status (xe_id, store_id, status_name, color_code, module_id, is_default, sort_order, status)
SELECT '6', '1', 'PO sent', '#1a73e8', '3', '1', '1', '1'
FROM DUAL WHERE NOT EXISTS (SELECT xe_id, store_id, module_id, status_name FROM purchase_order_status  
WHERE xe_id='6' and store_id='1' and module_id='3' and status_name='PO sent');

INSERT INTO purchase_order_status (xe_id, store_id, status_name, color_code, module_id, is_default, sort_order, status)
SELECT '7', '1', 'Partially received', '#f23cfd', '3', '1', '3', '1'
FROM DUAL WHERE NOT EXISTS (SELECT xe_id, store_id, module_id, status_name FROM purchase_order_status  
WHERE xe_id='7' and store_id='1' and module_id='3' and status_name='Partially received');

INSERT INTO purchase_order_status (xe_id, store_id, status_name, color_code, module_id, is_default, sort_order, status)
SELECT '8', '1', 'Received', '#49ce49', '3', '1', '4', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT xe_id, store_id, module_id, status_name FROM purchase_order_status  
WHERE xe_id='8' and store_id='1' and module_id='3' and status_name='Received');

INSERT INTO purchase_order_status (xe_id, store_id, status_name, color_code, module_id, is_default, sort_order, status)
SELECT '9', '1', 'Pending', '#e4d23d', '3', '1', '2', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT xe_id, store_id, module_id, status_name FROM purchase_order_status  
WHERE xe_id='9' and store_id='1' and module_id='3' and status_name='Pending');

-- Insert data into po_line_item_status table

INSERT INTO po_line_item_status (xe_id, store_id, status_name, color_code,is_default,sort_order,status)  
SELECT '1', '1', 'Pending', '#fabc02', '1','1', '1' FROM DUAL WHERE NOT EXISTS (SELECT * FROM po_line_item_status WHERE xe_id=1);

INSERT INTO po_line_item_status (xe_id, store_id, status_name, color_code,is_default,sort_order,status)  
SELECT '2', '1', 'Out of stock', '#FF0000', '1','2', '1' FROM DUAL WHERE NOT EXISTS (SELECT * FROM po_line_item_status WHERE xe_id=2);

INSERT INTO po_line_item_status (xe_id, store_id, status_name, color_code,is_default,sort_order,status)  
SELECT '3', '1', 'Received', '#33a952', '1','3', '1' FROM DUAL WHERE NOT EXISTS (SELECT * FROM po_line_item_status WHERE xe_id=3);

INSERT INTO po_line_item_status (xe_id, store_id, status_name, color_code,is_default,sort_order,status)  
SELECT '4', '1', 'PO sent', '#cc8800', '1','4', '0' FROM DUAL WHERE NOT EXISTS (SELECT * FROM po_line_item_status WHERE xe_id=4);

INSERT INTO po_line_item_status (xe_id, store_id, status_name, color_code,is_default,sort_order,status)  
SELECT '5', '1', 'Partially received', '#997300', '1','5', '0' FROM DUAL WHERE NOT EXISTS (SELECT * FROM po_line_item_status WHERE xe_id=5);

/*Table structure for table `po_log` */

CREATE TABLE IF NOT EXISTS `po_log` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `po_id` int(11) NOT NULL,
  `description` text NULL,
  `user_type` enum('admin','customer','agent') NULL COMMENT 'i.e agent data in case of agent assignment  ',
  `user_id` int(11) NULL COMMENT 'i.e agent data in case of agent assignment',
  `created_date` datetime NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



/*Table structure for table `po_internal_note` */

CREATE TABLE IF NOT EXISTS `po_internal_note` ( 
  `xe_id` INT(11) NOT NULL AUTO_INCREMENT , 
  `po_id` INT(11) NOT NULL , 
  `user_type` ENUM('admin','agent') NOT NULL , 
  `user_id` INT(11) NOT NULL , 
  `note` TEXT NULL , 
  `seen_flag` ENUM('0','1') NOT NULL DEFAULT '0', 
  `created_date` TIMESTAMP NOT NULL , 
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Table structure for table `po_internal_note_files` */

CREATE TABLE IF NOT EXISTS `po_internal_note_files` ( 
  `xe_id` INT(11) NOT NULL AUTO_INCREMENT , 
  `note_id` INT(11) NOT NULL ,
  `file` VARCHAR(255) NOT NULL ,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Add 'po_status' column in orders table*/

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'orders'
        AND table_schema = DATABASE()
        AND column_name IN('po_status')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE orders ADD po_status INT(7) NOT NULL DEFAULT  '0' ;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Data for the table `production_hub_settings` for Production 

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '3', 'synchronize_with_store', 'true', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings 
WHERE store_id='1' and module_id='3' and setting_key='synchronize_with_store');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '3', 'purchase_order_id', '{"prefix":"PO","starting_number":4448,"postfix":"XE"}', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings 
WHERE store_id='1' and module_id='3' and setting_key='purchase_order_id');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '3', 'convert_order', '{"is_enabled":true,"conversion_days":7,"is_order_qty_exception_enabled":true,"order_qty":1,"is_rush_order_exception_enabled":false}', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings 
WHERE store_id='1' and module_id='3' and setting_key='convert_order');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '3', 'last_po_date', '{"date":""}', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings 
WHERE store_id='1' and module_id='3' and setting_key='last_po_date');
/* Add new column decoration_settings_id in quote_item_files table */

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_item_files'
        AND table_schema = DATABASE()
        AND column_name IN('decoration_settings_id')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_item_files ADD decoration_settings_id INT(11) NOT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

/*Data for the table `production_template_abbriviations` */

INSERT INTO `production_template_abbriviations` (`abbr_name`,`module_id`) VALUES
  ('{quote_total_amount}','1');
/*Table structure for table ship_to_address*/

CREATE TABLE IF NOT EXISTS ship_to_address (
  xe_id int(7) NOT NULL AUTO_INCREMENT,
  name varchar(40) NOT NULL,
  email varchar(50) NOT NULL,
  phone varchar(20) DEFAULT NULL,
  company_name varchar(30) DEFAULT NULL,
  country_code varchar(12) DEFAULT NULL,
  state_code varchar(20) DEFAULT NULL,
  city varchar(50) DEFAULT NULL,
  zip_code varchar(12) DEFAULT NULL,
  ship_address text,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
/*Table structure for table vendor*/

CREATE TABLE IF NOT EXISTS vendor (
  xe_id int(7)  NOT NULL AUTO_INCREMENT,
  company_name varchar(40) NOT NULL,
  contact_name varchar(40) NOT NULL,
  email varchar(50) NOT NULL,
  phone varchar(20) DEFAULT NULL,
  logo varchar(35) DEFAULT NULL,
  country_code varchar(30) DEFAULT NULL,
  state_code varchar(30) DEFAULT NULL,
  city varchar(50) DEFAULT NULL,
  zip_code varchar(30) DEFAULT NULL,
  billing_address text,
  is_live tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table vendor_category_rel*/

CREATE TABLE IF NOT EXISTS vendor_category_rel (
  vendor_id int(7) NOT NULL,
  category_id varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;