/* Add 'file_name' column in categories table*/

  SET @s = (SELECT IF(
  	(SELECT COUNT(*)
  		FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'categories'
  	 	AND table_schema = DATABASE()
  		AND column_name IN('file_name')
  		) > 0 ,
  	"SELECT 1",
  	"ALTER TABLE `categories` ADD `file_name` varchar(60) NULL;"
  	));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

/* Add 'cloud_storage' column in categories table*/
SET @s = (SELECT IF(
      (SELECT COUNT(*)
          FROM INFORMATION_SCHEMA.COLUMNS
          WHERE table_name = 'categories'
           AND table_schema = DATABASE()
          AND column_name IN('cloud_storage')
          ) > 0 ,
      "SELECT 1",
      "ALTER TABLE `categories` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
      ));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;